/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.codehaus.plexus.component.annotations.Component;
import org.commonjava.maven.ext.manip.ManipulationException;
import org.commonjava.maven.ext.manip.ManipulationSession;
import org.commonjava.maven.ext.manip.impl.Manipulator;
import org.commonjava.maven.ext.manip.model.Project;
import org.commonjava.maven.ext.manip.state.ProjectVersionEnforcingState;
import org.commonjava.maven.ext.manip.state.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=Manipulator.class, hint="enforce-project-version")
public class ProjectVersionEnforcingManipulator
implements Manipulator {
    private static final String PROJVER = "${project.version}";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected ProjectVersionEnforcingManipulator() {
    }

    @Override
    public void init(ManipulationSession session) {
        session.setState(new ProjectVersionEnforcingState(session.getUserProperties()));
    }

    @Override
    public void scan(List<Project> projects, ManipulationSession session) throws ManipulationException {
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects, ManipulationSession session) throws ManipulationException {
        ProjectVersionEnforcingState state = session.getState(ProjectVersionEnforcingState.class);
        if (!(session.isEnabled() && session.anyStateEnabled(State.activeByDefault) && state != null && state.isEnabled())) {
            this.logger.debug("Project version enforcement is disabled.");
            return Collections.emptySet();
        }
        HashSet<Project> changed = new HashSet<Project>();
        for (Project project : projects) {
            List profiles;
            Model model = project.getModel();
            if (!model.getPackaging().equals("pom")) continue;
            this.enforceProjectVersion(project, model.getDependencies(), changed);
            if (model.getDependencyManagement() != null) {
                this.enforceProjectVersion(project, model.getDependencyManagement().getDependencies(), changed);
            }
            if ((profiles = model.getProfiles()) == null) continue;
            for (Profile profile : model.getProfiles()) {
                this.enforceProjectVersion(project, profile.getDependencies(), changed);
                if (profile.getDependencyManagement() == null) continue;
                this.enforceProjectVersion(project, profile.getDependencyManagement().getDependencies(), changed);
            }
        }
        if (changed.size() > 0) {
            this.logger.warn("Using ${project.version} in pom files may lead to unexpected errors with inheritance.");
        }
        return changed;
    }

    private void enforceProjectVersion(Project project, List<Dependency> dependencies, Set<Project> changed) {
        for (Dependency d : dependencies) {
            if (d.getVersion() == null || !d.getVersion().contains(PROJVER)) continue;
            String newVersion = project.getModel().getVersion() == null ? project.getModel().getParent().getVersion() : project.getModel().getVersion();
            this.logger.info("Replacing project.version within {} for project {} with {}", new Object[]{d, project, newVersion});
            this.logger.debug("Original version is " + project.getVersion() + " and model is " + project.getModel());
            d.setVersion(newVersion);
            changed.add(project);
        }
    }

    @Override
    public int getExecutionIndex() {
        return 99;
    }
}

