/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.Model;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.manip.ManipulationException;
import org.commonjava.maven.ext.manip.ManipulationSession;
import org.commonjava.maven.ext.manip.impl.Manipulator;
import org.commonjava.maven.ext.manip.io.ModelIO;
import org.commonjava.maven.ext.manip.model.Project;
import org.commonjava.maven.ext.manip.state.PropertyState;
import org.commonjava.maven.ext.manip.util.IdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=Manipulator.class, hint="property-manipulator")
public class PropertyManipulator
implements Manipulator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Requirement
    protected ModelIO effectiveModelBuilder;

    @Override
    public void init(ManipulationSession session) {
        Properties userProps = session.getUserProperties();
        session.setState(new PropertyState(userProps));
    }

    @Override
    public void scan(List<Project> projects, ManipulationSession session) throws ManipulationException {
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects, ManipulationSession session) throws ManipulationException {
        PropertyState state = session.getState(PropertyState.class);
        if (!session.isEnabled() || !state.isEnabled()) {
            this.logger.debug(this.getClass().getSimpleName() + ": Nothing to do!");
            return Collections.emptySet();
        }
        Properties overrides = this.loadRemotePOMProperties(state.getRemotePropertyMgmt(), session);
        HashSet<Project> changed = new HashSet<Project>();
        for (Project project : projects) {
            Model model = project.getModel();
            if (overrides.size() <= 0) continue;
            if (project.isInheritanceRoot()) {
                this.logger.info("Applying property changes to: " + IdUtils.ga(project) + " with " + overrides);
                model.getProperties().putAll((Map<?, ?>)overrides);
                changed.add(project);
                continue;
            }
            HashSet<Object> keyClone = new HashSet<Object>(model.getProperties().keySet());
            keyClone.retainAll(overrides.keySet());
            if (keyClone.size() <= 0) continue;
            for (String string : keyClone) {
                this.logger.info("Overwriting property (" + string + " in: " + IdUtils.ga(project) + " with value " + overrides.get(string));
                model.getProperties().put(string, overrides.get(string));
                changed.add(project);
            }
        }
        return changed;
    }

    private Properties loadRemotePOMProperties(List<ProjectVersionRef> remoteMgmt, ManipulationSession session) throws ManipulationException {
        Properties overrides = new Properties();
        if (remoteMgmt == null || remoteMgmt.isEmpty()) {
            return overrides;
        }
        ListIterator<ProjectVersionRef> listIterator = remoteMgmt.listIterator(remoteMgmt.size());
        while (listIterator.hasPrevious()) {
            ProjectVersionRef ref = listIterator.previous();
            overrides.putAll((Map<?, ?>)this.effectiveModelBuilder.getRemotePropertyMappingOverrides(ref, session));
        }
        return overrides;
    }

    @Override
    public int getExecutionIndex() {
        return 20;
    }
}

