/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.codehaus.plexus.component.annotations.Component;
import org.commonjava.maven.ext.manip.ManipulationException;
import org.commonjava.maven.ext.manip.ManipulationSession;
import org.commonjava.maven.ext.manip.impl.Manipulator;
import org.commonjava.maven.ext.manip.model.Project;
import org.commonjava.maven.ext.manip.state.RepoReportingState;
import org.commonjava.maven.ext.manip.util.IdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=Manipulator.class, hint="enforce-repo-reporting-removal")
public class RepoAndReportingRemovalManipulator
implements Manipulator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void scan(List<Project> projects, ManipulationSession session) throws ManipulationException {
    }

    @Override
    public void init(ManipulationSession session) {
        Properties userProps = session.getUserProperties();
        session.setState(new RepoReportingState(userProps));
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects, ManipulationSession session) throws ManipulationException {
        RepoReportingState state = session.getState(RepoReportingState.class);
        if (!session.isEnabled() || !state.isEnabled()) {
            this.logger.debug(this.getClass().getSimpleName() + ": Nothing to do!");
            return Collections.emptySet();
        }
        HashSet<Project> changed = new HashSet<Project>();
        for (Project project : projects) {
            List profiles;
            String ga = IdUtils.ga(project);
            this.logger.info(this.getClass().getSimpleName() + " applying changes to: " + ga);
            Model model = project.getModel();
            if (model.getRepositories() != null && !model.getRepositories().isEmpty()) {
                model.setRepositories(new ArrayList());
                changed.add(project);
            }
            if (model.getPluginRepositories() != null && !model.getPluginRepositories().isEmpty()) {
                model.setPluginRepositories(new ArrayList());
                changed.add(project);
            }
            if (model.getReporting() != null) {
                model.setReporting(null);
                changed.add(project);
            }
            if ((profiles = model.getProfiles()).isEmpty()) continue;
            for (Profile profile : profiles) {
                if (!profile.getRepositories().isEmpty()) {
                    profile.setRepositories(new ArrayList());
                    changed.add(project);
                }
                if (!profile.getPluginRepositories().isEmpty()) {
                    profile.setPluginRepositories(new ArrayList());
                    changed.add(project);
                }
                if (profile.getReporting() == null) continue;
                profile.setReporting(null);
                changed.add(project);
            }
        }
        return changed;
    }

    @Override
    public int getExecutionIndex() {
        return 45;
    }
}

