/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.commonjava.maven.ext.manip.ManipulationException;
import org.commonjava.maven.ext.manip.ManipulationSession;
import org.commonjava.maven.ext.manip.impl.Manipulator;
import org.commonjava.maven.ext.manip.io.ModelIO;
import org.commonjava.maven.ext.manip.model.Project;
import org.commonjava.maven.ext.manip.state.RepositoryInjectionState;
import org.commonjava.maven.ext.manip.util.IdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=Manipulator.class, hint="repository-injection")
public class RepositoryInjectionManipulator
implements Manipulator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Requirement
    protected ModelIO modelBuilder;

    @Override
    public void scan(List<Project> projects, ManipulationSession session) throws ManipulationException {
    }

    @Override
    public void init(ManipulationSession session) {
        Properties userProps = session.getUserProperties();
        session.setState(new RepositoryInjectionState(userProps));
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects, ManipulationSession session) throws ManipulationException {
        RepositoryInjectionState state = session.getState(RepositoryInjectionState.class);
        if (!session.isEnabled() || !state.isEnabled()) {
            this.logger.debug(this.getClass().getSimpleName() + ": Nothing to do!");
            return Collections.emptySet();
        }
        HashSet<Project> changed = new HashSet<Project>();
        Model remoteModel = this.modelBuilder.resolveRawModel(state.getRemoteRepositoryInjectionMgmt());
        List remoteRepositories = remoteModel.getRepositories();
        List remotePluginRepositories = remoteModel.getPluginRepositories();
        for (Project project : projects) {
            String ga = IdUtils.ga(project);
            this.logger.info(this.getClass().getSimpleName() + " applying changes to: " + ga);
            Model model = project.getModel();
            if (!project.isInheritanceRoot()) continue;
            List repositories = model.getRepositories();
            if (!remoteRepositories.isEmpty()) {
                Iterator i1 = remoteRepositories.iterator();
                while (i1.hasNext()) {
                    this.addRepository(repositories, (Repository)i1.next());
                }
                changed.add(project);
            }
            List pluginRepositories = model.getPluginRepositories();
            if (remotePluginRepositories.isEmpty()) continue;
            Iterator i2 = remotePluginRepositories.iterator();
            while (i2.hasNext()) {
                this.addRepository(pluginRepositories, (Repository)i2.next());
            }
            changed.add(project);
        }
        return changed;
    }

    private void addRepository(List<Repository> repositories, Repository repository) {
        Iterator<Repository> i = repositories.iterator();
        while (i.hasNext()) {
            Repository r = i.next();
            if (!repository.getId().equals(r.getId())) continue;
            this.logger.debug("Removing local repository {} ", (Object)r);
            i.remove();
            break;
        }
        this.logger.debug("Adding repository {}", (Object)repository);
        repositories.add(repository);
    }

    @Override
    public int getExecutionIndex() {
        return 55;
    }
}

