/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.ext.manip.ManipulationException;
import org.commonjava.maven.ext.manip.ManipulationSession;
import org.commonjava.maven.ext.manip.impl.Version;
import org.commonjava.maven.ext.manip.model.Project;
import org.commonjava.maven.ext.manip.resolver.GalleyAPIWrapper;
import org.commonjava.maven.ext.manip.state.VersioningState;
import org.commonjava.maven.ext.manip.util.IdUtils;
import org.commonjava.maven.galley.maven.GalleyMavenException;
import org.commonjava.maven.galley.maven.model.view.meta.MavenMetadataView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=VersionCalculator.class)
public class VersionCalculator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Requirement
    protected GalleyAPIWrapper readerWrapper;

    protected VersionCalculator() {
    }

    public VersionCalculator(GalleyAPIWrapper readerWrapper) {
        this.readerWrapper = readerWrapper;
    }

    public Map<String, String> calculateVersioningChanges(Collection<Project> projects, ManipulationSession session) throws ManipulationException {
        String modifiedVersionString;
        Version modifiedVersion;
        String originalVersion;
        VersioningState state = session.getState(VersioningState.class);
        HashMap<String, String> versionsByGA = new HashMap<String, String>();
        HashMap<String, Version> versionObjsByGA = new HashMap<String, Version>();
        HashSet<String> versionSet = new HashSet<String>();
        for (Project project : projects) {
            originalVersion = project.getVersion();
            modifiedVersion = this.calculate(project.getGroupId(), project.getArtifactId(), originalVersion, session);
            versionObjsByGA.put(IdUtils.gav(project), modifiedVersion);
            modifiedVersionString = state.osgi() ? modifiedVersion.getOSGiVersionString() : modifiedVersion.getVersionString();
            if (!modifiedVersion.hasBuildNumber()) continue;
            versionSet.add(modifiedVersionString);
        }
        for (Project project : projects) {
            originalVersion = project.getVersion();
            modifiedVersion = (Version)versionObjsByGA.get(IdUtils.gav(project));
            int buildNumber = modifiedVersion.findHighestMatchingBuildNumber(modifiedVersion, versionSet);
            if (buildNumber > 0) {
                modifiedVersion.setBuildNumber(Integer.toString(buildNumber));
            }
            modifiedVersionString = state.osgi() ? modifiedVersion.getOSGiVersionString() : modifiedVersion.getVersionString();
            versionSet.add(modifiedVersionString);
            this.logger.debug(IdUtils.gav(project) + " has updated version: {}. Marking for rewrite.", (Object)modifiedVersionString);
            if (originalVersion.equals(modifiedVersionString)) continue;
            versionsByGA.put(IdUtils.gav(project), modifiedVersionString);
        }
        return versionsByGA;
    }

    protected Version calculate(String groupId, String artifactId, String version, ManipulationSession session) throws ManipulationException {
        VersioningState state = session.getState(VersioningState.class);
        String incrementalSuffix = state.getIncrementalSerialSuffix();
        String staticSuffix = state.getSuffix();
        String override = state.getOverride();
        this.logger.debug("Got the following version:\n  Original version: " + version);
        this.logger.debug("Got the following version suffixes:\n  Static: " + staticSuffix + "\n  Incremental: " + incrementalSuffix);
        this.logger.debug("Got the following override:\n  Version: " + override);
        Version versionObj = override != null ? new Version(override) : new Version(version);
        if (staticSuffix != null) {
            versionObj.appendQualifierSuffix(staticSuffix);
            if (!state.preserveSnapshot()) {
                versionObj.setSnapshot(false);
            }
        } else if (incrementalSuffix != null) {
            HashSet<String> versionCandidates = new HashSet<String>();
            versionCandidates.addAll(this.getMetadataVersions(groupId, artifactId));
            versionObj.appendQualifierSuffix(incrementalSuffix);
            int highestRemoteBuildNum = versionObj.findHighestMatchingBuildNumber(versionObj, versionCandidates);
            if (++highestRemoteBuildNum > versionObj.getIntegerBuildNumber()) {
                versionObj.setBuildNumber(Integer.toString(highestRemoteBuildNum));
            }
            if (!state.preserveSnapshot()) {
                versionObj.setSnapshot(false);
            }
        }
        return versionObj;
    }

    private Set<String> getMetadataVersions(String groupId, String artifactId) throws ManipulationException {
        this.logger.debug("Reading available versions from repository metadata for: " + groupId + ":" + artifactId);
        try {
            MavenMetadataView metadataView = this.readerWrapper.readMetadataView(new ProjectRef(groupId, artifactId));
            List versions = metadataView.resolveXPathToAggregatedStringList("/metadata/versioning/versions/version", true, -1);
            return new HashSet<String>(versions);
        }
        catch (GalleyMavenException e) {
            throw new ManipulationException("Failed to resolve metadata for: %s:%s.", (Throwable)e, groupId, artifactId);
        }
    }
}

