/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.manip.resolver.GalleyAPIWrapper;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.util.UrlUtils;

public class GalleyModelResolver
implements ModelResolver {
    private final GalleyAPIWrapper galleyWrapper;

    public GalleyModelResolver(GalleyAPIWrapper galleyWrapper) {
        this.galleyWrapper = galleyWrapper;
    }

    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        Transfer transfer;
        ArtifactRef ar = new ProjectVersionRef(groupId, artifactId, version).asPomArtifact();
        try {
            transfer = this.galleyWrapper.resolveArtifact(ar);
        }
        catch (TransferException e) {
            throw new UnresolvableModelException("Failed to resolve POM: " + e.getMessage(), groupId, artifactId, version, (Throwable)e);
        }
        if (transfer == null) {
            throw new UnresolvableModelException("Failed to resolve POM: " + ar, groupId, artifactId, version);
        }
        return new TransferModelSource(transfer);
    }

    public void addRepository(Repository repository) throws InvalidRepositoryException {
    }

    public ModelResolver newCopy() {
        return this;
    }

    private static final class TransferModelSource
    implements ModelSource {
        private final Transfer transfer;

        public TransferModelSource(Transfer transfer) {
            this.transfer = transfer;
        }

        public InputStream getInputStream() throws IOException {
            return this.transfer.openInputStream();
        }

        public String getLocation() {
            String location = null;
            try {
                location = UrlUtils.buildUrl((String)this.transfer.getLocation().getUri(), (String[])new String[]{this.transfer.getPath()});
            }
            catch (MalformedURLException e) {
                location = this.transfer.toString();
            }
            return location;
        }
    }
}

