/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.apache.maven.io.util.DocumentModifier;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.jdom.MavenJDOMWriter;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.manip.ManipulationException;
import org.commonjava.maven.ext.manip.model.Project;
import org.commonjava.maven.galley.maven.parse.PomPeek;
import org.jdom2.Comment;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.filter.ContentFilter;
import org.jdom2.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=PomIO.class)
public class PomIO {
    private static final String MODIFIED_BY = "[Comment: <!-- Modified by POM Manipulation Extension for Maven";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected PomIO() {
    }

    public List<Project> parseProject(File pom) throws ManipulationException {
        List<PomPeek> peeked = this.peekAtPomHierarchy(pom);
        return this.readModelsForManipulation(pom, peeked);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Project> readModelsForManipulation(File executionRoot, List<PomPeek> peeked) throws ManipulationException {
        ArrayList<Project> projects = new ArrayList<Project>();
        Iterator<PomPeek> i$ = peeked.iterator();
        while (i$.hasNext()) {
            PomPeek peek = i$.next();
            File pom = peek.getPom();
            this.logger.debug("Reading raw model for: " + pom);
            Model raw = null;
            FileInputStream in = null;
            try {
                in = new FileInputStream(pom);
                raw = new MavenXpp3Reader().read((InputStream)in);
            }
            catch (IOException e) {
                try {
                    throw new ManipulationException("Failed to build model for POM: %s.\n--> %s", (Throwable)e, pom, e.getMessage());
                    catch (XmlPullParserException e2) {
                        throw new ManipulationException("Failed to build model for POM: %s.\n--> %s", (Throwable)e2, pom, e2.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)in);
            if (raw == null) continue;
            Project project = new Project(pom, raw);
            project.setInheritanceRoot(peek.isInheritanceRoot());
            if (executionRoot.equals(pom)) {
                project.setExecutionRoot(true);
            }
            projects.add(project);
        }
        return projects;
    }

    public void rewritePOMs(Set<Project> changed) throws ManipulationException {
        for (Project project : changed) {
            this.logger.info(String.format("%s modified! Rewriting.", project));
            File pom = project.getPom();
            Model model = project.getModel();
            this.logger.info("Rewriting: " + model.toString() + " in place of: " + project.getId() + "\n       to POM: " + pom);
            this.write(project, pom, model);
            if (!pom.getName().equals("interpolated-pom.xml")) continue;
            File dir = pom.getParentFile();
            pom = dir == null ? new File("pom.xml") : new File(dir, "pom.xml");
            this.write(project, pom, model);
        }
    }

    private void write(final Project project, File pom, Model model) throws ManipulationException {
        try {
            MavenJDOMWriter writer = new MavenJDOMWriter(model);
            final String manifestInformation = project.isInheritanceRoot() ? this.getManifestInformation() : null;
            new MavenJDOMWriter().write((Object)model, pom, new DocumentModifier(){

                public void postProcess(Document doc) {
                    if (project.isInheritanceRoot()) {
                        Iterator it = doc.getContent((Filter)new ContentFilter(8)).iterator();
                        while (it.hasNext()) {
                            Comment c = (Comment)it.next();
                            if (!c.toString().startsWith(PomIO.MODIFIED_BY)) continue;
                            it.remove();
                            break;
                        }
                        doc.addContent(Arrays.asList(new Comment("\nModified by POM Manipulation Extension for Maven " + manifestInformation + "\n")));
                    }
                }
            });
        }
        catch (IOException e) {
            throw new ManipulationException("Failed to read POM for rewrite: %s. Reason: %s", (Throwable)e, pom, e.getMessage());
        }
        catch (JDOMException e) {
            throw new ManipulationException("Failed to parse POM for rewrite: %s. Reason: %s", (Throwable)e, pom, e.getMessage());
        }
    }

    private String getManifestInformation() throws ManipulationException {
        String result = "";
        try {
            Enumeration<URL> resources = PomIO.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL jarUrl = resources.nextElement();
                this.logger.debug("Processing jar resource " + jarUrl);
                if (!jarUrl.getFile().contains("pom-manipulation-ext")) continue;
                Manifest manifest = new Manifest(jarUrl.openStream());
                result = manifest.getMainAttributes().getValue("Implementation-Version");
                result = result + " ( SHA: " + manifest.getMainAttributes().getValue("Scm-Revision") + " ) ";
                break;
            }
        }
        catch (IOException e) {
            throw new ManipulationException("Error retrieving information from manifest", (Throwable)e, new Object[0]);
        }
        return result;
    }

    private List<PomPeek> peekAtPomHierarchy(File topPom) throws ManipulationException {
        ArrayList<PomPeek> peeked = new ArrayList<PomPeek>();
        try {
            LinkedList<File> pendingPoms = new LinkedList<File>();
            pendingPoms.add(topPom.getCanonicalFile());
            String topDir = topPom.getParentFile().getCanonicalPath();
            HashSet<File> seen = new HashSet<File>();
            File topLevelParent = topPom;
            while (!pendingPoms.isEmpty()) {
                File pom = (File)pendingPoms.removeFirst();
                seen.add(pom);
                this.logger.debug("PEEK: " + pom);
                PomPeek peek = new PomPeek(pom);
                ProjectVersionRef key = peek.getKey();
                if (key != null) {
                    Set modules;
                    peeked.add(peek);
                    File dir = pom.getParentFile();
                    String relPath = peek.getParentRelativePath();
                    if (relPath != null) {
                        this.logger.debug("Found parent relativePath: " + relPath + " in pom: " + pom);
                        File parent = new File(dir, relPath);
                        if (parent.isDirectory()) {
                            parent = new File(parent, "pom.xml");
                        }
                        this.logger.debug("Looking for parent POM: " + parent);
                        parent = parent.getCanonicalFile();
                        if (parent.getParentFile().getCanonicalPath().startsWith(topDir) && parent.exists() && !seen.contains(parent) && !pendingPoms.contains(parent)) {
                            topLevelParent = parent;
                            this.logger.debug("Possible top level parent " + parent);
                            pendingPoms.add(parent);
                        } else {
                            this.logger.debug("Skipping reference to non-existent parent relativePath: '" + relPath + "' in: " + pom);
                        }
                    }
                    if ((modules = peek.getModules()) == null || modules.isEmpty()) continue;
                    for (String module : modules) {
                        this.logger.debug("Found module: " + module + " in pom: " + pom);
                        File modPom = new File(dir, module);
                        if (modPom.isDirectory()) {
                            modPom = new File(modPom, "pom.xml");
                        }
                        this.logger.debug("Looking for module POM: " + modPom);
                        if (modPom.exists() && !seen.contains(modPom) && !pendingPoms.contains(modPom)) {
                            pendingPoms.addLast(modPom);
                            continue;
                        }
                        this.logger.debug("Skipping reference to non-existent module: '" + module + "' in: " + pom);
                    }
                    continue;
                }
                this.logger.debug("Skipping " + pom + " as its a template file.");
            }
            HashSet<ProjectVersionRef> projectrefs = new HashSet<ProjectVersionRef>();
            for (PomPeek p : peeked) {
                projectrefs.add(p.getKey());
                if (!p.getPom().equals(topLevelParent)) continue;
                this.logger.debug("Setting top level parent to " + p.getPom() + " :: " + p.getKey());
                p.setInheritanceRoot(true);
            }
            this.logger.debug("Searching pom list " + projectrefs.toString() + " for standalone poms...");
            for (PomPeek p : peeked) {
                if (p.getParentKey() != null && this.seenThisParent(projectrefs, p.getParentKey())) continue;
                this.logger.debug("Found a standalone pom " + p.getPom() + " :: " + p.getKey());
                p.setInheritanceRoot(true);
            }
        }
        catch (IOException e) {
            throw new ManipulationException("Problem peeking at POMs.", (Throwable)e, new Object[0]);
        }
        return peeked;
    }

    private boolean seenThisParent(HashSet<ProjectVersionRef> projectrefs, ProjectVersionRef parentKey) {
        for (ProjectVersionRef p : projectrefs) {
            if (!p.versionlessEquals(parentKey)) continue;
            return true;
        }
        return false;
    }
}

