/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.model;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.building.ModelBuildingResult;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.manip.ManipulationException;

public class Project {
    private final File pom;
    private final Model model;
    private ProjectVersionRef key;
    private boolean inheritanceRoot;
    private boolean executionRoot;

    public Project(ProjectVersionRef key, File pom, Model model) throws ManipulationException {
        this.pom = pom;
        this.model = model;
        this.key = key;
    }

    public Project(File pom, Model model) throws ManipulationException {
        this(Project.modelKey(model), pom, model);
    }

    public Project(Model model) throws ManipulationException {
        this(Project.modelKey(model), model.getPomFile(), model);
    }

    public Project(Model raw, ModelBuildingResult mbResult, File pom) throws ManipulationException {
        this.pom = pom;
        this.model = raw;
        this.key = Project.modelKey(raw);
    }

    public File getPom() {
        return this.pom;
    }

    public Model getModel() {
        return this.model;
    }

    public ProjectVersionRef getKey() {
        return this.key;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Project other = (Project)obj;
        return !(this.key == null ? other.key != null : !this.key.equals((Object)other.key));
    }

    public String toString() {
        return this.key + " [pom=" + this.pom + "]";
    }

    public Parent getParent() {
        return this.model.getParent();
    }

    public String getGroupId() {
        return this.key.getGroupId();
    }

    public String getArtifactId() {
        return this.key.getArtifactId();
    }

    public String getId() {
        return this.model.getId();
    }

    public String getVersion() {
        return this.key.getVersionString();
    }

    public List<Plugin> getPlugins() {
        return this.getPlugins((ModelBase)this.model);
    }

    public List<Plugin> getPlugins(ModelBase base) {
        BuildBase build = this.getBuild(base);
        if (build == null) {
            return Collections.emptyList();
        }
        List result = build.getPlugins();
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public Map<String, Plugin> getPluginMap() {
        return this.getPluginMap((ModelBase)this.model);
    }

    public Map<String, Plugin> getPluginMap(ModelBase base) {
        Object build = base instanceof Model ? ((Model)base).getBuild() : ((Profile)base).getBuild();
        if (build == null) {
            return Collections.emptyMap();
        }
        Map result = build.getPluginsAsMap();
        if (result == null) {
            return Collections.emptyMap();
        }
        return result;
    }

    public Build getBuild() {
        return (Build)this.getBuild((ModelBase)this.model);
    }

    public BuildBase getBuild(ModelBase base) {
        Object build = null;
        build = base instanceof Model ? ((Model)base).getBuild() : ((Profile)base).getBuild();
        return build;
    }

    public List<Plugin> getManagedPlugins() {
        return this.getManagedPlugins((ModelBase)this.model);
    }

    public List<Plugin> getManagedPlugins(ModelBase base) {
        Object build = base instanceof Model ? ((Model)base).getBuild() : ((Profile)base).getBuild();
        if (build == null) {
            return Collections.emptyList();
        }
        PluginManagement pm = build.getPluginManagement();
        if (pm == null) {
            return Collections.emptyList();
        }
        List result = pm.getPlugins();
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public Map<String, Plugin> getManagedPluginMap() {
        return this.getManagedPluginMap((ModelBase)this.model);
    }

    public Map<String, Plugin> getManagedPluginMap(ModelBase base) {
        if (base instanceof Model) {
            Build build = ((Model)base).getBuild();
            if (build == null) {
                return Collections.emptyMap();
            }
            PluginManagement pm = build.getPluginManagement();
            if (pm == null) {
                return Collections.emptyMap();
            }
            Map result = pm.getPluginsAsMap();
            if (result == null) {
                return Collections.emptyMap();
            }
            return result;
        }
        return Collections.emptyMap();
    }

    public List<ReportPlugin> getReportPlugins() {
        return this.getReportPlugins((ModelBase)this.model);
    }

    public List<ReportPlugin> getReportPlugins(ModelBase base) {
        Reporting reporting = base.getReporting();
        if (reporting == null) {
            return Collections.emptyList();
        }
        return reporting.getPlugins();
    }

    public Iterable<Dependency> getDependencies() {
        return this.getDependencies((ModelBase)this.model);
    }

    public Iterable<Dependency> getDependencies(ModelBase base) {
        List<Dependency> deps = base.getDependencies();
        if (deps == null) {
            deps = Collections.emptyList();
        }
        return deps;
    }

    public Iterable<Dependency> getManagedDependencies() {
        return this.getManagedDependencies((ModelBase)this.model);
    }

    public Iterable<Dependency> getManagedDependencies(ModelBase base) {
        DependencyManagement dm = base.getDependencyManagement();
        if (dm == null || dm.getDependencies() == null) {
            return Collections.emptyList();
        }
        return dm.getDependencies();
    }

    public void updateCoord() throws ManipulationException {
        this.key = Project.modelKey(this.model);
    }

    public void flushPluginMaps() {
        this.flushPluginMaps((ModelBase)this.model);
        List profiles = this.model.getProfiles();
        if (profiles != null) {
            for (Profile profile : profiles) {
                this.flushPluginMaps((ModelBase)profile);
            }
        }
    }

    public void flushPluginMaps(ModelBase base) {
        Reporting reporting;
        BuildBase build = this.getBuild(base);
        if (build != null) {
            build.flushPluginMap();
            PluginManagement pm = build.getPluginManagement();
            if (pm != null) {
                pm.flushPluginMap();
            }
        }
        if ((reporting = this.model.getReporting()) != null) {
            reporting.flushReportPluginMap();
        }
    }

    public ProjectRef getVersionlessParentKey() {
        Parent parent = this.getParent();
        return parent != null ? new ProjectRef(parent.getGroupId(), parent.getArtifactId()) : null;
    }

    public List<Extension> getExtensions() {
        if (this.model.getBuild() == null) {
            return Collections.emptyList();
        }
        List extensions = this.model.getBuild().getExtensions();
        if (extensions == null) {
            return Collections.emptyList();
        }
        return extensions;
    }

    public String getPackaging() {
        return this.model.getPackaging();
    }

    public ProjectRef getVersionlessKey() {
        return this.key.asProjectRef();
    }

    public void setInheritanceRoot(boolean inheritanceRoot) {
        this.inheritanceRoot = inheritanceRoot;
    }

    public boolean isInheritanceRoot() {
        return this.inheritanceRoot;
    }

    private static ProjectVersionRef modelKey(Model model) throws ManipulationException {
        String g = model.getGroupId();
        String a = model.getArtifactId();
        String v = model.getVersion();
        if (g == null || v == null) {
            Parent p = model.getParent();
            if (p == null) {
                throw new ManipulationException("Invalid model: " + model + " Cannot find groupId and/or version!", new String[0]);
            }
            if (g == null) {
                g = p.getGroupId();
            }
            if (v == null) {
                v = p.getVersion();
            }
        }
        return new ProjectVersionRef(g, a, v);
    }

    public void setExecutionRoot(boolean b) {
        this.executionRoot = true;
    }

    public boolean isExecutionRoot() {
        return this.executionRoot;
    }
}

