/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.state;

import java.util.Properties;
import org.commonjava.maven.atlas.ident.ref.InvalidRefException;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.manip.state.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryInjectionState
implements State {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String REPOSITORY_INJECTION_PROPERTY = "repositoryInjection";
    private final ProjectVersionRef repoMgmt;

    public RepositoryInjectionState(Properties userProps) {
        String gav = userProps.getProperty(REPOSITORY_INJECTION_PROPERTY);
        ProjectVersionRef ref = null;
        if (gav != null) {
            try {
                ref = ProjectVersionRef.parse((String)gav);
            }
            catch (InvalidRefException e) {
                this.logger.error("Skipping repository injection! Got invalid repositoryInjection GAV: {}", (Object)gav);
                throw e;
            }
        }
        this.repoMgmt = ref;
    }

    @Override
    public boolean isEnabled() {
        return this.repoMgmt != null;
    }

    public ProjectVersionRef getRemoteRepositoryInjectionMgmt() {
        return this.repoMgmt;
    }
}

