/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.project.MavenProject;
import org.commonjava.maven.atlas.ident.ref.InvalidRefException;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.ext.manip.model.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdUtils {
    private static final Logger logger = LoggerFactory.getLogger(IdUtils.class);
    public static final Pattern gavPattern = Pattern.compile("\\s*([\\w\\-_.]+):([\\w\\-_.]+):(\\d[\\w\\-_.]+)\\s*");

    private IdUtils() {
    }

    public static List<ProjectVersionRef> parseGAVs(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        String[] gavs = value.split(",");
        ArrayList<ProjectVersionRef> refs = new ArrayList<ProjectVersionRef>();
        for (String gav : gavs) {
            try {
                ProjectVersionRef ref = ProjectVersionRef.parse((String)gav);
                refs.add(ref);
            }
            catch (InvalidRefException e) {
                logger.error("Skipping invalid remote management GAV: " + gav);
                throw e;
            }
        }
        return refs;
    }

    public static boolean validGav(String gav) {
        Matcher matcher = gavPattern.matcher(gav);
        return matcher.matches();
    }

    public static String gav(MavenProject project) {
        return String.format("%s:%s:%s", project.getGroupId(), project.getArtifactId(), project.getVersion());
    }

    public static String gav(Project project) {
        return String.format("%s:%s:%s", project.getGroupId(), project.getArtifactId(), project.getVersion());
    }

    public static String gav(Model model) {
        String g = model.getGroupId();
        String v = model.getVersion();
        Parent p = model.getParent();
        if (p != null) {
            if (g == null) {
                g = p.getGroupId();
            }
            if (v == null) {
                v = p.getVersion();
            }
        }
        return String.format("%s:%s:%s", g, model.getArtifactId(), v);
    }

    public static String ga(Model model) {
        String g = model.getGroupId();
        Parent p = model.getParent();
        if (p != null && g == null) {
            g = p.getGroupId();
        }
        return IdUtils.ga(g, model.getArtifactId());
    }

    public static String ga(MavenProject project) {
        return IdUtils.ga(project.getGroupId(), project.getArtifactId());
    }

    public static String ga(Project project) {
        return IdUtils.ga(project.getGroupId(), project.getArtifactId());
    }

    public static String ga(Parent project) {
        return IdUtils.ga(project.getGroupId(), project.getArtifactId());
    }

    public static String ga(String g, String a) {
        return String.format("%s:%s", g, a);
    }

    public static String gav(String g, String a, String v) {
        return String.format("%s:%s:%s", g, a, v);
    }
}

