/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.manip.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WildcardMap {
    private static final String WILDCARD = "*";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final TreeMap<String, LinkedHashMap<String, String>> map = new TreeMap();

    public boolean containsKey(ProjectRef key) {
        String groupId = key.getGroupId();
        String artifactId = key.getArtifactId();
        LinkedHashMap<String, String> vMap = this.map.get(groupId);
        boolean result = vMap == null || vMap.size() == 0 ? false : (vMap.get(WILDCARD) != null ? true : vMap.containsKey(artifactId));
        return result;
    }

    public void put(ProjectRef key, String value) {
        String groupId = key.getGroupId();
        String artifactId = key.getArtifactId();
        LinkedHashMap<String, String> vMap = this.map.get(groupId);
        if (vMap == null) {
            vMap = new LinkedHashMap();
        }
        boolean wildcard = false;
        if (WILDCARD.equals(artifactId)) {
            if (vMap.size() > 0) {
                this.logger.warn("Emptying map with keys " + vMap.keySet() + " as replacing with wildcard mapping " + key);
            }
            vMap.clear();
        } else {
            Iterator<String> i = vMap.keySet().iterator();
            while (i.hasNext()) {
                if (!i.next().equals(WILDCARD)) continue;
                wildcard = true;
            }
        }
        if (wildcard) {
            this.logger.warn("Unable to add " + key + " with value " + value + " as wildcard mapping for " + groupId + " already exists.");
        } else {
            this.logger.debug("Entering artifact of " + artifactId + " and value " + value);
            vMap.put(artifactId, value);
            this.map.put(groupId, vMap);
        }
    }

    public String get(ProjectRef key) {
        String groupId = key.getGroupId();
        String artifactId = key.getArtifactId();
        String result = null;
        LinkedHashMap<String, String> value = this.map.get(groupId);
        if (value != null) {
            this.logger.debug("Retrieved value map of " + value);
            result = value.get(WILDCARD) != null ? value.get(WILDCARD) : value.get(artifactId);
        }
        this.logger.debug("Returning result of " + result);
        return result;
    }

    public String toString() {
        return "WildcardMap{map=" + this.map + '}';
    }
}

