/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.transport.htcli;

import java.io.Closeable;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.commonjava.maven.galley.transport.htcli.model.HttpLocation;

public interface Http
extends Closeable {
    public CloseableHttpClient createClient(HttpLocation var1) throws IOException;

    public CloseableHttpClient createClient() throws IOException;

    public HttpClientContext createContext(HttpLocation var1);

    public HttpClientContext createContext();

    public void cleanup(CloseableHttpClient var1, HttpUriRequest var2, CloseableHttpResponse var3);

    public static final class CertEnumerator {
        private final KeyStore ks;

        public CertEnumerator(KeyStore ks) {
            this.ks = ks;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            try {
                Enumeration<String> aliases = this.ks.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    X509Certificate cert = (X509Certificate)this.ks.getCertificate(alias);
                    if (cert == null) continue;
                    sb.append("\n").append(cert.getSubjectDN());
                }
            }
            catch (KeyStoreException e) {
                sb.append("ERROR READING KEYSTORE");
            }
            return sb.toString();
        }
    }
}

