/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.transport.htcli;

import java.io.Closeable;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.commonjava.maven.galley.auth.PasswordEntry;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.spi.auth.PasswordManager;
import org.commonjava.maven.galley.transport.htcli.Http;
import org.commonjava.maven.galley.transport.htcli.internal.CloseBlockingConnectionManager;
import org.commonjava.maven.galley.transport.htcli.internal.SSLUtils;
import org.commonjava.maven.galley.transport.htcli.model.HttpLocation;
import org.commonjava.maven.galley.transport.htcli.util.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpImpl
implements Http,
Closeable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PasswordManager passwords;
    private final CloseBlockingConnectionManager connectionManager;

    public HttpImpl(PasswordManager passwords) {
        this(passwords, 200);
    }

    public HttpImpl(PasswordManager passwords, int maxConnections) {
        this.passwords = passwords;
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(200);
        this.connectionManager = new CloseBlockingConnectionManager((HttpClientConnectionManager)cm);
    }

    public HttpImpl(PasswordManager passwordManager, HttpClientConnectionManager connectionManager) {
        this.passwords = passwordManager;
        this.connectionManager = new CloseBlockingConnectionManager(connectionManager);
    }

    @Override
    public CloseableHttpClient createClient() throws IOException {
        return this.createClient(null);
    }

    @Override
    public CloseableHttpClient createClient(HttpLocation location) throws IOException {
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionManager);
        if (location != null) {
            SSLConnectionSocketFactory sslFac = this.createSSLSocketFactory(location);
            if (sslFac != null) {
                builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslFac);
            }
            if (location.getProxyHost() != null) {
                DefaultProxyRoutePlanner planner = new DefaultProxyRoutePlanner(new HttpHost(location.getProxyHost(), this.getProxyPort(location)));
                builder.setRoutePlanner((HttpRoutePlanner)planner);
            }
        }
        return builder.build();
    }

    private int getProxyPort(HttpLocation location) {
        int port = location.getProxyPort();
        if (port < 1) {
            port = -1;
        }
        return port;
    }

    @Override
    public HttpClientContext createContext() {
        return this.createContext(null);
    }

    @Override
    public HttpClientContext createContext(HttpLocation location) {
        HttpClientContext ctx = HttpClientContext.create();
        if (location != null) {
            String password;
            BasicCredentialsProvider creds = new BasicCredentialsProvider();
            AuthScope as = new AuthScope(location.getHost(), location.getPort());
            if (location.getUser() != null) {
                password = this.passwords.getPassword(new PasswordEntry((Location)location, "userPassword"));
                creds.setCredentials(as, (Credentials)new UsernamePasswordCredentials(location.getUser(), password));
            }
            if (location.getProxyHost() != null && location.getProxyUser() != null) {
                password = this.passwords.getPassword(new PasswordEntry((Location)location, "proxyPassword"));
                creds.setCredentials(new AuthScope(location.getProxyHost(), this.getProxyPort(location)), (Credentials)new UsernamePasswordCredentials(location.getProxyUser(), password));
            }
            ctx.setCredentialsProvider((CredentialsProvider)creds);
        }
        return ctx;
    }

    private SSLConnectionSocketFactory createSSLSocketFactory(HttpLocation location) throws IOException {
        KeyStore ks = null;
        KeyStore ts = null;
        String kcPem = location.getKeyCertPem();
        String kcPass = this.passwords.getPassword(new PasswordEntry((Location)location, "keyPassword"));
        if (kcPem != null) {
            if (kcPass == null || kcPass.length() < 1) {
                this.logger.error("Invalid configuration. Location: {} cannot have an empty key password!", (Object)location.getUri());
                throw new IOException("Location: " + location.getUri() + " is misconfigured!");
            }
            try {
                ks = SSLUtils.readKeyAndCert(kcPem, kcPass);
                this.logger.debug("Keystore contains the following certificates: {}", (Object)new Http.CertEnumerator(ks));
            }
            catch (CertificateException e) {
                this.logger.error(String.format("Invalid configuration. Location: %s has an invalid client certificate! Error: %s", location.getUri(), e.getMessage()), (Throwable)e);
                throw new IOException("Failed to initialize SSL connection for repository: " + location.getUri());
            }
            catch (KeyStoreException e) {
                this.logger.error(String.format("Invalid configuration. Cannot initialize keystore for repository: %s. Error: %s", location.getUri(), e.getMessage()), (Throwable)e);
                throw new IOException("Failed to initialize SSL connection for repository: " + location.getUri());
            }
            catch (NoSuchAlgorithmException e) {
                this.logger.error(String.format("Invalid configuration. Cannot initialize keystore for repository: %s. Error: %s", location.getUri(), e.getMessage()), (Throwable)e);
                throw new IOException("Failed to initialize SSL connection for repository: " + location.getUri());
            }
            catch (InvalidKeySpecException e) {
                this.logger.error(String.format("Invalid configuration. Invalid client key for repository: %s. Error: %s", location.getUri(), e.getMessage()), (Throwable)e);
                throw new IOException("Failed to initialize SSL connection for repository: " + location.getUri());
            }
        }
        String sPem = location.getServerCertPem();
        this.logger.debug("Server certificate PEM:\n{}", (Object)sPem);
        if (sPem != null) {
            try {
                ts = SSLUtils.readCerts(sPem, location.getHost());
                this.logger.debug("Trust store contains the following certificates:\n{}", (Object)new Http.CertEnumerator(ts));
            }
            catch (CertificateException e) {
                this.logger.error(String.format("Invalid configuration. Location: %s has an invalid server certificate! Error: %s", location.getUri(), e.getMessage()), (Throwable)e);
                throw new IOException("Failed to initialize SSL connection for repository: " + location.getUri());
            }
            catch (KeyStoreException e) {
                this.logger.error(String.format("Invalid configuration. Cannot initialize keystore for repository: %s. Error: %s", location.getUri(), e.getMessage()), (Throwable)e);
                throw new IOException("Failed to initialize SSL connection for repository: " + location.getUri());
            }
            catch (NoSuchAlgorithmException e) {
                this.logger.error(String.format("Invalid configuration. Cannot initialize keystore for repository: %s. Error: %s", location.getUri(), e.getMessage()), (Throwable)e);
                throw new IOException("Failed to initialize SSL connection for repository: " + location.getUri());
            }
        }
        if (ks != null || ts != null) {
            try {
                SSLContext ctx = SSLContexts.custom().useProtocol("TLS").loadKeyMaterial(ks, kcPass.toCharArray()).loadTrustMaterial(ts, null).build();
                return new SSLConnectionSocketFactory(ctx, (HostnameVerifier)new DefaultHostnameVerifier());
            }
            catch (KeyManagementException e) {
                this.logger.error("Invalid configuration. Cannot initialize SSL socket factory for repository: {}. Error: {}", new Object[]{e, location.getUri(), e.getMessage()});
                throw new IOException("Failed to initialize SSL connection for repository: " + location.getUri());
            }
            catch (UnrecoverableKeyException e) {
                this.logger.error("Invalid configuration. Cannot initialize SSL socket factory for repository: {}. Error: {}", new Object[]{e, location.getUri(), e.getMessage()});
                throw new IOException("Failed to initialize SSL connection for repository: " + location.getUri());
            }
            catch (NoSuchAlgorithmException e) {
                this.logger.error("Invalid configuration. Cannot initialize SSL socket factory for repository: {}. Error: {}", new Object[]{e, location.getUri(), e.getMessage()});
                throw new IOException("Failed to initialize SSL connection for repository: " + location.getUri());
            }
            catch (KeyStoreException e) {
                this.logger.error("Invalid configuration. Cannot initialize SSL socket factory for repository: {}. Error: {}", new Object[]{e, location.getUri(), e.getMessage()});
                throw new IOException("Failed to initialize SSL connection for repository: " + location.getUri());
            }
        }
        return null;
    }

    @Override
    public void cleanup(CloseableHttpClient client, HttpUriRequest request, CloseableHttpResponse response) {
        HttpUtil.cleanupResources(client, request, response);
    }

    @Override
    public void close() throws IOException {
        this.connectionManager.reallyShutdown();
    }
}

