/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.transport.htcli.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.TransferOperation;
import org.commonjava.maven.galley.spi.transport.DownloadJob;
import org.commonjava.maven.galley.transport.htcli.Http;
import org.commonjava.maven.galley.transport.htcli.internal.AbstractHttpJob;
import org.commonjava.maven.galley.transport.htcli.model.HttpLocation;

public final class HttpDownload
extends AbstractHttpJob
implements DownloadJob {
    private final Transfer target;
    private final EventMetadata eventMetadata;
    private final ObjectMapper mapper;

    public HttpDownload(String url, HttpLocation location, Transfer target, EventMetadata eventMetadata, Http http, ObjectMapper mapper) {
        super(url, location, http, new Integer[0]);
        this.target = target;
        this.eventMetadata = eventMetadata;
        this.mapper = mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadJob call() {
        this.request = new HttpGet(this.url);
        try {
            if (this.executeHttp()) {
                this.writeTarget();
            }
        }
        catch (TransferException e) {
            this.error = e;
        }
        finally {
            this.writeMetadata(this.target, this.mapper);
            this.cleanup();
        }
        this.logger.info("Download attempt done: {} Result:\n  target: {}\n  error: {}", new Object[]{this.url, this.target, this.error});
        return this;
    }

    @Override
    public TransferException getError() {
        return this.error;
    }

    public Transfer getTransfer() {
        return this.target;
    }

    private void writeTarget() throws TransferException {
        OutputStream out = null;
        if (this.response != null) {
            InputStream in = null;
            try {
                HttpEntity entity = this.response.getEntity();
                in = entity.getContent();
                out = this.target.openOutputStream(TransferOperation.DOWNLOAD, true, this.eventMetadata);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                this.logger.info("Ensuring all HTTP data is consumed...");
                EntityUtils.consume((HttpEntity)entity);
                this.logger.info("All HTTP data was consumed.");
            }
            catch (IOException e) {
                try {
                    throw new TransferException("Failed to write to local proxy store: {}\nOriginal URL: {}. Reason: {}", (Throwable)e, new Object[]{this.target, this.url, e.getMessage()});
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    this.logger.info("Closing output stream: {}", out);
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)in);
            this.logger.info("Closing output stream: {}", (Object)out);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }
}

