/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.transport.htcli.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public final class SSLUtils {
    private SSLUtils() {
    }

    public static KeyStore readKeyAndCert(String pemContent, String keyPass) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, InvalidKeySpecException {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null);
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        List<String> lines = SSLUtils.readLines(pemContent);
        String currentHeader = null;
        StringBuilder current = new StringBuilder();
        LinkedHashMap<String, String> entries = new LinkedHashMap<String, String>();
        for (String line : lines) {
            if (line == null) continue;
            if (line.startsWith("-----BEGIN")) {
                currentHeader = line.trim();
                current.setLength(0);
                continue;
            }
            if (line.startsWith("-----END")) {
                entries.put(currentHeader, current.toString());
                continue;
            }
            current.append(line.trim());
        }
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        for (int pass = 0; pass < 2; ++pass) {
            for (Map.Entry entry : entries.entrySet()) {
                String header = (String)entry.getKey();
                byte[] data = Base64.decodeBase64((String)((String)entry.getValue()));
                if (pass > 0 && header.contains("BEGIN PRIVATE KEY")) {
                    PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(data);
                    PrivateKey key = keyFactory.generatePrivate(spec);
                    ks.setKeyEntry("key", key, keyPass.toCharArray(), certs.toArray(new Certificate[0]));
                    continue;
                }
                if (pass >= 1 || !header.contains("BEGIN CERTIFICATE")) continue;
                Certificate c = certFactory.generateCertificate(new ByteArrayInputStream(data));
                ks.setCertificateEntry("certificate", c);
                certs.add(c);
            }
        }
        return ks;
    }

    public static KeyStore readCerts(String pemContent, String aliasPrefix) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null);
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        List<String> lines = SSLUtils.readLines(pemContent);
        StringBuilder current = new StringBuilder();
        ArrayList<String> entries = new ArrayList<String>();
        for (String line : lines) {
            if (line == null) continue;
            if (line.startsWith("-----BEGIN")) {
                current.setLength(0);
                continue;
            }
            if (line.startsWith("-----END")) {
                entries.add(current.toString());
                continue;
            }
            current.append(line.trim());
        }
        int i = 0;
        for (String entry : entries) {
            byte[] data = Base64.decodeBase64((String)entry);
            Certificate c = certFactory.generateCertificate(new ByteArrayInputStream(data));
            ks.setCertificateEntry(aliasPrefix + i, c);
            ++i;
        }
        return ks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readLines(String content) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(content.getBytes(Charset.forName("UTF-8")))));
            String line = null;
            while ((line = reader.readLine()) != null) {
                lines.add(line.trim());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        return lines;
    }
}

