/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.transport.htcli.internal.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.transport.htcli.conf.GlobalHttpConfiguration;
import org.commonjava.maven.galley.transport.htcli.conf.ProxyConfig;
import org.commonjava.maven.galley.transport.htcli.model.HttpLocation;

public class WrapperHttpLocation
implements HttpLocation {
    private final Location delegate;
    private final URL url;
    private final GlobalHttpConfiguration globalConfig;

    public WrapperHttpLocation(Location delegate, GlobalHttpConfiguration globalConfig) throws MalformedURLException {
        this.delegate = delegate;
        this.globalConfig = globalConfig;
        this.url = new URL(delegate.getUri());
    }

    public boolean allowsSnapshots() {
        return this.delegate.allowsSnapshots();
    }

    public boolean allowsReleases() {
        return this.delegate.allowsReleases();
    }

    public String getUri() {
        return this.delegate.getUri();
    }

    @Override
    public String getKeyCertPem() {
        return null;
    }

    @Override
    public String getServerCertPem() {
        return null;
    }

    @Override
    public String getHost() {
        return this.url.getHost();
    }

    @Override
    public int getPort() {
        return this.url.getPort() < 0 ? this.url.getDefaultPort() : this.url.getPort();
    }

    @Override
    public String getUser() {
        int idx;
        String userpass = this.url.getUserInfo();
        if (userpass != null && (idx = userpass.indexOf(":")) > -1) {
            return userpass.substring(0, idx);
        }
        return userpass;
    }

    @Override
    public String getProxyHost() {
        ProxyConfig proxy = this.globalConfig == null ? null : this.globalConfig.getProxyConfig(this.url);
        return proxy == null ? null : proxy.getHost();
    }

    @Override
    public String getProxyUser() {
        ProxyConfig proxy = this.globalConfig == null ? null : this.globalConfig.getProxyConfig(this.url);
        return proxy == null ? null : proxy.getUser();
    }

    @Override
    public int getProxyPort() {
        ProxyConfig proxy = this.globalConfig == null ? null : this.globalConfig.getProxyConfig(this.url);
        return proxy == null ? 8080 : proxy.getPort();
    }

    public boolean equals(Object other) {
        return this.delegate.equals(other);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Map<String, Object> getAttributes() {
        return this.delegate.getAttributes();
    }

    public <T> T getAttribute(String key, Class<T> type) {
        return (T)this.delegate.getAttribute(key, type);
    }

    public <T> T getAttribute(String key, Class<T> type, T defaultValue) {
        return (T)this.delegate.getAttribute(key, type, defaultValue);
    }

    public Object removeAttribute(String key) {
        return this.delegate.removeAttribute(key);
    }

    public Object setAttribute(String key, Object value) {
        return this.delegate.setAttribute(key, value);
    }

    public boolean allowsPublishing() {
        return this.delegate.allowsPublishing();
    }

    public boolean allowsStoring() {
        return this.delegate.allowsStoring();
    }

    public boolean allowsDownloading() {
        return true;
    }

    public String getName() {
        return this.delegate.getName();
    }
}

