/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.transport.htcli.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.commonjava.maven.galley.TransferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransferResponseUtils {
    private TransferResponseUtils() {
    }

    public static boolean handleUnsuccessfulResponse(HttpUriRequest request, CloseableHttpResponse response, String url) throws TransferException {
        return TransferResponseUtils.handleUnsuccessfulResponse(request, response, url, true);
    }

    public static boolean handleUnsuccessfulResponse(HttpUriRequest request, CloseableHttpResponse response, String url, boolean graceful404) throws TransferException {
        Logger logger = LoggerFactory.getLogger(TransferResponseUtils.class);
        StatusLine line = response.getStatusLine();
        InputStream in = null;
        HttpEntity entity = null;
        try {
            entity = response.getEntity();
            int sc = line.getStatusCode();
            if (graceful404 && sc == 404) {
                boolean bl = false;
                return bl;
            }
            try {
                ByteArrayOutputStream out = null;
                if (entity != null) {
                    in = entity.getContent();
                    out = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                throw new TransferException("HTTP request failed: %s%s", new Object[]{line, out == null ? "" : "\n\n" + new String(out.toByteArray())});
            }
            catch (IOException e) {
                request.abort();
                throw new TransferException("Error reading body of unsuccessful request.\nStatus: %s.\nURL: %s.\nReason: %s", (Throwable)e, new Object[]{line, url, e.getMessage()});
            }
        }
        finally {
            IOUtils.closeQuietly(in);
            if (entity != null) {
                try {
                    EntityUtils.consume((HttpEntity)entity);
                }
                catch (IOException e) {
                    logger.debug("Failed to consume entity: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

