/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.googleapps;

import com.google.gdata.client.Query;
import com.google.gdata.client.appsforyourdomain.AppsForYourDomainQuery;
import com.google.gdata.client.appsforyourdomain.AppsGroupsService;
import com.google.gdata.client.appsforyourdomain.NicknameService;
import com.google.gdata.client.appsforyourdomain.UserService;
import com.google.gdata.data.Extension;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.ILink;
import com.google.gdata.data.Link;
import com.google.gdata.data.appsforyourdomain.AppsForYourDomainErrorCode;
import com.google.gdata.data.appsforyourdomain.AppsForYourDomainException;
import com.google.gdata.data.appsforyourdomain.Login;
import com.google.gdata.data.appsforyourdomain.Name;
import com.google.gdata.data.appsforyourdomain.Nickname;
import com.google.gdata.data.appsforyourdomain.Quota;
import com.google.gdata.data.appsforyourdomain.generic.GenericEntry;
import com.google.gdata.data.appsforyourdomain.generic.GenericFeed;
import com.google.gdata.data.appsforyourdomain.provisioning.NicknameEntry;
import com.google.gdata.data.appsforyourdomain.provisioning.NicknameFeed;
import com.google.gdata.data.appsforyourdomain.provisioning.UserEntry;
import com.google.gdata.data.appsforyourdomain.provisioning.UserFeed;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.AlreadyExistsException;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.UnknownUidException;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.Uid;

public class GoogleAppsClient {
    public static final String SERVICENAME = "identityConnectors";
    protected static final String SERVICE_VERSION = "2.0";
    protected NicknameService nicknameService;
    protected UserService userService;
    protected AppsGroupsService groupService;
    private String domainUrlBase;
    private String admin;
    private Log log = Log.getLog(GoogleAppsClient.class);

    public GoogleAppsClient(String adminLogin, String adminPassword, String domainURL, String domain) throws Exception {
        this.domainUrlBase = domainURL;
        if (!this.domainUrlBase.endsWith("/")) {
            this.domainUrlBase = this.domainUrlBase + "/";
        }
        this.admin = adminLogin;
        String adminEmail = this.admin + "@" + domain;
        this.userService = new UserService("identityConnectors-UserService");
        this.userService.setUserCredentials(adminEmail, adminPassword);
        this.nicknameService = new NicknameService("identityConnectors-NicknameService");
        this.nicknameService.setUserCredentials(adminEmail, adminPassword);
        this.groupService = new AppsGroupsService(adminEmail, adminPassword, domain, "identityConnectors-AppsGroupService");
    }

    public UserEntry getUserEntry(String username) {
        try {
            URL retrieveUrl = new URL(this.domainUrlBase + "user/" + SERVICE_VERSION + "/" + username);
            return (UserEntry)this.userService.getEntry(retrieveUrl, UserEntry.class);
        }
        catch (AppsForYourDomainException e) {
            if (e.getErrorCode() == AppsForYourDomainErrorCode.EntityDoesNotExist) {
                return null;
            }
            throw ConnectorException.wrap((Throwable)e);
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public void testConnection() {
        try {
            this.getUserEntry(this.admin);
        }
        catch (Exception e) {
            throw new ConnectorException("TestConnection failed. Wrapped exception ", (Throwable)e);
        }
    }

    private UserFeed getUserFeed() throws AppsForYourDomainException, ServiceException, IOException {
        Link nextLink;
        URL retrieveUrl = new URL(this.domainUrlBase + "user/" + SERVICE_VERSION + "/");
        UserFeed allUsers = new UserFeed();
        do {
            UserFeed currentPage = (UserFeed)this.userService.getFeed(retrieveUrl, UserFeed.class);
            allUsers.getEntries().addAll(currentPage.getEntries());
            nextLink = currentPage.getLink("next", ILink.Type.ATOM);
            if (nextLink == null) continue;
            retrieveUrl = new URL(nextLink.getHref());
        } while (nextLink != null);
        return allUsers;
    }

    public GoogleAppsAccountIterator getIterator() {
        return new GoogleAppsAccountIterator();
    }

    public void updateGroup(String groupId, String groupName, String description, String permissions) {
        try {
            this.groupService.updateGroup(groupId, groupName, description, permissions);
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    void addGroupOwner(String groupId, String owner) {
        try {
            this.groupService.addOwnerToGroup(groupId, owner);
        }
        catch (Exception e) {
            ConnectorException.wrap((Throwable)e);
        }
    }

    void removeGroupOwner(String groupId, String user) {
        throw new RuntimeException("Google API does not implment remove group owner?");
    }

    List<String> getGroupMembershipsForUser(String accountId) {
        ArrayList<String> l = new ArrayList<String>();
        try {
            GenericFeed f = this.groupService.retrieveGroups(accountId, true);
            List x = f.getEntries();
            for (GenericEntry item : x) {
                String group = item.getProperty("groupId");
                l.add(group);
            }
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
        return l;
    }

    public NicknameFeed getNicknameFeed(String username) {
        try {
            URL feedUrl = new URL(this.domainUrlBase + "nickname/" + SERVICE_VERSION);
            AppsForYourDomainQuery query = new AppsForYourDomainQuery(feedUrl);
            query.setUsername(username);
            return (NicknameFeed)this.nicknameService.query((Query)query, NicknameFeed.class);
        }
        catch (Exception ex) {
            throw ConnectorException.wrap((Throwable)ex);
        }
    }

    public List<String> getNicknamesAsList(String username) {
        ArrayList<String> nnlist = new ArrayList<String>();
        try {
            NicknameFeed nicknames = this.getNicknameFeed(username);
            if (nicknames != null) {
                for (NicknameEntry ne : nicknames.getEntries()) {
                    Nickname nickname = ne.getNickname();
                    nnlist.add(nickname.getName());
                }
            }
            return nnlist;
        }
        catch (Exception ex) {
            throw ConnectorException.wrap((Throwable)ex);
        }
    }

    public void createNickname(String username, String nickname) {
        try {
            NicknameEntry entry = new NicknameEntry();
            Nickname nicknameExtension = new Nickname();
            nicknameExtension.setName(nickname);
            entry.addExtension((Extension)nicknameExtension);
            Login login = new Login();
            login.setUserName(username);
            entry.addExtension((Extension)login);
            URL insertUrl = new URL(this.domainUrlBase + "nickname/" + SERVICE_VERSION);
            NicknameEntry ne = (NicknameEntry)this.nicknameService.insert(insertUrl, (IEntry)entry);
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public void deleteNickname(String nickname) {
        try {
            URL deleteUrl = new URL(this.domainUrlBase + "nickname/" + SERVICE_VERSION + "/" + nickname);
            this.nicknameService.delete(deleteUrl);
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public UserEntry createUser(UserEntry entry) {
        try {
            URL insertUrl = new URL(this.domainUrlBase + "user/" + SERVICE_VERSION);
            return (UserEntry)this.userService.insert(insertUrl, (IEntry)entry);
        }
        catch (AppsForYourDomainException e) {
            if (e.getErrorCode() == AppsForYourDomainErrorCode.EntityExists) {
                throw new AlreadyExistsException((Throwable)e);
            }
            throw ConnectorException.wrap((Throwable)e);
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public UserEntry updateUser(String username, UserEntry userEntry) {
        try {
            URL updateUrl = new URL(this.domainUrlBase + "user/" + SERVICE_VERSION + "/" + username);
            return (UserEntry)this.userService.update(updateUrl, (IEntry)userEntry);
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public void deleteUser(String username) {
        try {
            URL deleteUrl = new URL(this.domainUrlBase + "user/" + SERVICE_VERSION + "/" + username);
            this.userService.delete(deleteUrl);
        }
        catch (AppsForYourDomainException e) {
            if (e.getErrorCode() == AppsForYourDomainErrorCode.EntityDoesNotExist) {
                throw new UnknownUidException(new Uid(username), ObjectClass.ACCOUNT);
            }
            throw ConnectorException.wrap((Throwable)e);
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public UserEntry setUserEntry(UserEntry userEntry, String username, String password, String givenName, String familyName, boolean suspended, Integer quotaLimitInMb) {
        Login login;
        if (userEntry == null) {
            userEntry = new UserEntry();
        }
        if ((login = userEntry.getLogin()) == null) {
            login = new Login();
        }
        if (username != null) {
            login.setUserName(username);
        }
        if (password != null) {
            login.setPassword(password);
        }
        login.setSuspended(Boolean.valueOf(suspended));
        userEntry.setExtension((Extension)login);
        Name name = userEntry.getName();
        if (name == null) {
            name = new Name();
        }
        if (givenName != null) {
            name.setGivenName(givenName);
        }
        if (familyName != null) {
            name.setFamilyName(familyName);
        }
        userEntry.setExtension((Extension)name);
        if (quotaLimitInMb != null) {
            Quota quota = new Quota();
            quota.setLimit(quotaLimitInMb);
            userEntry.setExtension((Extension)quota);
        }
        return userEntry;
    }

    public static String userEntrytoString(UserEntry ue) {
        StringBuffer sb = new StringBuffer("UserEntry:");
        if (ue != null) {
            Quota q;
            Name n;
            Login login = ue.getLogin();
            if (login != null) {
                sb.append("Login=" + login.getUserName());
            }
            if ((n = ue.getName()) != null) {
                sb.append(" Name=" + n.getGivenName() + " " + n.getFamilyName());
            }
            if ((q = ue.getQuota()) != null) {
                sb.append(" quota=" + q.getLimit());
            }
        }
        return sb.toString();
    }

    public Iterator getGroupIterator() {
        try {
            GenericFeed groupsFeed = this.groupService.retrieveAllGroups();
            Iterator groupIterator = groupsFeed.getEntries().iterator();
            return groupIterator;
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public GenericEntry getGroupEntry(String id) {
        try {
            return this.groupService.retrieveGroup(id);
        }
        catch (AppsForYourDomainException e) {
            if (e.getErrorCode() == AppsForYourDomainErrorCode.EntityDoesNotExist) {
                return null;
            }
            throw ConnectorException.wrap((Throwable)e);
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public void deleteGroup(String id) {
        try {
            this.groupService.deleteGroup(id);
        }
        catch (AppsForYourDomainException e) {
            if (e.getErrorCode() == AppsForYourDomainErrorCode.EntityDoesNotExist) {
                throw new UnknownUidException(new Uid(id), ObjectClass.GROUP);
            }
            throw ConnectorException.wrap((Throwable)e);
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public void addGroupMember(String groupId, String memberId) {
        try {
            this.groupService.addMemberToGroup(groupId, memberId);
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public void removeGroupMember(String groupId, String memberId) {
        try {
            this.groupService.deleteMemberFromGroup(groupId, memberId);
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public void createGroup(String id, String Name2, String groupDescription, String emailPermission) {
        try {
            this.groupService.createGroup(id, Name2, groupDescription, emailPermission);
        }
        catch (AppsForYourDomainException e) {
            if (e.getErrorCode() == AppsForYourDomainErrorCode.EntityExists) {
                throw new AlreadyExistsException((Throwable)e);
            }
            throw ConnectorException.wrap((Throwable)e);
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public List<String> getMembersAsList(String id) {
        ArrayList<String> members = new ArrayList<String>();
        try {
            GenericFeed groupsFeed = this.groupService.retrieveAllMembers(id);
            Iterator groupsEntryIterator = groupsFeed.getEntries().iterator();
            while (groupsEntryIterator.hasNext()) {
                members.add(((GenericEntry)groupsEntryIterator.next()).getProperty("memberId"));
            }
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
        return members;
    }

    public List<String> getOwnersAsList(String id) {
        ArrayList<String> owners = new ArrayList<String>();
        try {
            GenericFeed groupsFeed = this.groupService.retreiveGroupOwners(id);
            Iterator groupsEntryIterator = groupsFeed.getEntries().iterator();
            while (groupsEntryIterator.hasNext()) {
                owners.add(((GenericEntry)groupsEntryIterator.next()).getProperty("email"));
            }
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
        return owners;
    }

    public class GoogleAppsAccountIterator
    implements Iterator {
        URL retrieveUrl;
        UserFeed currentPage;
        Iterator userIterator;

        public GoogleAppsAccountIterator() {
            try {
                this.retrieveUrl = new URL(GoogleAppsClient.this.domainUrlBase + "user/" + GoogleAppsClient.SERVICE_VERSION + "/");
                this.currentPage = (UserFeed)GoogleAppsClient.this.userService.getFeed(this.retrieveUrl, UserFeed.class);
            }
            catch (Exception ex) {
                throw new RuntimeException("Error creating google apps iterator", ex);
            }
        }

        public UserEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Unexpected end of user list");
            }
            UserEntry ue = (UserEntry)this.userIterator.next();
            return ue;
        }

        public void close() {
        }

        @Override
        public boolean hasNext() {
            if (this.currentPage == null) {
                return false;
            }
            if (this.userIterator == null) {
                this.userIterator = this.currentPage.getEntries().iterator();
            }
            if (this.userIterator.hasNext()) {
                return true;
            }
            Link nextLink = this.currentPage.getLink("next", ILink.Type.ATOM);
            if (nextLink == null) {
                return false;
            }
            try {
                this.retrieveUrl = new URL(nextLink.getHref());
                this.currentPage = (UserFeed)GoogleAppsClient.this.userService.getFeed(this.retrieveUrl, UserFeed.class);
            }
            catch (Exception ex) {
                throw new RuntimeException("Error trying to fetch next page of results", ex);
            }
            this.userIterator = null;
            return this.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

