/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.googleapps;

import java.net.MalformedURLException;
import java.net.URL;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.spi.AbstractConfiguration;
import org.identityconnectors.framework.spi.ConfigurationProperty;
import org.identityconnectors.googleapps.GoogleAppsConnector;

public class GoogleAppsConfiguration
extends AbstractConfiguration {
    Log log = Log.getLog(GoogleAppsConnector.class);
    private String url;
    private String domain;
    private String login;
    private String password;

    @ConfigurationProperty(order=1, helpMessageKey="ADMIN_URL_HELP", displayMessageKey="ADMIN_URL_DISPLAY")
    public String getConnectionUrl() {
        return this.url;
    }

    public void setConnectionUrl(String url) {
        this.url = url;
    }

    @ConfigurationProperty(order=2, helpMessageKey="DOMAIN_HELP", displayMessageKey="DOMAIN_DISPLAY")
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @ConfigurationProperty(order=3, helpMessageKey="LOGIN_HELP", displayMessageKey="LOGIN_DISPLAY")
    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    @ConfigurationProperty(order=4, helpMessageKey="PWD_HELP", displayMessageKey="PWD_DISPLAY", confidential=true)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void validate() {
        this.log.info("validate url={0} login={1} domain={2}", new Object[]{this.getConnectionUrl(), this.getLogin(), this.getDomain()});
        if (StringUtil.isBlank((String)this.getConnectionUrl())) {
            throw new IllegalArgumentException("Connection URL is mandatory");
        }
        if (StringUtil.isBlank((String)this.getLogin())) {
            throw new IllegalArgumentException("Admin Login id is mandatory");
        }
        if (this.getLogin().indexOf("@") >= 0) {
            throw new IllegalArgumentException("Admin Login must not contain @domain component");
        }
        if (StringUtil.isBlank((String)this.getDomain())) {
            throw new IllegalArgumentException("Domain name is mandatory");
        }
        if (StringUtil.isBlank((String)this.getPassword())) {
            throw new IllegalArgumentException("password is mandatory");
        }
        try {
            new URL(this.getConnectionUrl());
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Malformed URL format", ex);
        }
    }

    public String toString() {
        return "GoogleAppsConfiguration( Url= " + this.getConnectionUrl() + " login= " + this.getLogin() + " domain=" + this.getDomain() + ")";
    }
}

