/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.googleapps;

import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.googleapps.GoogleAppsClient;
import org.identityconnectors.googleapps.GoogleAppsConfiguration;

public class GoogleAppsConnection {
    private GoogleAppsClient gapps;
    final GoogleAppsConfiguration config;

    public GoogleAppsConnection(GoogleAppsConfiguration config) {
        this.config = config;
        this.gapps = this.getClient(config);
    }

    public GoogleAppsClient getConnection() {
        return this.gapps;
    }

    private GoogleAppsClient getClient(GoogleAppsConfiguration config) {
        GoogleAppsClient ret = null;
        try {
            String url = config.getConnectionUrl();
            String login = config.getLogin();
            String password = config.getPassword();
            String domain = config.getDomain();
            ret = new GoogleAppsClient(login, password, url, domain);
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
        return ret;
    }

    public GoogleAppsClient getGoogleAppsClient() {
        return this.gapps;
    }

    public void dispose() {
        this.gapps = null;
    }

    public void test() {
        this.gapps.testConnection();
    }
}

