/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.googleapps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.AttributesAccessor;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributeInfos;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SchemaBuilder;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.spi.AttributeNormalizer;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.PoolableConnector;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.DeleteOp;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.TestOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;
import org.identityconnectors.googleapps.GoogleAppsClient;
import org.identityconnectors.googleapps.GoogleAppsConfiguration;
import org.identityconnectors.googleapps.GoogleAppsConnection;
import org.identityconnectors.googleapps.GoogleAppsFilterTranslator;
import org.identityconnectors.googleapps.GoogleAppsGroupOps;
import org.identityconnectors.googleapps.GoogleAppsUserOps;

@ConnectorClass(configurationClass=GoogleAppsConfiguration.class, displayNameKey="googleapps.connector.display")
public class GoogleAppsConnector
implements PoolableConnector,
CreateOp,
SearchOp<String>,
DeleteOp,
SchemaOp,
UpdateOp,
TestOp,
AttributeNormalizer {
    public static final String ATTR_FAMILY_NAME = "familyName";
    public static final String ATTR_GIVEN_NAME = "givenName";
    public static final String ATTR_QUOTA = "quota";
    public static final String ATTR_NICKNAME_LIST = "nicknames";
    public static final String ATTR_GROUP_LIST = "groups";
    public static final String ATTR_MEMBER_LIST = "members";
    public static final String ATTR_OWNER_LIST = "owners";
    public static final String ATTR_GROUP_TEXT_NAME = "groupName";
    public static final String ATTR_GROUP_DESCRIPTION = "groupDescription";
    public static final String ATTR_GROUP_PERMISSIONS = "groupPermissions";
    Log log = Log.getLog(GoogleAppsConnector.class);
    private GoogleAppsConnection gc;
    private GoogleAppsConfiguration config;
    private GoogleAppsUserOps userOps;
    private GoogleAppsGroupOps groupOps;

    public void init(Configuration cfg) {
        this.config = (GoogleAppsConfiguration)cfg;
        this.gc = this.newConnection();
        this.userOps = new GoogleAppsUserOps(this.gc);
        this.groupOps = new GoogleAppsGroupOps(this.gc);
    }

    public void dispose() {
    }

    public Schema schema() {
        if (this.config == null) {
            throw new IllegalStateException("Configuration object has not been set.");
        }
        SchemaBuilder schemaBuilder = new SchemaBuilder(this.getClass());
        HashSet<AttributeInfo> attributes = new HashSet<AttributeInfo>();
        AttributeInfoBuilder name = new AttributeInfoBuilder();
        name.setCreateable(true);
        name.setUpdateable(false);
        name.setRequired(true);
        name.setName(Name.NAME);
        attributes.add(name.build());
        attributes.add(AttributeInfoBuilder.build((String)ATTR_FAMILY_NAME, String.class, EnumSet.of(AttributeInfo.Flags.REQUIRED)));
        attributes.add(AttributeInfoBuilder.build((String)ATTR_GIVEN_NAME, String.class, EnumSet.of(AttributeInfo.Flags.REQUIRED)));
        AttributeInfoBuilder q = new AttributeInfoBuilder();
        q.setCreateable(true);
        q.setName(ATTR_QUOTA);
        q.setType(Integer.class);
        q.setUpdateable(false);
        q.setReadable(true);
        attributes.add(q.build());
        attributes.add(this.buildMultivaluedAttribute(ATTR_NICKNAME_LIST, String.class, false, false));
        attributes.add(this.buildMultivaluedAttribute(ATTR_GROUP_LIST, String.class, false, false));
        attributes.add(AttributeInfoBuilder.build((String)OperationalAttributes.PASSWORD_NAME, GuardedString.class, EnumSet.of(AttributeInfo.Flags.NOT_READABLE, AttributeInfo.Flags.NOT_RETURNED_BY_DEFAULT, AttributeInfo.Flags.REQUIRED)));
        attributes.add(OperationalAttributeInfos.ENABLE);
        schemaBuilder.defineObjectClass(ObjectClass.ACCOUNT_NAME, attributes);
        attributes = new HashSet();
        attributes.add(name.build());
        attributes.add(AttributeInfoBuilder.build((String)ATTR_GROUP_TEXT_NAME, String.class, EnumSet.of(AttributeInfo.Flags.REQUIRED)));
        attributes.add(AttributeInfoBuilder.build((String)ATTR_GROUP_DESCRIPTION, String.class, EnumSet.of(AttributeInfo.Flags.REQUIRED)));
        attributes.add(AttributeInfoBuilder.build((String)ATTR_GROUP_PERMISSIONS, String.class, EnumSet.of(AttributeInfo.Flags.REQUIRED)));
        attributes.add(this.buildMultivaluedAttribute(ATTR_OWNER_LIST, String.class, false, false));
        attributes.add(this.buildMultivaluedAttribute(ATTR_MEMBER_LIST, String.class, false, false));
        schemaBuilder.defineObjectClass(ObjectClass.GROUP_NAME, attributes);
        return schemaBuilder.build();
    }

    public GoogleAppsConnection newConnection() {
        return new GoogleAppsConnection(this.config);
    }

    public void setConnection(GoogleAppsConnection conn) {
        this.gc = conn;
    }

    public Uid create(ObjectClass oclass, Set<Attribute> attrs, OperationOptions arg2) {
        Name name = AttributeUtil.getNameFromAttributes(attrs);
        this.log.info("Create {0}", new Object[]{name});
        AttributesAccessor a = new AttributesAccessor(attrs);
        if (name == null) {
            return null;
        }
        if (ObjectClass.ACCOUNT.equals((Object)oclass)) {
            return this.userOps.createUser(name, a);
        }
        if (ObjectClass.GROUP.equals((Object)oclass)) {
            return this.groupOps.createGroup(name, a);
        }
        throw new IllegalArgumentException("Unsupported Object Class=" + oclass.getObjectClassValue());
    }

    public void delete(ObjectClass objClass, Uid uid, OperationOptions options) {
        String id = uid.getUidValue();
        this.log.info("Deleting {0}", new Object[]{id});
        if (ObjectClass.ACCOUNT.equals((Object)objClass)) {
            this.userOps.delete(id);
        } else if (ObjectClass.GROUP.equals((Object)objClass)) {
            this.groupOps.delete(id);
        } else {
            throw new IllegalArgumentException("Unsupported Object Class=" + objClass.getObjectClassValue());
        }
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    private AttributeInfo buildMultivaluedAttribute(String name, Class<?> clazz, boolean required, boolean returnByDefault) {
        AttributeInfoBuilder builder = new AttributeInfoBuilder();
        builder.setName(name);
        builder.setType(clazz);
        builder.setRequired(required);
        builder.setMultiValued(true);
        builder.setReturnedByDefault(returnByDefault);
        return builder.build();
    }

    public FilterTranslator<String> createFilterTranslator(ObjectClass arg0, OperationOptions arg1) {
        return new GoogleAppsFilterTranslator();
    }

    public void executeQuery(ObjectClass oclass, String query, ResultsHandler handler, OperationOptions ops) {
        this.log.info("query string = {0} options = {1}", new Object[]{query, ops.getAttributesToGet()});
        if (ObjectClass.ACCOUNT.equals((Object)oclass)) {
            this.userOps.query(query, handler, ops);
        } else if (ObjectClass.GROUP.equals((Object)oclass)) {
            this.groupOps.query(query, handler, ops);
        } else {
            throw new IllegalArgumentException("Unsupported objectclass '" + oclass + "'");
        }
    }

    public Uid update(ObjectClass objclass, Uid uid, Set<Attribute> replaceAttrs, OperationOptions options) {
        this.log.info("Update {0}", new Object[]{replaceAttrs});
        if (uid == null) {
            throw new ConnectorException("Uid attribute is missing!");
        }
        if (replaceAttrs == null || replaceAttrs.size() == 0) {
            throw new IllegalArgumentException("Invalid attributes provided to a update operation.");
        }
        if (ObjectClass.ACCOUNT.equals((Object)objclass)) {
            return this.userOps.updateUser(uid, replaceAttrs, options);
        }
        if (ObjectClass.GROUP.equals((Object)objclass)) {
            return this.groupOps.updateGroup(uid, replaceAttrs, options);
        }
        throw new IllegalArgumentException("Unsupported objectclass '" + objclass + "'");
    }

    public void test() {
        this.log.info("test connection", new Object[0]);
        GoogleAppsClient g = this.gc.getConnection();
        g.testConnection();
    }

    public void checkAlive() {
        this.log.info("checkAlive", new Object[0]);
        this.test();
    }

    public Attribute normalizeAttribute(ObjectClass oclass, Attribute attribute) {
        if (ObjectClass.ACCOUNT.equals((Object)oclass)) {
            if (attribute.is(Name.NAME) || attribute.is(Uid.NAME)) {
                return AttributeBuilder.build((String)attribute.getName(), (Object[])new Object[]{AttributeUtil.getStringValue((Attribute)attribute).toLowerCase()});
            }
            if (attribute.is(ATTR_GROUP_LIST)) {
                return this.normalizeDomainAttribute(attribute);
            }
            if (attribute.is(ATTR_NICKNAME_LIST)) {
                List values = attribute.getValue();
                if (values == null) {
                    return attribute;
                }
                ArrayList<String> normalized = new ArrayList<String>(values.size());
                for (Object value : values) {
                    assert (value instanceof String);
                    String strValue = (String)value;
                    normalized.add(strValue.toLowerCase());
                }
                Collections.sort(normalized);
                return AttributeBuilder.build((String)attribute.getName(), normalized);
            }
        } else if (ObjectClass.GROUP.equals((Object)oclass) && (attribute.is(Name.NAME) || attribute.is(Uid.NAME) || attribute.is(ATTR_MEMBER_LIST) || attribute.is(ATTR_OWNER_LIST))) {
            return this.normalizeDomainAttribute(attribute);
        }
        return attribute;
    }

    private Attribute normalizeDomainAttribute(Attribute attribute) {
        List values = attribute.getValue();
        if (values == null) {
            return attribute;
        }
        ArrayList<String> normalized = new ArrayList<String>(values.size());
        for (Object value : values) {
            assert (value instanceof String);
            String strValue = (String)value;
            normalized.add(this.normalizeDomainValue(strValue));
        }
        return AttributeBuilder.build((String)attribute.getName(), normalized);
    }

    private String normalizeDomainValue(String oldValue) {
        String newValue = oldValue;
        if (oldValue.indexOf(64) == -1) {
            StringBuilder sb = new StringBuilder(oldValue);
            sb.append("@").append(this.config.getDomain());
            newValue = sb.toString();
        }
        return newValue.toLowerCase();
    }
}

