/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.googleapps;

import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.AbstractFilterTranslator;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;

public class GoogleAppsFilterTranslator
extends AbstractFilterTranslator<String> {
    protected String createEqualsExpression(EqualsFilter filter, boolean not) {
        if (not) {
            return null;
        }
        Attribute attr = filter.getAttribute();
        if (!attr.is(Name.NAME) && !attr.is(Uid.NAME)) {
            return null;
        }
        String name = attr.getName();
        String value = AttributeUtil.getAsStringValue((Attribute)attr);
        if (this.checkSearchValue(value) == null) {
            return null;
        }
        return value;
    }

    private String checkSearchValue(String value) {
        if (StringUtil.isEmpty((String)value)) {
            return null;
        }
        if (value.contains("*") || value.contains("&") || value.contains("|")) {
            throw new IllegalArgumentException("Value of search attribute contains illegal character(s).");
        }
        return value;
    }
}

