/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.googleapps;

import com.google.gdata.data.appsforyourdomain.generic.GenericEntry;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributesAccessor;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.googleapps.ChangeSetExecutor;
import org.identityconnectors.googleapps.GoogleAppsClient;
import org.identityconnectors.googleapps.GoogleAppsConnection;

public class GoogleAppsGroupOps {
    GoogleAppsConnection gc;
    Log log = Log.getLog(GoogleAppsGroupOps.class);

    GoogleAppsGroupOps(GoogleAppsConnection gc) {
        this.gc = gc;
    }

    Uid createGroup(Name name, AttributesAccessor a) {
        String groupId = a.getName().getNameValue();
        String groupName = a.findString("groupName");
        String description = a.findString("groupDescription");
        String permissions = a.findString("groupPermissions");
        GoogleAppsClient g = this.gc.getConnection();
        List members = a.findStringList("members");
        List owners = a.findStringList("owners");
        this.log.info("Create group({0},{1},{2},{3})", new Object[]{groupId, groupName, description, permissions});
        g.createGroup(groupId, groupName, description, permissions);
        if (members != null) {
            for (String member : members) {
                this.log.info("Adding member {0} to group {1}", new Object[]{member, groupId});
                g.addGroupMember(groupId, member);
            }
        }
        if (owners != null) {
            for (String owner : owners) {
                this.log.info("Adding member {0} to group {1}", new Object[]{owner, groupId});
                g.addGroupOwner(groupId, owner);
            }
        }
        return new Uid(groupId);
    }

    void delete(String id) {
        GoogleAppsClient g = this.gc.getConnection();
        g.deleteGroup(id);
    }

    void query(String query, ResultsHandler handler, OperationOptions ops) {
        String[] attrs;
        GoogleAppsClient g = this.gc.getConnection();
        boolean fetchMembers = false;
        boolean fetchOwners = false;
        if (ops != null && (attrs = ops.getAttributesToGet()) != null) {
            List<String> alist = Arrays.asList(attrs);
            if (alist.contains("members")) {
                fetchMembers = true;
            }
            if (alist.contains("owners")) {
                fetchOwners = true;
            }
        }
        if (query == null) {
            this.log.info("Fetching All Groups", new Object[0]);
            Iterator i = g.getGroupIterator();
            while (i.hasNext()) {
                GenericEntry ge = (GenericEntry)i.next();
                List<String> members = null;
                List<String> owners = null;
                String groupId = ge.getProperty("groupId");
                if (fetchMembers) {
                    members = g.getMembersAsList(groupId);
                }
                if (fetchOwners) {
                    owners = g.getOwnersAsList(groupId);
                }
                handler.handle(this.makeConnectorObject(ge, members, owners));
            }
        } else {
            ConnectorObject obj = this.getGroup(query, fetchMembers, fetchOwners);
            this.log.info("ConnectorObj {0}", new Object[]{obj});
            if (obj != null) {
                handler.handle(obj);
            }
        }
    }

    Uid updateGroup(Uid uid, Set<Attribute> replaceAttrs, OperationOptions options) {
        AttributesAccessor a = new AttributesAccessor(replaceAttrs);
        final String groupId = uid.getUidValue();
        String groupName = a.findString("groupName");
        String description = a.findString("groupDescription");
        String permissions = a.findString("groupPermissions");
        final GoogleAppsClient g = this.gc.getConnection();
        List members = a.findStringList("members");
        List owners = a.findStringList("owners");
        this.log.info("updating group id:{0} name:{1} description: {2} permissions: {3}", new Object[]{groupId, groupName, description, permissions});
        g.updateGroup(groupId, groupName, description, permissions);
        if (members != null) {
            List<String> currentMembers = g.getMembersAsList(groupId);
            this.log.info("Existing groups for group {0} are: {1}", new Object[]{groupId, currentMembers});
            new ChangeSetExecutor(currentMembers, members){

                @Override
                public void doAdd(String user) {
                    GoogleAppsGroupOps.this.log.info("Adding user {0}", new Object[]{user});
                    g.addGroupMember(groupId, user);
                }

                @Override
                public void doRemove(String user) {
                    GoogleAppsGroupOps.this.log.info("Removing user {0}", new Object[]{user});
                    g.removeGroupMember(groupId, user);
                }
            }.execute();
        }
        if (owners != null) {
            List<String> currentOwners = g.getMembersAsList(groupId);
            this.log.info("Existing groups for group {0} are: {1}", new Object[]{groupId, currentOwners});
            new ChangeSetExecutor(currentOwners, owners){

                @Override
                public void doAdd(String user) {
                    GoogleAppsGroupOps.this.log.info("Adding user {0}", new Object[]{user});
                    g.addGroupOwner(groupId, user);
                }

                @Override
                public void doRemove(String user) {
                    GoogleAppsGroupOps.this.log.info("Removing user {0}", new Object[]{user});
                    g.removeGroupOwner(groupId, user);
                }
            }.execute();
        }
        return uid;
    }

    private ConnectorObject makeConnectorObject(GenericEntry ge, List<String> members, List<String> owners) {
        if (ge == null) {
            return null;
        }
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(ObjectClass.GROUP);
        builder.setUid(ge.getProperty("groupId"));
        builder.setName(ge.getProperty("groupId"));
        String d = ge.getProperty("description");
        String p = ge.getProperty("emailPermission");
        String n = ge.getProperty("groupName");
        builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"groupDescription", (Object[])new Object[]{d})});
        builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"groupName", (Object[])new Object[]{n})});
        builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"groupPermissions", (Object[])new Object[]{p})});
        if (owners != null) {
            builder.addAttribute("owners", owners);
        }
        if (members != null) {
            builder.addAttribute("members", members);
        }
        return builder.build();
    }

    private ConnectorObject getGroup(String id, boolean fetchMembers, boolean fetchOwners) {
        GenericEntry ge = null;
        GoogleAppsClient g = this.gc.getConnection();
        this.log.info("Fetching google apps group {0}", new Object[]{id});
        ge = g.getGroupEntry(id);
        if (ge != null) {
            List<String> members = null;
            List<String> owners = null;
            if (fetchMembers) {
                members = g.getMembersAsList(id);
            }
            if (fetchOwners) {
                owners = g.getOwnersAsList(id);
            }
            return this.makeConnectorObject(ge, members, owners);
        }
        return null;
    }
}

