/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.googleapps;

import com.google.gdata.data.appsforyourdomain.Quota;
import com.google.gdata.data.appsforyourdomain.provisioning.UserEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributesAccessor;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.googleapps.ChangeSetExecutor;
import org.identityconnectors.googleapps.GoogleAppsClient;
import org.identityconnectors.googleapps.GoogleAppsConnection;

public class GoogleAppsUserOps {
    GoogleAppsConnection gc;
    Log log = Log.getLog(GoogleAppsUserOps.class);
    private final List<String> emptyList = new ArrayList<String>(1);

    GoogleAppsUserOps(GoogleAppsConnection gc) {
        this.gc = gc;
    }

    Uid createUser(Name name, AttributesAccessor a) {
        List owners;
        List groups;
        String accountId = a.getName().getNameValue();
        GoogleAppsClient g = this.gc.getConnection();
        String givenName = a.findString("givenName");
        String familyName = a.findString("familyName");
        Integer quota = a.findInteger("quota");
        GuardedString password = a.getPassword();
        if (password == null) {
            throw new IllegalArgumentException("The Password attribute cannot be null.");
        }
        boolean suspended = !a.getEnabled(true);
        String clearPw = GoogleAppsUserOps.getPlainPassword(password);
        UserEntry ue = g.setUserEntry(null, accountId, clearPw, givenName, familyName, suspended, quota);
        this.log.info("Creating User {0} givenName: {1} familyName {2} ", new Object[]{accountId, givenName, familyName});
        ue = g.createUser(ue);
        List nicks = a.findStringList("nicknames");
        if (nicks != null) {
            for (String nickname : nicks) {
                this.log.info("Adding nickname {0} to account {1}", new Object[]{nickname, accountId});
                g.createNickname(accountId, nickname);
            }
        }
        if (!CollectionUtil.isEmpty((Collection)(groups = a.findStringList("groups")))) {
            for (String group : groups) {
                g.addGroupMember(group, accountId);
            }
        }
        if (!CollectionUtil.isEmpty((Collection)(owners = a.findStringList("owners")))) {
            for (String owner : owners) {
                g.addGroupMember(owner, accountId);
            }
        }
        return new Uid(accountId);
    }

    public static String getPlainPassword(GuardedString password) {
        if (password == null) {
            return null;
        }
        final StringBuffer buf = new StringBuffer();
        password.access(new GuardedString.Accessor(){

            public void access(char[] clearChars) {
                buf.append(clearChars);
            }
        });
        return buf.toString();
    }

    void delete(String id) {
        GoogleAppsClient g = this.gc.getConnection();
        g.deleteUser(id);
    }

    void query(String query, ResultsHandler handler, OperationOptions ops) {
        String[] attrs;
        GoogleAppsClient g = this.gc.getConnection();
        boolean fetchNicknames = false;
        boolean fetchGroups = false;
        if (ops != null && (attrs = ops.getAttributesToGet()) != null) {
            List<String> alist = Arrays.asList(attrs);
            if (alist.contains("nicknames")) {
                fetchNicknames = true;
            }
            if (alist.contains("groups")) {
                fetchGroups = true;
            }
        }
        if (query == null) {
            this.log.info("Fetching All Users", new Object[0]);
            GoogleAppsClient.GoogleAppsAccountIterator i = g.getIterator();
            while (i.hasNext()) {
                UserEntry ue = (UserEntry)i.next();
                ArrayList<String> nicknames = new ArrayList();
                ArrayList<String> groups = new ArrayList();
                String accountId = ue.getLogin().getUserName();
                if (fetchNicknames) {
                    nicknames = g.getNicknamesAsList(accountId);
                }
                if (fetchGroups) {
                    groups = g.getGroupMembershipsForUser(accountId);
                }
                handler.handle(this.makeConnectorObject(ue, nicknames, groups));
            }
        } else {
            ConnectorObject obj = this.get(query, fetchNicknames, fetchGroups);
            this.log.info("ConnectorObj {0}", new Object[]{obj});
            if (obj != null) {
                handler.handle(obj);
            }
        }
    }

    private ConnectorObject makeConnectorObject(UserEntry ue, List<String> nicknames, List<String> groups) {
        if (ue == null) {
            return null;
        }
        ObjectClass objectClass = ObjectClass.ACCOUNT;
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        Uid uid = new Uid(ue.getLogin().getUserName());
        builder.setUid(uid);
        builder.setName(uid.getUidValue());
        String familyName = ue.getName().getFamilyName();
        String givenName = ue.getName().getGivenName();
        boolean suspended = ue.getLogin().getSuspended();
        builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"familyName", (Object[])new Object[]{familyName})});
        builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"givenName", (Object[])new Object[]{givenName})});
        builder.addAttribute(new Attribute[]{AttributeBuilder.buildEnabled((!suspended ? 1 : 0) != 0)});
        builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"nicknames", nicknames)});
        builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"groups", groups)});
        Quota quota = ue.getQuota();
        if (quota != null) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"quota", (Object[])new Object[]{quota.getLimit()})});
        }
        this.log.info("Make object uid={0} fn={1} gn={2} nicks={3} groups={4}", new Object[]{uid, familyName, givenName, nicknames, groups});
        return builder.build();
    }

    private ConnectorObject get(String id, boolean fetchNicknames, boolean fetchGroups) {
        UserEntry ue = null;
        GoogleAppsClient g = this.gc.getConnection();
        this.log.info("Fetching google apps user {0}", new Object[]{id});
        ue = g.getUserEntry(id);
        this.log.info("UserEntry = {0}", new Object[]{GoogleAppsClient.userEntrytoString(ue)});
        if (ue != null) {
            List<String> nicks = fetchNicknames ? g.getNicknamesAsList(id) : this.emptyList;
            List<String> groups = fetchGroups ? g.getGroupMembershipsForUser(id) : this.emptyList;
            return this.makeConnectorObject(ue, nicks, groups);
        }
        return null;
    }

    Uid updateUser(Uid uid, Set<Attribute> replaceAttrs, OperationOptions options) {
        List groupsToUpdate;
        List nicknamesToUpdate;
        boolean justDoNicknames;
        AttributesAccessor a = new AttributesAccessor(replaceAttrs);
        final String accountId = uid.getUidValue();
        final GoogleAppsClient g = this.gc.getConnection();
        boolean bl = justDoNicknames = replaceAttrs.size() == 1 && a.findStringList("nicknames") != null;
        if (!justDoNicknames) {
            UserEntry userEntry = g.getUserEntry(accountId);
            if (userEntry == null) {
                throw new ConnectorException("Update failed. Could not read current state for user " + accountId);
            }
            this.log.info("Rerieved UserEntry {0}", new Object[]{GoogleAppsClient.userEntrytoString(userEntry)});
            String password = GoogleAppsUserOps.getPlainPassword(a.getPassword());
            String first = a.findString("familyName");
            String given = a.findString("givenName");
            boolean suspended = !a.getEnabled(true);
            UserEntry ue = g.setUserEntry(userEntry, accountId, password, given, first, suspended, null);
            ue = g.updateUser(accountId, ue);
        }
        if ((nicknamesToUpdate = a.findStringList("nicknames")) != null) {
            List<String> currentNames = g.getNicknamesAsList(accountId);
            this.log.info("Existing nickname for account {0} are: {1}", new Object[]{accountId, currentNames});
            new ChangeSetExecutor(currentNames, nicknamesToUpdate){

                @Override
                public void doAdd(String nickname) {
                    GoogleAppsUserOps.this.log.info("Adding nickname ${0} to user {1}", new Object[]{nickname, accountId});
                    g.createNickname(accountId, nickname);
                }

                @Override
                public void doRemove(String nickname) {
                    GoogleAppsUserOps.this.log.info("Removing nickname {0}", new Object[]{nickname});
                    g.deleteNickname(nickname);
                }
            }.execute();
        }
        if ((groupsToUpdate = a.findStringList("groups")) != null) {
            List<String> currentGroups = g.getGroupMembershipsForUser(accountId);
            this.log.info("Existing groups for account {0} are: {1}", new Object[]{accountId, currentGroups});
            new ChangeSetExecutor(currentGroups, groupsToUpdate){

                @Override
                public void doAdd(String group) {
                    GoogleAppsUserOps.this.log.info("Adding group ${0} to user {1}", new Object[]{group, accountId});
                    g.addGroupMember(group, accountId);
                }

                @Override
                public void doRemove(String group) {
                    GoogleAppsUserOps.this.log.info("Removing user from group {0}", new Object[]{group});
                    g.removeGroupMember(group, accountId);
                }
            }.execute();
        }
        return new Uid(accountId);
    }
}

