/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import org.controlsfx.DialogResources;

public class ChoiceDialog<T>
extends Dialog<T> {
    private final GridPane grid;
    private final Label label;
    private final ComboBox<T> comboBox;
    private final T defaultChoice;

    public ChoiceDialog() {
        this(null, (Object[])null);
    }

    public ChoiceDialog(T defaultChoice, T ... choices) {
        this(defaultChoice, choices == null ? Collections.emptyList() : Arrays.asList(choices));
    }

    public ChoiceDialog(T defaultChoice, Collection<T> choices) {
        DialogPane dialogPane = this.getDialogPane();
        this.grid = new GridPane();
        this.grid.setHgap(10.0);
        this.grid.setMaxWidth(Double.MAX_VALUE);
        this.grid.setAlignment(Pos.CENTER_LEFT);
        this.label = DialogPane.createContentLabel(dialogPane.getContentText());
        this.label.setPrefWidth(-1.0);
        this.label.textProperty().bind((ObservableValue)dialogPane.contentTextProperty());
        dialogPane.contentTextProperty().addListener(o -> this.updateGrid());
        this.setTitle(DialogResources.getString("Dialog.confirm.title"));
        dialogPane.setHeaderText(DialogResources.getString("Dialog.confirm.header"));
        dialogPane.getStyleClass().add((Object)"choice-dialog");
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        double MIN_WIDTH = 150.0;
        this.comboBox = new ComboBox();
        this.comboBox.setMinWidth(150.0);
        if (choices != null) {
            this.comboBox.getItems().addAll(choices);
        }
        this.comboBox.setMaxWidth(Double.MAX_VALUE);
        GridPane.setHgrow(this.comboBox, (Priority)Priority.ALWAYS);
        GridPane.setFillWidth(this.comboBox, (Boolean)true);
        Object object = this.defaultChoice = this.comboBox.getItems().contains(defaultChoice) ? defaultChoice : null;
        if (defaultChoice == null) {
            this.comboBox.getSelectionModel().selectFirst();
        } else {
            this.comboBox.getSelectionModel().select(defaultChoice);
        }
        this.updateGrid();
        this.setResultConverter(dialogButton -> {
            ButtonBar.ButtonData data = dialogButton == null ? null : dialogButton.getButtonData();
            return data == ButtonBar.ButtonData.OK_DONE ? this.getSelectedItem() : null;
        });
    }

    public final T getSelectedItem() {
        return (T)this.comboBox.getSelectionModel().getSelectedItem();
    }

    public final ReadOnlyObjectProperty<T> selectedItemProperty() {
        return this.comboBox.getSelectionModel().selectedItemProperty();
    }

    public final void setSelectedItem(T item) {
        this.comboBox.getSelectionModel().select(item);
    }

    public final ObservableList<T> getItems() {
        return this.comboBox.getItems();
    }

    public final T getDefaultChoice() {
        return this.defaultChoice;
    }

    private void updateGrid() {
        this.grid.getChildren().clear();
        this.grid.add((Node)this.label, 0, 0);
        this.grid.add(this.comboBox, 1, 0);
        this.getDialogPane().setContent((Node)this.grid);
        Platform.runLater(() -> this.comboBox.requestFocus());
    }
}

