/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import org.controlsfx.DialogResources;

public class TextInputDialog
extends Dialog<String> {
    private final GridPane grid;
    private final Label label;
    private final TextField textField;
    private final String defaultValue;

    public TextInputDialog() {
        this("");
    }

    public TextInputDialog(@NamedArg(value="defaultValue") String defaultValue) {
        DialogPane dialogPane = this.getDialogPane();
        this.textField = new TextField(defaultValue);
        this.textField.setMaxWidth(Double.MAX_VALUE);
        GridPane.setHgrow((Node)this.textField, (Priority)Priority.ALWAYS);
        GridPane.setFillWidth((Node)this.textField, (Boolean)true);
        this.label = DialogPane.createContentLabel(dialogPane.getContentText());
        this.label.setPrefWidth(-1.0);
        this.label.textProperty().bind((ObservableValue)dialogPane.contentTextProperty());
        this.defaultValue = defaultValue;
        this.grid = new GridPane();
        this.grid.setHgap(10.0);
        this.grid.setMaxWidth(Double.MAX_VALUE);
        this.grid.setAlignment(Pos.CENTER_LEFT);
        dialogPane.contentTextProperty().addListener(o -> this.updateGrid());
        this.setTitle(DialogResources.getString("Dialog.confirm.title"));
        dialogPane.setHeaderText(DialogResources.getString("Dialog.confirm.header"));
        dialogPane.getStyleClass().add((Object)"text-input-dialog");
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.updateGrid();
        this.setResultConverter(dialogButton -> {
            ButtonBar.ButtonData data = dialogButton == null ? null : dialogButton.getButtonData();
            return data == ButtonBar.ButtonData.OK_DONE ? this.textField.getText() : null;
        });
    }

    public final TextField getEditor() {
        return this.textField;
    }

    public final String getDefaultValue() {
        return this.defaultValue;
    }

    private void updateGrid() {
        this.grid.getChildren().clear();
        this.grid.add((Node)this.label, 0, 0);
        this.grid.add((Node)this.textField, 1, 0);
        this.getDialogPane().setContent((Node)this.grid);
        Platform.runLater(() -> this.textField.requestFocus());
    }
}

