/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.shiro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisCache<K, V>
implements Cache<K, V> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Jedis cache;
    private int expire;

    public RedisCache(Jedis cache) {
        if (cache == null) {
            throw new IllegalArgumentException("Cache argument cannot be null.");
        }
        this.cache = cache;
    }

    public RedisCache(Jedis cache, int expire) {
        if (cache == null) {
            throw new IllegalArgumentException("Cache argument cannot be null.");
        }
        this.cache = cache;
        this.expire = expire;
    }

    private byte[] getByteKey(K key) {
        if (key instanceof String) {
            return ((String)key).getBytes();
        }
        return this.serialize(key);
    }

    public V get(K key) throws CacheException {
        this.logger.debug("\u6839\u636ekey\u4eceRedis\u4e2d\u83b7\u53d6\u5bf9\u8c61 key [" + key + "]");
        try {
            if (key == null) {
                return null;
            }
            byte[] rawValue = this.cache.get(this.getByteKey(key));
            Object value = this.deserialize(rawValue);
            return (V)value;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public V put(K key, V value) throws CacheException {
        this.logger.debug("\u6839\u636ekey\u4ece\u5b58\u50a8 key [" + key + "]");
        try {
            this.cache.set(this.getByteKey(key), this.serialize(value));
            if (this.expire != 0) {
                this.cache.expire(this.getByteKey(key), this.expire);
            }
            return value;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public V remove(K key) throws CacheException {
        this.logger.debug("\u4eceredis\u4e2d\u5220\u9664 key [" + key + "]");
        try {
            V previous = this.get(key);
            this.cache.del((byte[][])new byte[][]{this.getByteKey(key)});
            return previous;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public void clear() throws CacheException {
        this.logger.debug("\u4eceredis\u4e2d\u5220\u9664\u6240\u6709\u5143\u7d20");
        try {
            this.cache.flushDB();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public int size() {
        try {
            Long longSize = new Long(this.cache.dbSize());
            return longSize.intValue();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public Set<K> keys() {
        try {
            Set keys = this.cache.keys("*");
            if (CollectionUtils.isEmpty((Collection)keys)) {
                return Collections.emptySet();
            }
            HashSet<String> newKeys = new HashSet<String>();
            for (String key : keys) {
                newKeys.add(key);
            }
            return newKeys;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public Collection<V> values() {
        try {
            Set keys = this.cache.keys("*");
            if (!CollectionUtils.isEmpty((Collection)keys)) {
                ArrayList<V> values = new ArrayList<V>(keys.size());
                for (String key : keys) {
                    V value = this.get(key);
                    if (value == null) continue;
                    values.add(value);
                }
                return Collections.unmodifiableList(values);
            }
            return Collections.emptyList();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public Object deserialize(byte[] bytes) {
        Object result = null;
        if (this.isEmpty(bytes)) {
            return null;
        }
        try {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(byteStream);
                try {
                    result = objectInputStream.readObject();
                }
                catch (ClassNotFoundException ex) {
                    throw new Exception("Failed to deserialize object type", ex);
                }
            }
            catch (Throwable ex) {
                throw new Exception("Failed to deserialize", ex);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to deserialize", (Throwable)e);
        }
        return result;
    }

    private boolean isEmpty(byte[] data) {
        return data == null || data.length == 0;
    }

    public byte[] serialize(Object object) {
        byte[] result = null;
        if (object == null) {
            return new byte[0];
        }
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream(128);
            try {
                if (!(object instanceof Serializable)) {
                    throw new IllegalArgumentException(this.getClass().getSimpleName() + " requires a Serializable payload " + "but received an object of type [" + object.getClass().getName() + "]");
                }
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
                result = byteStream.toByteArray();
            }
            catch (Throwable ex) {
                throw new Exception("Failed to serialize", ex);
            }
        }
        catch (Exception ex) {
            this.logger.error("Failed to serialize", (Throwable)ex);
        }
        return result;
    }
}

