/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.shiro;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.cache.CacheManager;
import org.crazycake.shiro.RedisCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisCacheManager
implements CacheManager {
    private static final Logger logger = LoggerFactory.getLogger(RedisCacheManager.class);
    private final ConcurrentMap<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    private int expire = 0;
    private String host = "127.0.0.1";
    private int port = 6379;

    public <K, V> Cache<K, V> getCache(String name) throws CacheException {
        logger.debug("\u83b7\u53d6\u540d\u79f0\u4e3a: " + name + " \u7684RedisCache\u5b9e\u4f8b");
        RedisCache c = (RedisCache)this.caches.get(name);
        if (c == null) {
            Jedis cache = new Jedis(this.host, this.port);
            c = new RedisCache(cache, this.expire);
            this.caches.put(name, c);
        }
        return c;
    }

    public int getExpire() {
        return this.expire;
    }

    public void setExpire(int expire) {
        this.expire = expire;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

