/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.criteria;

import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.datanucleus.api.jpa.criteria.CriteriaBuilderImpl;
import org.datanucleus.api.jpa.criteria.ExpressionImpl;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.Literal;

public class LiteralExpression<X>
extends ExpressionImpl {
    X value;

    public LiteralExpression(CriteriaBuilderImpl cb, X value) {
        super(cb, value.getClass());
        this.value = value;
    }

    @Override
    public Expression getQueryExpression() {
        if (this.queryExpr == null) {
            this.queryExpr = new Literal(this.value);
        }
        return this.queryExpr;
    }

    @Override
    public String toString() {
        if (this.value instanceof String || this.value instanceof Character) {
            return "'" + this.value.toString() + "'";
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value != false ? "TRUE" : "FALSE";
        }
        if (this.value instanceof Time) {
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            String timeStr = formatter.format((Time)this.value);
            return "{t '" + timeStr + "'}";
        }
        if (this.value instanceof java.sql.Date) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            String dateStr = formatter.format((java.sql.Date)this.value);
            return "{d '" + dateStr + "'}";
        }
        if (this.value instanceof Date) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String datetimeStr = formatter.format((Date)this.value);
            return "{ts '" + datetimeStr + "'}";
        }
        return "" + this.value;
    }
}

