package org.datanucleus.api.json;

import java.util.Map;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.query.Query;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonAPIImpl implements JsonAPI
{
    NucleusContext ctx;

    ExecutionContext ec;
    
    JsonAPITransaction tx;

    public JsonAPIImpl(Map props)
    {
        //TODO change this to json
        ctx = new NucleusContext("JDO", null);
        ctx.getPersistenceConfiguration().setPersistenceProperties(props);
        ctx.initialise();
        ec = new JsonAPIExecutionContext(ctx);
        tx = new JsonAPITransactionImpl(ec.getTransaction());
    }
    
    /* (non-Javadoc)
     * @see org.datanucleus.rest.JsonAPI#getMetaDataManager()
     */
    public MetaDataManager getMetaDataManager()
    {
        return ctx.getMetaDataManager();
    }
    
    /* (non-Javadoc)
     * @see org.datanucleus.rest.JsonAPI#getClassLoaderResolver()
     */
    public ClassLoaderResolver getClassLoaderResolver()
    {
        return ctx.getClassLoaderResolver(null);
    }
    
    /* (non-Javadoc)
     * @see org.datanucleus.rest.JsonAPI#getTransaction()
     */
    public JsonAPITransaction getTransaction()
    {
        return tx;
    }

    /* (non-Javadoc)
     * @see org.datanucleus.rest.JsonAPI#persist(org.json.JSONObject)
     */
    public void persist(JSONObject obj)
    {
        // TODO This is flawed persistence since it doesn't handle value-generation etc that the StateManager provides
        AbstractClassMetaData acmd = ec.getMetaDataManager().getMetaDataForClass(getType(obj), ec.getClassLoaderResolver());
        ctx.getStoreManager().getPersistenceHandler().insertObject(new JsonAPIObjectProvider(ec, acmd, obj));
    }

    /* (non-Javadoc)
     * @see org.datanucleus.rest.JsonAPI#newQuery(java.lang.String, java.lang.String)
     */
    public Query newQuery(String language, String query)
    {
        return ctx.getStoreManager().getQueryManager().newQuery(language, ec, query);
    }

    /* (non-Javadoc)
     * @see org.datanucleus.rest.JsonAPI#findObject(org.json.JSONObject)
     */
    public JSONObject findObject(JSONObject id)
    {
        AbstractClassMetaData acmd = ec.getMetaDataManager().getMetaDataForClass(getType(id), ec.getClassLoaderResolver());
        JsonAPIObjectProvider op = new JsonAPIObjectProvider(ec, acmd, id);
        ctx.getStoreManager().getPersistenceHandler().fetchObject(op, acmd.getAllMemberPositions());
        return (JSONObject) op.getObject();
    }

    /* (non-Javadoc)
     * @see org.datanucleus.rest.JsonAPI#deleteObject(org.json.JSONObject)
     */
    public void deleteObject(JSONObject id)
    {
        AbstractClassMetaData acmd = ec.getMetaDataManager().getMetaDataForClass(getType(id), ec.getClassLoaderResolver());
        JsonAPIObjectProvider op = new JsonAPIObjectProvider(ec, acmd, id);
        ctx.getStoreManager().getPersistenceHandler().deleteObject(op);
    }

    /* (non-Javadoc)
     * @see org.datanucleus.rest.JsonAPI#close()
     */
    public void close()
    {

    }

    private String getType(JSONObject obj)
    {
        try
        {
            return obj.getString("class");
        }
        catch (JSONException e)
        {
            e.printStackTrace();
        }
        return null;
    }
}
