/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.compiler;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.query.JDOQLQueryHelper;
import org.datanucleus.query.compiler.JDOQLParser;
import org.datanucleus.query.compiler.JavaQueryCompiler;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.symbol.PropertySymbol;
import org.datanucleus.query.symbol.SymbolResolver;
import org.datanucleus.query.symbol.SymbolTable;
import org.datanucleus.util.Imports;

public class JDOQLCompiler
extends JavaQueryCompiler
implements SymbolResolver {
    public JDOQLCompiler(MetaDataManager metaDataManager, ClassLoaderResolver clr, String from, Class candidateClass, Collection candidates, String filter, Imports imports, String ordering, String result, String grouping, String having, String params, String variables) {
        super(metaDataManager, clr, from, candidateClass, candidates, filter, imports, ordering, result, grouping, having, params, variables, null);
    }

    public QueryCompilation compile(Map parameters, Map subqueryMap) {
        HashMap<String, Boolean> parseOptions = new HashMap<String, Boolean>();
        if (this.parameters != null) {
            parseOptions.put("explicitParameters", true);
        } else {
            parseOptions.put("implicitParameters", true);
        }
        this.parser = new JDOQLParser(parseOptions);
        this.symtbl = new SymbolTable(this.clr);
        this.symtbl.setSymbolResolver(this);
        if (this.parentCompiler != null) {
            this.symtbl.setParentSymbolTable(this.parentCompiler.symtbl);
        }
        if (subqueryMap != null && !subqueryMap.isEmpty()) {
            for (String subqueryName : subqueryMap.keySet()) {
                PropertySymbol sym = new PropertySymbol(subqueryName);
                sym.setType(2);
                this.symtbl.addSymbol(sym);
            }
        }
        Expression[] exprFrom = this.compileFrom();
        this.compileCandidatesParametersVariables(parameters);
        Expression exprFilter = this.compileFilter();
        Expression[] exprOrdering = this.compileOrdering();
        Expression[] exprResult = this.compileResult();
        Expression[] exprGrouping = this.compileGrouping();
        Expression exprHaving = this.compileHaving();
        QueryCompilation compilation = new QueryCompilation(this.candidateClass, this.candidateAlias, this.symtbl, exprResult, exprFrom, exprFilter, exprGrouping, exprHaving, exprOrdering, null);
        compilation.setQueryLanguage("JDOQL");
        return compilation;
    }

    public boolean supportsImplicitVariables() {
        return this.variables == null;
    }

    public boolean caseSensitiveSymbolNames() {
        return true;
    }

    public String getLanguage() {
        return "JDOQL";
    }

    protected boolean isKeyword(String name) {
        if (name == null) {
            return false;
        }
        return JDOQLQueryHelper.isKeyword(name);
    }
}

