/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.evaluator.memory;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.evaluator.memory.AggregateExpression;
import org.datanucleus.query.evaluator.memory.BigDecimalAggregateExpression;
import org.datanucleus.query.evaluator.memory.BigIntegerAggregateExpression;
import org.datanucleus.query.evaluator.memory.DateAggregateExpression;
import org.datanucleus.query.evaluator.memory.DoubleAggregateExpression;
import org.datanucleus.query.evaluator.memory.FloatAggregateExpression;
import org.datanucleus.query.evaluator.memory.IntegerAggregateExpression;
import org.datanucleus.query.evaluator.memory.LongAggregateExpression;
import org.datanucleus.query.evaluator.memory.NumericAggregateExpression;
import org.datanucleus.query.evaluator.memory.ShortAggregateExpression;
import org.datanucleus.query.evaluator.memory.StringAggregateExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.ExpressionEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetExpression {
    String alias = "this";
    Iterator itemIterator;

    public SetExpression(Collection items, String alias) {
        this.itemIterator = items.iterator();
        this.alias = alias;
    }

    public Object count(Expression expr, ExpressionEvaluator eval) {
        int i = 0;
        while (this.itemIterator.hasNext()) {
            this.itemIterator.next();
            ++i;
        }
        return (long)i;
    }

    public Object min(Expression paramExpr, ExpressionEvaluator eval, Map<String, Object> state) {
        int i = 0;
        Object val = null;
        while (this.itemIterator.hasNext()) {
            state.put(this.alias, this.itemIterator.next());
            Object result = paramExpr.evaluate(eval);
            AggregateExpression memexpr = null;
            if (i == 0) {
                val = result;
            }
            if (result instanceof Float) {
                memexpr = new FloatAggregateExpression((Float)result);
            } else if (result instanceof Double) {
                memexpr = new DoubleAggregateExpression((Double)result);
            } else if (result instanceof Long) {
                memexpr = new LongAggregateExpression((Long)result);
            } else if (result instanceof Integer) {
                memexpr = new IntegerAggregateExpression((Integer)result);
            } else if (result instanceof Short) {
                memexpr = new ShortAggregateExpression((Short)result);
            } else if (result instanceof BigInteger) {
                memexpr = new BigIntegerAggregateExpression((BigInteger)result);
            } else if (result instanceof BigDecimal) {
                memexpr = new BigDecimalAggregateExpression((BigDecimal)result);
            } else if (result instanceof Date) {
                memexpr = new DateAggregateExpression((Date)result);
            } else if (result instanceof String) {
                memexpr = new StringAggregateExpression((String)result);
            } else {
                throw new NucleusException("Evaluation of min() on object of type " + result.getClass().getName() + " - not supported");
            }
            if (((AggregateExpression)memexpr).lt(val) == Boolean.TRUE) {
                val = result;
            }
            ++i;
        }
        return val;
    }

    public Object max(Expression paramExpr, ExpressionEvaluator eval, Map<String, Object> state) {
        int i = 0;
        Object val = null;
        while (this.itemIterator.hasNext()) {
            state.put(this.alias, this.itemIterator.next());
            Object result = paramExpr.evaluate(eval);
            AggregateExpression memexpr = null;
            if (i == 0) {
                val = result;
            }
            if (result instanceof Float) {
                memexpr = new FloatAggregateExpression((Float)result);
            } else if (result instanceof Double) {
                memexpr = new DoubleAggregateExpression((Double)result);
            } else if (result instanceof Long) {
                memexpr = new LongAggregateExpression((Long)result);
            } else if (result instanceof Integer) {
                memexpr = new IntegerAggregateExpression((Integer)result);
            } else if (result instanceof Short) {
                memexpr = new ShortAggregateExpression((Short)result);
            } else if (result instanceof BigInteger) {
                memexpr = new BigIntegerAggregateExpression((BigInteger)result);
            } else if (result instanceof BigDecimal) {
                memexpr = new BigDecimalAggregateExpression((BigDecimal)result);
            } else if (result instanceof Date) {
                memexpr = new DateAggregateExpression((Date)result);
            } else if (result instanceof String) {
                memexpr = new StringAggregateExpression((String)result);
            } else {
                throw new NucleusException("Evaluation of max() on object of type " + result.getClass().getName() + " - not supported");
            }
            if (((AggregateExpression)memexpr).gt(val) == Boolean.TRUE) {
                val = result;
            }
            ++i;
        }
        return val;
    }

    public Object sum(Expression paramExpr, ExpressionEvaluator eval, Map<String, Object> state) {
        int i = 0;
        Object val = null;
        while (this.itemIterator.hasNext()) {
            state.put(this.alias, this.itemIterator.next());
            Object result = paramExpr.evaluate(eval);
            AggregateExpression memexpr = null;
            if (result instanceof Float) {
                if (val == null) {
                    val = Float.valueOf(0.0f);
                }
                memexpr = new FloatAggregateExpression((Float)result);
            } else if (result instanceof Double) {
                if (val == null) {
                    val = 0.0;
                }
                memexpr = new DoubleAggregateExpression((Double)result);
            } else if (result instanceof Long) {
                if (val == null) {
                    val = 0L;
                }
                memexpr = new LongAggregateExpression((Long)result);
            } else if (result instanceof Integer) {
                if (val == null) {
                    val = 0;
                }
                memexpr = new IntegerAggregateExpression((Integer)result);
            } else if (result instanceof Short) {
                if (val == null) {
                    val = (short)0;
                }
                memexpr = new ShortAggregateExpression((Short)result);
            } else if (result instanceof BigInteger) {
                if (val == null) {
                    val = new BigInteger("0");
                }
                memexpr = new BigIntegerAggregateExpression((BigInteger)result);
            } else if (result instanceof Date) {
                if (val == null) {
                    val = new Date(0L);
                }
                memexpr = new DateAggregateExpression((Date)result);
            } else if (result instanceof BigDecimal) {
                if (val == null) {
                    val = new BigDecimal("0");
                }
                memexpr = new BigDecimalAggregateExpression((BigDecimal)result);
            } else {
                throw new NucleusException("Evaluation of sum() on object of type " + result.getClass().getName() + " - not supported");
            }
            val = ((AggregateExpression)memexpr).add(val);
            ++i;
        }
        return val;
    }

    public Object avg(Expression paramExpr, ExpressionEvaluator eval, Map<String, Object> state) {
        int i = 0;
        Object val = null;
        NumericAggregateExpression memexpr = null;
        while (this.itemIterator.hasNext()) {
            state.put(this.alias, this.itemIterator.next());
            Object result = paramExpr.evaluate(eval);
            if (result instanceof Float) {
                if (val == null) {
                    val = new Float(0.0f);
                }
                memexpr = new FloatAggregateExpression((Float)result);
            } else if (result instanceof Double) {
                if (val == null) {
                    val = new Double(0.0);
                }
                memexpr = new DoubleAggregateExpression((Double)result);
            } else if (result instanceof Long) {
                if (val == null) {
                    val = 0L;
                }
                memexpr = new LongAggregateExpression((Long)result);
            } else if (result instanceof Integer) {
                if (val == null) {
                    val = 0;
                }
                memexpr = new IntegerAggregateExpression((Integer)result);
            } else if (result instanceof Short) {
                if (val == null) {
                    val = (short)0;
                }
                memexpr = new ShortAggregateExpression((Short)result);
            } else if (result instanceof BigInteger) {
                if (val == null) {
                    val = new BigInteger("0");
                }
                memexpr = new BigIntegerAggregateExpression((BigInteger)result);
            } else if (result instanceof BigDecimal) {
                if (val == null) {
                    val = new BigDecimal("0");
                }
                memexpr = new BigDecimalAggregateExpression((BigDecimal)result);
            } else {
                throw new NucleusException("Evaluation of avg() on object of type " + result.getClass().getName() + " - not supported");
            }
            val = ((AggregateExpression)memexpr).add(val);
            ++i;
        }
        Number divisor = null;
        if (val instanceof Float) {
            memexpr = new FloatAggregateExpression((Float)val);
            divisor = new Float(i);
        } else if (val instanceof Double) {
            memexpr = new DoubleAggregateExpression((Double)val);
            divisor = new Double(i);
        } else if (val instanceof Long) {
            memexpr = new LongAggregateExpression((Long)val);
            divisor = i;
        } else if (val instanceof Integer) {
            memexpr = new IntegerAggregateExpression((Integer)val);
            divisor = i;
        } else if (val instanceof Short) {
            memexpr = new ShortAggregateExpression((Short)val);
            divisor = (short)i;
        } else if (val instanceof BigInteger) {
            memexpr = new BigIntegerAggregateExpression((BigInteger)val);
            divisor = new BigInteger("" + i);
        } else if (val instanceof BigDecimal) {
            memexpr = new BigDecimalAggregateExpression((BigDecimal)val);
            divisor = new BigDecimal("" + i);
        }
        return ((AggregateExpression)memexpr).div(divisor);
    }
}

