/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.expression;

import java.util.List;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.PrimaryExpressionIsInvokeException;
import org.datanucleus.query.expression.PrimaryExpressionIsVariableException;
import org.datanucleus.query.expression.VariableExpression;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolTable;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokeExpression
extends Expression {
    String methodName;
    List<Expression> arguments;

    public InvokeExpression(Expression invoked, String methodName, List args) {
        this.left = invoked;
        this.methodName = methodName;
        this.arguments = args;
    }

    public String getOperation() {
        return this.methodName;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    @Override
    public Symbol bind(SymbolTable symtbl) {
        if (this.left != null) {
            try {
                this.left.bind(symtbl);
            }
            catch (PrimaryExpressionIsVariableException pive) {
                this.left = pive.getVariableExpression();
                this.left.bind(symtbl);
            }
            catch (PrimaryExpressionIsInvokeException piie) {
                this.left = piie.getInvokeExpression();
                this.left.bind(symtbl);
            }
        }
        if (this.arguments != null && this.arguments.size() > 0) {
            for (int i = 0; i < this.arguments.size(); ++i) {
                Expression ve;
                Expression expr = this.arguments.get(i);
                try {
                    expr.bind(symtbl);
                    continue;
                }
                catch (PrimaryExpressionIsVariableException pive) {
                    ve = pive.getVariableExpression();
                    ((VariableExpression)ve).bind(symtbl);
                    this.arguments.remove(i);
                    this.arguments.add(i, ve);
                    continue;
                }
                catch (PrimaryExpressionIsInvokeException piie) {
                    ve = piie.getInvokeExpression();
                    ((InvokeExpression)ve).bind(symtbl);
                    this.arguments.remove(i);
                    this.arguments.add(i, ve);
                }
            }
        }
        return this.symbol;
    }

    public String toString() {
        if (this.left == null) {
            return "InvokeExpression{STATIC." + this.methodName + "(" + StringUtils.collectionToString(this.arguments) + ")}" + (this.alias != null ? " AS " + this.alias : "");
        }
        return "InvokeExpression{[" + this.left + "]." + this.methodName + "(" + StringUtils.collectionToString(this.arguments) + ")}" + (this.alias != null ? " AS " + this.alias : "");
    }
}

