/**********************************************************************
Copyright (c) 2009 Erik Bengtson and others. All rights reserved. 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. 
 

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store;

import java.util.Set;

import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.state.ActivityState;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.LifeCycleState;
import org.datanucleus.state.RelationshipManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;

/**
 * Provides fields.
 * TODO Provide proper javadoc telling people what this is actually for, and documenting each method.
 */
public interface ObjectProvider
{
    // Types of PC objects that can be managed by this StateManager
    /** PC **/
    public static short PC = 0;
    /** Embedded (or serialised) PC **/
    public static short EMBEDDED_PC = 1;
    /** Embedded (or serialised) Collection Element PC **/
    public static short EMBEDDED_COLLECTION_ELEMENT_PC = 2;
    /** Embedded (or serialised) Map Key PC **/
    public static short EMBEDDED_MAP_KEY_PC = 3;
    /** Embedded (or serialised) Map Value PC **/
    public static short EMBEDDED_MAP_VALUE_PC = 4;

    AbstractClassMetaData getClassMetaData();
    /**
     * Method to change the value of the specified field. This will not make the field dirty
     * @param fieldNumber (absolute) field number of the field
     * @param value The new value.
     */
    void replaceField(int fieldNumber, Object value);
    void replaceFields(int fieldNumbers[], FieldManager fm);
    void replaceNonLoadedFields(int fieldNumbers[], FieldManager fm);
    void provideFields(int fieldNumbers[], FieldManager fm);
    Object provideField(int fieldNumber);
    ExecutionContext getExecutionContext();
    String toPrintableID();
    /**
     * TODO should not need this method from the store perspective
     * Method to create a new SCO wrapper for the specified field.
     * If the field is not a SCO field will just return the value.
     * @param fieldNumber The field number
     * @param value The value to initialise the wrapper with (if any)
     * @param forInsert Whether the creation of any wrapper should insert this value into the datastore
     * @param forUpdate Whether the creation of any wrapper should update the datastore with this value
     * @param replaceFieldIfChanged Whether to replace the field in the object if wrapping the value
     * @return The wrapper (or original value if not wrappable)
     */
    Object wrapSCOField(int fieldNumber, Object value, 
            boolean forInsert, boolean forUpdate, boolean replaceFieldIfChanged);

    /**
     * TODO remove this
     */
    Object getObject();
    
    Object getInternalObjectId();
    
    Object getExternalObjectId();
    
    /**
     * Method to set an associated value stored with this object.
     * This is for a situation such as in ORM where this object can have an "external" foreign-key
     * provided by an owning object (e.g 1-N uni relation and this is the element with no knowledge
     * of the owner, so the associated value is the FK value).
     * @param key Key for the value
     * @param value The associated value
     */
    void setAssociatedValue(Object key, Object value);
    
    /**
     * Fetch from the database all fields that are not currently loaded regardless of whether
     * they are in the current fetch group or not. Called by lifecycle transitions.
     */
    void loadUnloadedFields();
    
    /**
     * Accessor for the field numbers of all dirty fields.
     * @return Absolute field numbers of the dirty fields in this instance.
     */
    int[] getDirtyFieldNumbers();
    
    /**
     * Accessor for the names of the fields that are dirty.
     * @return Names of the dirty fields
     */
    String[] getDirtyFieldNames();
    
    /**
     * Marks the given field dirty.
     * @param field The no of field to mark as dirty. 
     */
    void makeDirty(int field);
    
    boolean isInserting();
    
    ObjectProvider[] getEmbeddedOwners();
    
    LifeCycleState getLifecycleState();

    /**
     * Method to register an owner StateManager with this embedded/serialised object.
     * @param ownerSM The owning State Manager.
     * @param ownerFieldNumber The field number in the owner that the embedded/serialised object is stored as
     */
    void addEmbeddedOwner(ObjectProvider ownerSM, int ownerFieldNumber);

    boolean isEmbedded();
    
    /**
     * Convenience method to update our object with the field values from the passed object.
     * Objects need to be of the same type, and the other object should not have a StateManager.
     * @param pc The object that we should copy fields from
     */
    void copyFieldsFromObject(Object pc, int[] fieldNumbers);
    Object getTransactionalVersion();
    
    Object unwrapSCOField(int fieldNumber, Object value, boolean b);
    void replaceFieldMakeDirty(int fieldNumber, Object object);
    boolean[] getLoadedFields();
    void runReachability(Set reachables);

    void setPcObjectType(short objectType);
    short getPcObjectType();

    void setStoringPC();
    void flush();
    boolean isWaitingToBeFlushedToDatastore();
    boolean isDeleting();
    void loadFieldValues(FieldValues2 fieldValues);
    RelationshipManager getRelationshipManager();
    Object getReferencedPC();
    void unsetStoringPC();
    void setObjectField(Object newValuePC, int ownerFieldNumber, Object oldOwner, Object newOwner);
    void loadField(int fieldNumber);
    boolean isLoaded(Object object, int absoluteFieldNumber);
    void setTransactionalVersion(Object nextVersion);
    void replaceFields(int[] fieldNumbers, FieldManager fm, boolean b);
    void setVersion(Object version);
    int[] getLoadedFieldNumbers();
    void updateFieldAfterInsert(Object persistable, int fieldNumber);
    void setPostStoreNewObjectId(Object newId);
    void changeActivityState(ActivityState inserting);
    Object getAssociatedValue(JavaTypeMapping mapping);
    boolean becomingDeleted();
    void loadFieldsInFetchPlan(FetchPlanState state);
    void loadFieldFromDatastore(int fieldNumber);
    Object getObjectId();
    Object getVersion();
    void unloadField(String name);
    void replaceAllLoadedSCOFieldsWithWrappers();
    void replaceAllLoadedSCOFieldsWithValues();
    boolean getAllFieldsLoaded();
    void replaceManagedPC(Object pc2);
    String[] getLoadedFieldNames();
}
