/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import java.lang.reflect.Array;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ArrayMetaData;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.scostore.AbstractArrayStore;
import org.datanucleus.store.mapped.scostore.FKArrayStoreSpecialization;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public abstract class FKArrayStore
extends AbstractArrayStore {
    public FKArrayStore(AbstractMemberMetaData fmd, MappedStoreManager storeMgr, ClassLoaderResolver clr, FKArrayStoreSpecialization specialization) {
        super((StoreManager)storeMgr, clr, specialization);
        this.setOwner(fmd, clr);
        ArrayMetaData arrmd = fmd.getArray();
        if (arrmd == null) {
            throw new NucleusUserException(LOCALISER.msg("056000", (Object)fmd.getFullFieldName()));
        }
        this.elementType = fmd.getType().getComponentType().getName();
        Class element_class = clr.classForName(this.elementType);
        if (ClassUtils.isReferenceType(element_class)) {
            this.emd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForImplementationOfReference(element_class, null, clr);
            if (this.emd != null) {
                this.elementType = this.emd.getFullClassName();
            }
        } else {
            this.emd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
        }
        if (this.emd == null) {
            throw new NucleusUserException(LOCALISER.msg("056003", (Object)element_class.getName(), (Object)fmd.getFullFieldName()));
        }
        this.elementInfo = this.getElementInformationForClass();
        if (this.elementInfo != null && this.elementInfo.length > 1) {
            throw new NucleusUserException(LOCALISER.msg("056045", (Object)this.ownerMemberMetaData.getFullFieldName()));
        }
        this.elementMapping = this.elementInfo[0].getDatastoreClass().getIdMapping();
        this.elementsAreEmbedded = false;
        this.elementsAreSerialised = false;
        String mappedByFieldName = fmd.getMappedBy();
        if (mappedByFieldName != null) {
            AbstractMemberMetaData eofmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForMember(element_class, clr, mappedByFieldName);
            if (eofmd == null) {
                throw new NucleusUserException(LOCALISER.msg("056024", (Object)fmd.getFullFieldName(), (Object)mappedByFieldName, (Object)element_class.getName()));
            }
            if (!clr.isAssignableFrom(eofmd.getType(), fmd.getAbstractClassMetaData().getFullClassName())) {
                throw new NucleusUserException(LOCALISER.msg("056025", (Object)fmd.getFullFieldName(), (Object)eofmd.getFullFieldName(), (Object)eofmd.getTypeName(), (Object)fmd.getAbstractClassMetaData().getFullClassName()));
            }
            String ownerFieldName = eofmd.getName();
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getMemberMapping(eofmd);
            if (this.ownerMapping == null) {
                throw new NucleusUserException(LOCALISER.msg("056046", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.elementType, (Object)ownerFieldName));
            }
            if (this.isEmbeddedMapping(this.ownerMapping)) {
                throw new NucleusUserException(LOCALISER.msg("056026", (Object)ownerFieldName, (Object)this.elementType, (Object)eofmd.getTypeName(), (Object)fmd.getClassName()));
            }
        } else {
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 5);
            if (this.ownerMapping == null) {
                throw new NucleusUserException(LOCALISER.msg("056047", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.elementType));
            }
        }
        this.orderMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 4);
        if (this.orderMapping == null) {
            throw new NucleusUserException(LOCALISER.msg("056048", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.elementType));
        }
        this.relationDiscriminatorMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 6);
        if (this.relationDiscriminatorMapping != null) {
            this.relationDiscriminatorValue = fmd.getValueForExtension("relation-discriminator-value");
            if (this.relationDiscriminatorValue == null) {
                this.relationDiscriminatorValue = fmd.getFullFieldName();
            }
        }
        this.containerTable = this.elementInfo[0].getDatastoreClass();
        if (fmd.getMappedBy() != null && this.ownerMapping.getDatastoreContainer() != this.containerTable) {
            this.containerTable = this.ownerMapping.getDatastoreContainer();
        }
    }

    private FKArrayStoreSpecialization getSpecialization() {
        return (FKArrayStoreSpecialization)this.specialization;
    }

    private boolean updateElementFk(ObjectProvider ownerSM, Object element, Object owner, int index) {
        if (element == null) {
            return false;
        }
        return this.getSpecialization().getUpdateElementFk(ownerSM, element, owner, index, this);
    }

    public void clear(ObjectProvider ownerSM) {
        boolean deleteElements = false;
        if (this.ownerMemberMetaData.getArray().isDependentElement()) {
            NucleusLogger.DATASTORE.debug(LOCALISER.msg("056034"));
            deleteElements = true;
        } else if (this.ownerMapping.isNullable() && this.orderMapping.isNullable()) {
            NucleusLogger.DATASTORE.debug(LOCALISER.msg("056036"));
            deleteElements = false;
        } else {
            NucleusLogger.DATASTORE.debug(LOCALISER.msg("056035"));
            deleteElements = true;
        }
        if (deleteElements) {
            ownerSM.getExecutionContext().getApiAdapter().isLoaded(ownerSM, this.ownerMemberMetaData.getAbsoluteFieldNumber());
            Object[] value = (Object[])ownerSM.provideField(this.ownerMemberMetaData.getAbsoluteFieldNumber());
            if (value != null && value.length > 0) {
                ownerSM.getExecutionContext().deleteObjects(value);
            }
        } else {
            this.getSpecialization().clear(ownerSM, this);
        }
    }

    public boolean set(ObjectProvider ownerSM, Object array) {
        if (array == null) {
            return true;
        }
        for (int i = 0; i < Array.getLength(array); ++i) {
            this.validateElementForWriting(ownerSM, Array.get(array, i), null);
        }
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object obj = Array.get(array, i);
            this.updateElementFk(ownerSM, obj, ownerSM.getObject(), i);
        }
        return true;
    }
}

