/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types;

import java.awt.Point;
import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.ObjectStringConverter;

public class PointStringConverter
implements ObjectStringConverter {
    public Object toObject(String str) {
        if (str == null) {
            return null;
        }
        Point p = new Point();
        StringTokenizer tokeniser = new StringTokenizer(str.substring(1, str.length() - 1), ",");
        double x = 0.0;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                x = new Double(token);
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Point.class.getName()), nfe);
            }
        } else {
            return null;
        }
        double y = 0.0;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                y = new Double(token);
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Point.class.getName()), nfe);
            }
        } else {
            return null;
        }
        p.setLocation(x, y);
        return p;
    }

    public String toString(Object obj) {
        String str;
        if (obj instanceof Point) {
            Point p = (Point)obj;
            str = "(" + p.getX() + "," + p.getY() + ")";
        } else {
            str = (String)obj;
        }
        return str;
    }
}

