/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query;

import java.util.Iterator;
import java.util.List;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.expression.VariableExpression;

public class JDOQLQueryHelper {
    static final String[] SINGLE_STRING_KEYWORDS = new String[]{"SELECT", "UNIQUE", "INTO", "FROM", "EXCLUDE", "SUBCLASSES", "WHERE", "VARIABLES", "PARAMETERS", "GROUP", "ORDER", "BY", "RANGE"};
    static final String[] SINGLE_STRING_KEYWORDS_LOWERCASE = new String[]{"select", "unique", "into", "from", "exclude", "subclasses", "where", "variables", "parameters", "group", "order", "by", "range"};

    public static boolean isKeyword(String name) {
        for (int i = 0; i < SINGLE_STRING_KEYWORDS.length; ++i) {
            if (!name.equals(SINGLE_STRING_KEYWORDS[i]) && !name.equals(SINGLE_STRING_KEYWORDS_LOWERCASE[i])) continue;
            return true;
        }
        return name.equals("IMPORT") || name.equals("import");
    }

    public static boolean isKeywordExtended(String name) {
        for (int i = 0; i < SINGLE_STRING_KEYWORDS.length; ++i) {
            if (!name.equals(SINGLE_STRING_KEYWORDS[i]) && !name.equals(SINGLE_STRING_KEYWORDS_LOWERCASE[i])) continue;
            return true;
        }
        if (name.equals("DELETE") || name.equals("delete")) {
            return true;
        }
        if (name.equals("UPDATE") || name.equals("update")) {
            return true;
        }
        if (name.equals("SET") || name.equals("set")) {
            return true;
        }
        return name.equals("IMPORT") || name.equals("import");
    }

    public static boolean isValidJavaIdentifierForJDOQL(String s) {
        int len = s.length();
        if (len < 1) {
            return false;
        }
        if (s.equals("this")) {
            return false;
        }
        char[] c = new char[len];
        s.getChars(0, len, c, 0);
        if (!Character.isJavaIdentifierStart(c[0])) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            if (Character.isJavaIdentifierPart(c[i])) continue;
            return false;
        }
        return true;
    }

    public static String getJDOQLForExpression(Expression expr) {
        if (expr instanceof DyadicExpression) {
            DyadicExpression dyExpr = (DyadicExpression)expr;
            Expression left = dyExpr.getLeft();
            Expression right = dyExpr.getRight();
            StringBuffer str = new StringBuffer("(");
            if (left != null) {
                str.append(JDOQLQueryHelper.getJDOQLForExpression(left));
            }
            if (dyExpr.getOperator() == Expression.OP_AND) {
                str.append(" && ");
            } else if (dyExpr.getOperator() == Expression.OP_OR) {
                str.append(" || ");
            } else if (dyExpr.getOperator() == Expression.OP_ADD) {
                str.append(" + ");
            } else if (dyExpr.getOperator() == Expression.OP_SUB) {
                str.append(" - ");
            } else if (dyExpr.getOperator() == Expression.OP_MUL) {
                str.append(" * ");
            } else if (dyExpr.getOperator() == Expression.OP_DIV) {
                str.append(" / ");
            } else if (dyExpr.getOperator() == Expression.OP_EQ) {
                str.append(" == ");
            } else if (dyExpr.getOperator() == Expression.OP_GT) {
                str.append(" > ");
            } else if (dyExpr.getOperator() == Expression.OP_LT) {
                str.append(" < ");
            } else if (dyExpr.getOperator() == Expression.OP_GTEQ) {
                str.append(" >= ");
            } else if (dyExpr.getOperator() == Expression.OP_LTEQ) {
                str.append(" <= ");
            } else if (dyExpr.getOperator() == Expression.OP_NOTEQ) {
                str.append(" != ");
            } else {
                throw new UnsupportedOperationException("Dont currently support operator " + dyExpr.getOperator() + " in JDOQL conversion");
            }
            if (right != null) {
                str.append(JDOQLQueryHelper.getJDOQLForExpression(right));
            }
            str.append(")");
            return str.toString();
        }
        if (expr instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)expr;
            if (primExpr.getLeft() != null) {
                return JDOQLQueryHelper.getJDOQLForExpression(primExpr.getLeft()) + "." + primExpr.getId();
            }
            return primExpr.getId();
        }
        if (expr instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)expr;
            if (paramExpr.getId() != null) {
                return ":" + paramExpr.getId();
            }
            return "?" + paramExpr.getPosition();
        }
        if (expr instanceof VariableExpression) {
            VariableExpression varExpr = (VariableExpression)expr;
            return varExpr.getId();
        }
        if (expr instanceof InvokeExpression) {
            InvokeExpression invExpr = (InvokeExpression)expr;
            StringBuffer str = new StringBuffer();
            if (invExpr.getLeft() != null) {
                str.append(JDOQLQueryHelper.getJDOQLForExpression(invExpr.getLeft())).append(".");
            }
            str.append(invExpr.getOperation());
            str.append("(");
            List<Expression> args = invExpr.getArguments();
            if (args != null) {
                Iterator<Expression> iter = args.iterator();
                while (iter.hasNext()) {
                    str.append(JDOQLQueryHelper.getJDOQLForExpression(iter.next()));
                    if (!iter.hasNext()) continue;
                    str.append(",");
                }
            }
            str.append(")");
            return str.toString();
        }
        if (expr instanceof Literal) {
            Literal litExpr = (Literal)expr;
            Object value = litExpr.getLiteral();
            if (value instanceof String || value instanceof Character) {
                return "'" + value.toString() + "'";
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? "TRUE" : "FALSE";
            }
            if (litExpr.getLiteral() == null) {
                return "null";
            }
            return litExpr.getLiteral().toString();
        }
        if (expr instanceof VariableExpression) {
            VariableExpression varExpr = (VariableExpression)expr;
            return varExpr.getId();
        }
        throw new UnsupportedOperationException("Dont currently support " + expr.getClass().getName() + " in JDOQLHelper");
    }
}

