/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.types.sco.SCO;
import org.datanucleus.store.types.sco.SCOContainer;
import org.datanucleus.util.NucleusLogger;

public class L2CachePopulateFieldManager
extends AbstractFieldManager {
    ObjectProvider op;
    ExecutionContext ec;
    CachedPC cachedPC;

    public L2CachePopulateFieldManager(ObjectProvider op, CachedPC cachedpc) {
        this.op = op;
        this.ec = op.getExecutionContext();
        this.cachedPC = cachedpc;
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.getLoadedFields()[fieldNumber] = false;
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.getLoadedFields()[fieldNumber] = false;
            return;
        }
        this.cachedPC.getLoadedFields()[fieldNumber] = true;
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    public void storeCharField(int fieldNumber, char value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.getLoadedFields()[fieldNumber] = false;
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.getLoadedFields()[fieldNumber] = false;
            return;
        }
        this.cachedPC.getLoadedFields()[fieldNumber] = true;
        this.cachedPC.setFieldValue(fieldNumber, Character.valueOf(value));
    }

    public void storeByteField(int fieldNumber, byte value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.getLoadedFields()[fieldNumber] = false;
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.getLoadedFields()[fieldNumber] = false;
            return;
        }
        this.cachedPC.getLoadedFields()[fieldNumber] = true;
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    public void storeShortField(int fieldNumber, short value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.getLoadedFields()[fieldNumber] = false;
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.getLoadedFields()[fieldNumber] = false;
            return;
        }
        this.cachedPC.getLoadedFields()[fieldNumber] = true;
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    public void storeIntField(int fieldNumber, int value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.getLoadedFields()[fieldNumber] = false;
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.getLoadedFields()[fieldNumber] = false;
            return;
        }
        this.cachedPC.getLoadedFields()[fieldNumber] = true;
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    public void storeLongField(int fieldNumber, long value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.getLoadedFields()[fieldNumber] = false;
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.getLoadedFields()[fieldNumber] = false;
            return;
        }
        this.cachedPC.getLoadedFields()[fieldNumber] = true;
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    public void storeFloatField(int fieldNumber, float value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.getLoadedFields()[fieldNumber] = false;
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.getLoadedFields()[fieldNumber] = false;
            return;
        }
        this.cachedPC.getLoadedFields()[fieldNumber] = true;
        this.cachedPC.setFieldValue(fieldNumber, Float.valueOf(value));
    }

    public void storeDoubleField(int fieldNumber, double value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.getLoadedFields()[fieldNumber] = false;
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.getLoadedFields()[fieldNumber] = false;
            return;
        }
        this.cachedPC.getLoadedFields()[fieldNumber] = true;
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    public void storeStringField(int fieldNumber, String value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.getLoadedFields()[fieldNumber] = false;
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.getLoadedFields()[fieldNumber] = false;
            return;
        }
        this.cachedPC.getLoadedFields()[fieldNumber] = true;
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.getLoadedFields()[fieldNumber] = false;
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.getLoadedFields()[fieldNumber] = false;
            return;
        }
        ApiAdapter api = this.ec.getApiAdapter();
        this.cachedPC.getLoadedFields()[fieldNumber] = true;
        if (value == null) {
            this.cachedPC.setFieldValue(fieldNumber, value);
            return;
        }
        if (api.isPersistable(value)) {
            if (!mmd.isSerialized() && !mmd.isEmbedded()) {
                this.cachedPC.setFieldValue(fieldNumber, api.getIdForObject(value));
                return;
            }
            this.cachedPC.getLoadedFields()[fieldNumber] = false;
            return;
        }
        if (value instanceof Collection) {
            if (MetaDataUtils.getInstance().storesPersistable(mmd, this.ec)) {
                if (value instanceof List && mmd.getOrderMetaData() != null && !mmd.getOrderMetaData().isIndexedList()) {
                    this.cachedPC.getLoadedFields()[fieldNumber] = false;
                    return;
                }
                if (mmd.isSerialized() || mmd.isEmbedded() || mmd.getCollection().isSerializedElement() || mmd.getCollection().isEmbeddedElement()) {
                    this.cachedPC.getLoadedFields()[fieldNumber] = false;
                    return;
                }
                Collection collection = (Collection)value;
                if (collection instanceof SCO && !((SCOContainer)value).isLoaded()) {
                    this.cachedPC.getLoadedFields()[fieldNumber] = false;
                    return;
                }
                Iterator collIter = collection.iterator();
                Object var7_16 = null;
                try {
                    if (value.getClass().isInterface()) {
                        if (List.class.isAssignableFrom(value.getClass()) || mmd.getOrderMetaData() != null) {
                            ArrayList arrayList = new ArrayList();
                        } else {
                            HashSet hashSet = new HashSet();
                        }
                    } else if (value instanceof SCO) {
                        Collection collection2 = (Collection)((SCO)value).getValue().getClass().newInstance();
                    } else {
                        Collection collection3 = (Collection)value.getClass().newInstance();
                    }
                    while (true) {
                        void var7_21;
                        if (!collIter.hasNext()) {
                            this.cachedPC.setFieldValue(fieldNumber, var7_21);
                            return;
                        }
                        Object elem = collIter.next();
                        if (elem == null) {
                            var7_21.add(null);
                            continue;
                        }
                        var7_21.add(api.getIdForObject(elem));
                    }
                }
                catch (Exception e) {
                    NucleusLogger.CACHE.warn("Unable to create object of type " + value.getClass().getName() + " for L2 caching : " + e.getMessage());
                    this.cachedPC.getLoadedFields()[fieldNumber] = false;
                    return;
                }
            }
            if (!(value instanceof SCOContainer)) {
                this.cachedPC.setFieldValue(fieldNumber, value);
                return;
            }
            if (((SCOContainer)value).isLoaded()) {
                this.cachedPC.setFieldValue(fieldNumber, ((SCO)value).getValue());
                return;
            }
            this.cachedPC.getLoadedFields()[fieldNumber] = false;
            return;
        }
        if (value instanceof Map) {
            if (MetaDataUtils.getInstance().storesPersistable(mmd, this.ec)) {
                if (mmd.isSerialized() || mmd.isEmbedded() || mmd.getMap().isSerializedKey() || mmd.getMap().keyIsPersistent() && mmd.getMap().isEmbeddedKey() || mmd.getMap().isSerializedValue() || mmd.getMap().valueIsPersistent() && mmd.getMap().isEmbeddedValue()) {
                    this.cachedPC.getLoadedFields()[fieldNumber] = false;
                    return;
                }
                if (value instanceof SCO && !((SCOContainer)value).isLoaded()) {
                    this.cachedPC.getLoadedFields()[fieldNumber] = false;
                    return;
                }
                try {
                    Object var5_6 = null;
                    if (value.getClass().isInterface()) {
                        HashMap hashMap = new HashMap();
                    } else if (value instanceof SCO) {
                        Map map = (Map)((SCO)value).getValue().getClass().newInstance();
                    } else {
                        Map map = (Map)value.getClass().newInstance();
                    }
                    Iterator mapIter = ((Map)value).entrySet().iterator();
                    while (true) {
                        void var5_10;
                        if (!mapIter.hasNext()) {
                            this.cachedPC.setFieldValue(fieldNumber, var5_10);
                            return;
                        }
                        Map.Entry entry = mapIter.next();
                        Object mapKey = null;
                        Object mapValue = null;
                        mapKey = mmd.getMap().keyIsPersistent() ? api.getIdForObject(entry.getKey()) : (Object)entry.getKey();
                        mapValue = mmd.getMap().valueIsPersistent() ? api.getIdForObject(entry.getValue()) : (Object)entry.getValue();
                        var5_10.put(mapKey, mapValue);
                    }
                }
                catch (Exception exception) {
                    NucleusLogger.CACHE.warn("Unable to create object of type " + value.getClass().getName() + " for L2 caching : " + exception.getMessage());
                    this.cachedPC.getLoadedFields()[fieldNumber] = false;
                    return;
                }
            }
            if (!(value instanceof SCOContainer)) {
                this.cachedPC.setFieldValue(fieldNumber, value);
                return;
            }
            if (((SCOContainer)value).isLoaded()) {
                this.cachedPC.setFieldValue(fieldNumber, ((SCO)value).getValue());
                return;
            }
            this.cachedPC.getLoadedFields()[fieldNumber] = false;
            return;
        }
        if (value instanceof Object[]) {
            if (!MetaDataUtils.getInstance().storesPersistable(mmd, this.ec)) {
                this.cachedPC.setFieldValue(fieldNumber, value);
                return;
            }
            if (mmd.isSerialized() || mmd.isEmbedded() || mmd.getArray().isSerializedElement() || mmd.getArray().isEmbeddedElement()) {
                this.cachedPC.getLoadedFields()[fieldNumber] = false;
                return;
            }
            Object[] objectArray = new Object[Array.getLength(value)];
            int i = 0;
            while (true) {
                if (i >= Array.getLength(value)) {
                    this.cachedPC.setFieldValue(fieldNumber, objectArray);
                    return;
                }
                Object object = Array.get(value, i);
                objectArray[i] = api.getIdForObject(object);
                ++i;
            }
        }
        if (value instanceof StringBuffer) {
            this.cachedPC.setFieldValue(fieldNumber, new StringBuffer((StringBuffer)value));
            return;
        }
        if (!(value instanceof SCO)) {
            this.cachedPC.setFieldValue(fieldNumber, value);
            return;
        }
        if (NucleusLogger.CACHE.isDebugEnabled()) {
            NucleusLogger.CACHE.debug("CachePopulateFM.fetchObjectField this=" + this.op.toPrintableID() + " field=" + fieldNumber + " is having its SCO wrapper replaced prior to L2 caching.");
        }
        this.cachedPC.setFieldValue(fieldNumber, ((SCO)value).getValue());
    }
}

