/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.plugin;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.plugin.Bundle;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.Extension;
import org.datanucleus.plugin.ExtensionPoint;
import org.datanucleus.plugin.PluginParser;
import org.datanucleus.plugin.PluginRegistry;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonManagedPluginRegistry
implements PluginRegistry {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    private static final String DATANUCLEUS_PKG = "org.datanucleus";
    private static final String PLUGIN_DIR = "/";
    private static final FilenameFilter MANIFEST_FILE_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            if (name.equalsIgnoreCase("meta-inf")) {
                return true;
            }
            if (!dir.getName().equalsIgnoreCase("meta-inf")) {
                return false;
            }
            return name.equalsIgnoreCase("manifest.mf");
        }
    };
    private static final char JAR_SEPARATOR = '!';
    private final ClassLoaderResolver clr;
    Map<String, ExtensionPoint> extensionPointsByUniqueId = new HashMap<String, ExtensionPoint>();
    Map<String, Bundle> registeredPluginByPluginId = new HashMap<String, Bundle>();
    ExtensionPoint[] extensionPoints;
    private String bundleCheckType = "EXCEPTION";
    private boolean allowUserBundles = false;

    public NonManagedPluginRegistry(ClassLoaderResolver clr, String bundleCheckType, boolean allowUserBundles) {
        this.clr = clr;
        this.extensionPoints = new ExtensionPoint[0];
        this.bundleCheckType = bundleCheckType != null ? bundleCheckType : "EXCEPTION";
        this.allowUserBundles = allowUserBundles;
    }

    @Override
    public ExtensionPoint getExtensionPoint(String id) {
        return this.extensionPointsByUniqueId.get(id);
    }

    @Override
    public ExtensionPoint[] getExtensionPoints() {
        return this.extensionPoints;
    }

    @Override
    public void registerExtensionPoints() {
        this.registerExtensions();
    }

    public void registerExtensionsForPlugin(URL pluginURL, Bundle bundle) {
        DocumentBuilder docBuilder = PluginParser.getDocumentBuilder();
        List[] elements = PluginParser.parsePluginElements(docBuilder, this, pluginURL, bundle, this.clr);
        this.registerExtensionPointsForPluginInternal(elements[0], true);
        for (Extension extension : elements[1]) {
            ExtensionPoint exPoint = this.extensionPointsByUniqueId.get(extension.getExtensionPointId());
            if (exPoint == null) {
                NucleusLogger.PLUGIN.warn(LOCALISER.msg("024002", (Object)extension.getExtensionPointId(), (Object)extension.getPlugin().getSymbolicName(), (Object)extension.getPlugin().getManifestLocation().toString()));
                continue;
            }
            extension.setExtensionPoint(exPoint);
            exPoint.addExtension(extension);
        }
    }

    @Override
    public void registerExtensions() {
        if (this.extensionPoints.length > 0) {
            return;
        }
        ArrayList registeringExtensions = new ArrayList();
        DocumentBuilder docBuilder = PluginParser.getDocumentBuilder();
        for (URL pluginURL : this.getPluginURLs()) {
            Bundle bundle;
            URL manifest = this.getManifestURL(pluginURL);
            if (manifest == null || (bundle = this.registerBundle(manifest)) == null) continue;
            List[] elements = PluginParser.parsePluginElements(docBuilder, this, pluginURL, bundle, this.clr);
            this.registerExtensionPointsForPluginInternal(elements[0], false);
            registeringExtensions.addAll(elements[1]);
        }
        this.extensionPoints = this.extensionPointsByUniqueId.values().toArray(new ExtensionPoint[this.extensionPointsByUniqueId.values().size()]);
        for (int i = 0; i < registeringExtensions.size(); ++i) {
            Extension extension = (Extension)registeringExtensions.get(i);
            ExtensionPoint exPoint = this.getExtensionPoint(extension.getExtensionPointId());
            if (exPoint == null) {
                if (extension.getPlugin() == null || extension.getPlugin().getSymbolicName() == null || !extension.getPlugin().getSymbolicName().startsWith(DATANUCLEUS_PKG)) continue;
                NucleusLogger.PLUGIN.warn(LOCALISER.msg("024002", (Object)extension.getExtensionPointId(), (Object)extension.getPlugin().getSymbolicName(), (Object)extension.getPlugin().getManifestLocation().toString()));
                continue;
            }
            extension.setExtensionPoint(exPoint);
            exPoint.addExtension(extension);
        }
        if (this.allowUserBundles) {
            ExtensionSorter sorter = new ExtensionSorter();
            for (int i = 0; i < this.extensionPoints.length; ++i) {
                ExtensionPoint pt = this.extensionPoints[i];
                pt.sortExtensions(sorter);
            }
        }
    }

    protected void registerExtensionPointsForPluginInternal(List extPoints, boolean updateExtensionPointsArray) {
        for (ExtensionPoint exPoint : extPoints) {
            this.extensionPointsByUniqueId.put(exPoint.getUniqueId(), exPoint);
        }
        if (updateExtensionPointsArray) {
            this.extensionPoints = this.extensionPointsByUniqueId.values().toArray(new ExtensionPoint[this.extensionPointsByUniqueId.values().size()]);
        }
    }

    private Set<URL> getPluginURLs() {
        HashSet<URL> set = new HashSet<URL>();
        try {
            Enumeration<URL> paths = this.clr.getResources("/plugin.xml", NucleusContext.class.getClassLoader());
            while (paths.hasMoreElements()) {
                set.add(paths.nextElement());
            }
        }
        catch (IOException e) {
            throw new NucleusException("Error loading resource", e).setFatal();
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Bundle registerBundle(URL manifest) {
        block44: {
            block43: {
                block42: {
                    block41: {
                        block40: {
                            block39: {
                                block38: {
                                    block37: {
                                        block36: {
                                            block35: {
                                                if (manifest == null) {
                                                    throw new IllegalArgumentException(NonManagedPluginRegistry.LOCALISER.msg("024007"));
                                                }
                                                is = null;
                                                try {
                                                    try {
                                                        block46: {
                                                            block45: {
                                                                mf = null;
                                                                if (manifest.getProtocol().equals("jar") || manifest.getProtocol().equals("zip") || manifest.getProtocol().equals("wsjar")) {
                                                                    if (manifest.getPath().startsWith("http://") || manifest.getPath().startsWith("https://")) {
                                                                        jarConnection = (JarURLConnection)manifest.openConnection();
                                                                        url = jarConnection.getJarFileURL();
                                                                        mf = jarConnection.getManifest();
                                                                        if (mf == null) {
                                                                            var6_14 = null;
                                                                            var18_20 = null;
                                                                            if (is == null) return var6_14;
                                                                            break block35;
                                                                        }
                                                                        var6_15 = this.registerBundle(mf, url);
                                                                        break block36;
                                                                    }
                                                                    begin = 4;
                                                                    if (manifest.getProtocol().equals("wsjar")) {
                                                                        begin = 6;
                                                                    }
                                                                    if ((jarPath = (path = StringUtils.getDecodedStringFromURLString(manifest.toExternalForm())).substring(begin, index = path.indexOf(33))).startsWith("file:")) {
                                                                        jarPath = jarPath.substring(5);
                                                                    }
                                                                    if ((mf = new JarFile(jarFile = new File(jarPath)).getManifest()) == null) {
                                                                        var9_48 = null;
                                                                        break block37;
                                                                    }
                                                                    var9_49 = this.registerBundle(mf, jarFile.toURI().toURL());
                                                                    break block38;
                                                                }
                                                                if (!manifest.getProtocol().equals("rar") && !manifest.getProtocol().equals("war")) break block45;
                                                                path = StringUtils.getDecodedStringFromURLString(manifest.toExternalForm());
                                                                index = path.indexOf(33);
                                                                rarPath = path.substring(4, index);
                                                                file = new File(rarPath);
                                                                rarUrl = file.toURI().toURL();
                                                                jarPath = path.substring(index + 1, path.indexOf(33, index + 1));
                                                                rarFile = new JarFile(file);
                                                                jis = new JarInputStream(rarFile.getInputStream(rarFile.getEntry(jarPath)));
                                                                try {
                                                                    mf = jis.getManifest();
                                                                    if (mf == null) {
                                                                        var12_56 = null;
                                                                        var14_58 = null;
                                                                    }
                                                                    ** GOTO lbl-1000
                                                                }
                                                                catch (Throwable var13_61) {
                                                                    var14_60 = null;
                                                                    jis.close();
                                                                    throw var13_61;
                                                                }
                                                                jis.close();
                                                                break block39;
lbl-1000:
                                                                // 1 sources

                                                                {
                                                                    var14_59 = null;
                                                                    jis.close();
                                                                }
                                                                var12_57 = this.registerBundle(mf, rarUrl);
                                                                break block40;
                                                            }
                                                            if (!manifest.getProtocol().equals("vfsfile") && !manifest.getProtocol().equals("vfsjar") && !manifest.getProtocol().equals("vfszip") && !manifest.getProtocol().equals("vfs")) break block46;
                                                            path = StringUtils.getDecodedStringFromURLString(manifest.toExternalForm());
                                                            index = path.indexOf(33);
                                                            if (index < 0) {
                                                                NucleusLogger.PLUGIN.warn("Unable to find jar bundle for " + path + " so ignoring");
                                                                rarPath = null;
                                                                break block41;
                                                            }
                                                            jarPath = path.substring(0, index);
                                                            jarUrl = new URL(jarPath);
                                                            jis = null;
                                                            inputStream = jarUrl.openConnection().getInputStream();
                                                            jis = inputStream instanceof JarInputStream != false ? (JarInputStream)inputStream : new JarInputStream(inputStream);
                                                            try {
                                                                mf = jis.getManifest();
                                                                if (mf == null) {
                                                                    var10_53 = null;
                                                                    var16_62 = null;
                                                                }
                                                                ** GOTO lbl-1000
                                                            }
                                                            catch (Throwable var15_65) {
                                                                var16_64 = null;
                                                                jis.close();
                                                                throw var15_65;
                                                            }
                                                            jis.close();
                                                            break block42;
lbl-1000:
                                                            // 1 sources

                                                            {
                                                                var16_63 = null;
                                                                jis.close();
                                                            }
                                                            var10_54 = this.registerBundle(mf, jarUrl);
                                                            break block43;
                                                        }
                                                        is = manifest.openStream();
                                                        mf = new Manifest(is);
                                                        var4_9 = this.registerBundle(mf, manifest);
                                                        break block44;
                                                    }
                                                    catch (IOException e) {
                                                        throw new NucleusException(NonManagedPluginRegistry.LOCALISER.msg("024008", manifest), e).setFatal();
                                                    }
                                                }
                                                catch (Throwable var17_66) {
                                                    var18_30 = null;
                                                    if (is == null) throw var17_66;
                                                    try {
                                                        is.close();
                                                        throw var17_66;
                                                    }
                                                    catch (IOException e) {
                                                        throw var17_66;
                                                    }
                                                }
                                            }
                                            ** try [egrp 6[TRYBLOCK] [27 : 743->750)] { 
lbl117:
                                            // 1 sources

                                            is.close();
                                            return var6_14;
lbl119:
                                            // 1 sources

                                            catch (IOException e) {
                                                // empty catch block
                                            }
                                            return var6_14;
                                        }
                                        var18_21 = null;
                                        if (is == null) return var6_15;
                                        ** try [egrp 6[TRYBLOCK] [27 : 743->750)] { 
lbl126:
                                        // 1 sources

                                        is.close();
                                        return var6_15;
lbl128:
                                        // 1 sources

                                        catch (IOException e) {
                                            // empty catch block
                                        }
                                        return var6_15;
                                    }
                                    var18_22 = null;
                                    if (is == null) return var9_48;
                                    ** try [egrp 6[TRYBLOCK] [27 : 743->750)] { 
lbl135:
                                    // 1 sources

                                    is.close();
                                    return var9_48;
lbl137:
                                    // 1 sources

                                    catch (IOException e) {
                                        // empty catch block
                                    }
                                    return var9_48;
                                }
                                var18_23 = null;
                                if (is == null) return var9_49;
                                ** try [egrp 6[TRYBLOCK] [27 : 743->750)] { 
lbl144:
                                // 1 sources

                                is.close();
                                return var9_49;
lbl146:
                                // 1 sources

                                catch (IOException e) {
                                    // empty catch block
                                }
                                return var9_49;
                            }
                            var18_24 = null;
                            if (is == null) return var12_56;
                            try {}
                            catch (IOException e) {
                                // empty catch block
                                return var12_56;
                            }
                            is.close();
                            return var12_56;
                        }
                        var18_25 = null;
                        if (is == null) return var12_57;
                        ** try [egrp 6[TRYBLOCK] [27 : 743->750)] { 
lbl162:
                        // 1 sources

                        is.close();
                        return var12_57;
lbl164:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        return var12_57;
                    }
                    var18_26 = null;
                    if (is == null) return rarPath;
                    ** try [egrp 6[TRYBLOCK] [27 : 743->750)] { 
lbl171:
                    // 1 sources

                    is.close();
                    return rarPath;
lbl173:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                    return rarPath;
                }
                var18_27 = null;
                if (is == null) return var10_53;
                try {}
                catch (IOException e) {
                    // empty catch block
                    return var10_53;
                }
                is.close();
                return var10_53;
            }
            var18_28 = null;
            if (is == null) return var10_54;
            ** try [egrp 6[TRYBLOCK] [27 : 743->750)] { 
lbl189:
            // 1 sources

            is.close();
            return var10_54;
lbl191:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var10_54;
        }
        var18_29 = null;
        if (is == null) return var4_9;
        try {}
        catch (IOException e) {
            // empty catch block
            return var4_9;
        }
        is.close();
        return var4_9;
    }

    protected Bundle registerBundle(Manifest mf, URL manifest) {
        Bundle bundle = PluginParser.parseManifest(mf, manifest);
        if (bundle == null || bundle.getSymbolicName() == null) {
            return null;
        }
        if (!this.allowUserBundles && !bundle.getSymbolicName().startsWith(DATANUCLEUS_PKG)) {
            NucleusLogger.PLUGIN.debug("Ignoring bundle " + bundle.getSymbolicName() + " since not DataNucleus, and only loading DataNucleus bundles");
            return null;
        }
        if (this.registeredPluginByPluginId.get(bundle.getSymbolicName()) == null) {
            if (NucleusLogger.PLUGIN.isDebugEnabled()) {
                NucleusLogger.PLUGIN.debug("Registering bundle " + bundle.getSymbolicName() + " version " + bundle.getVersion() + " at URL " + bundle.getManifestLocation() + ".");
            }
            this.registeredPluginByPluginId.put(bundle.getSymbolicName(), bundle);
        } else {
            Bundle previousBundle = this.registeredPluginByPluginId.get(bundle.getSymbolicName());
            if (bundle.getSymbolicName().startsWith(DATANUCLEUS_PKG) && !bundle.getManifestLocation().toExternalForm().equals(previousBundle.getManifestLocation().toExternalForm())) {
                String msg = LOCALISER.msg("024009", (Object)bundle.getSymbolicName(), (Object)bundle.getManifestLocation(), (Object)previousBundle.getManifestLocation());
                if (this.bundleCheckType.equalsIgnoreCase("EXCEPTION")) {
                    throw new NucleusException(msg);
                }
                if (this.bundleCheckType.equalsIgnoreCase("LOG")) {
                    NucleusLogger.PLUGIN.warn(msg);
                }
            }
        }
        return bundle;
    }

    private URL getManifestURL(URL pluginURL) {
        if (pluginURL == null) {
            return null;
        }
        if (pluginURL.toString().startsWith("jar") || pluginURL.toString().startsWith("zip") || pluginURL.toString().startsWith("rar") || pluginURL.toString().startsWith("war") || pluginURL.toString().startsWith("wsjar")) {
            return pluginURL;
        }
        if (pluginURL.toString().startsWith("vfs")) {
            String urlStr = pluginURL.toString().replaceAll("\\.jar/", ".jar!/");
            try {
                return new URL(urlStr);
            }
            catch (MalformedURLException e) {
                NucleusLogger.PLUGIN.warn(LOCALISER.msg("024010", (Object)urlStr), e);
                return null;
            }
        }
        if (pluginURL.toString().startsWith("jndi")) {
            String urlStr = pluginURL.toString().substring(5);
            urlStr = urlStr.replaceAll("\\.jar/", ".jar!/");
            urlStr = "jar:file:" + urlStr;
            try {
                return new URL(urlStr);
            }
            catch (MalformedURLException e) {
                NucleusLogger.PLUGIN.warn(LOCALISER.msg("024010", (Object)urlStr), e);
                return null;
            }
        }
        if (pluginURL.toString().startsWith("code-source")) {
            String urlStr = pluginURL.toString().substring(12);
            urlStr = "jar:file:" + urlStr;
            try {
                return new URL(urlStr);
            }
            catch (MalformedURLException e) {
                NucleusLogger.PLUGIN.warn(LOCALISER.msg("024010", (Object)urlStr), e);
                return null;
            }
        }
        try {
            File[] files;
            File file = new File(new URI(pluginURL.toString()).getPath());
            File[] dirs = new File(file.getParent()).listFiles(MANIFEST_FILE_FILTER);
            if (dirs != null && dirs.length > 0 && (files = dirs[0].listFiles(MANIFEST_FILE_FILTER)) != null && files.length > 0) {
                try {
                    return files[0].toURI().toURL();
                }
                catch (MalformedURLException e) {
                    NucleusLogger.PLUGIN.warn(LOCALISER.msg("024011", pluginURL), e);
                    return null;
                }
            }
        }
        catch (URISyntaxException use) {
            use.printStackTrace();
            NucleusLogger.PLUGIN.warn(LOCALISER.msg("024011", pluginURL), use);
            return null;
        }
        NucleusLogger.PLUGIN.warn(LOCALISER.msg("024012", pluginURL));
        return null;
    }

    @Override
    public Object createExecutableExtension(ConfigurationElement confElm, String name, Class[] argsClass, Object[] args) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class cls = this.clr.classForName(confElm.getAttribute(name), ClassConstants.NUCLEUS_CONTEXT_LOADER);
        Constructor constructor = cls.getConstructor(argsClass);
        return constructor.newInstance(args);
    }

    @Override
    public Class loadClass(String pluginId, String className) throws ClassNotFoundException {
        return this.clr.classForName(className, ClassConstants.NUCLEUS_CONTEXT_LOADER);
    }

    @Override
    public URL resolveURLAsFileURL(URL url) throws IOException {
        return url;
    }

    @Override
    public void resolveConstraints() {
        for (Bundle bundle : this.registeredPluginByPluginId.values()) {
            List set = bundle.getRequireBundle();
            for (Bundle.BundleDescription bd : set) {
                String symbolicName = bd.getBundleSymbolicName();
                Bundle requiredBundle = this.registeredPluginByPluginId.get(symbolicName);
                if (requiredBundle == null) {
                    if (bd.getParameter("resolution") != null && bd.getParameter("resolution").equalsIgnoreCase("optional")) {
                        NucleusLogger.PLUGIN.debug(LOCALISER.msg("024013", (Object)bundle.getSymbolicName(), (Object)symbolicName));
                    } else {
                        NucleusLogger.PLUGIN.error(LOCALISER.msg("024014", (Object)bundle.getSymbolicName(), (Object)symbolicName));
                    }
                }
                if (bd.getParameter("bundle-version") == null || requiredBundle == null || this.isVersionInInterval(requiredBundle.getVersion(), bd.getParameter("bundle-version"))) continue;
                NucleusLogger.PLUGIN.error(LOCALISER.msg("024015", (Object)bundle.getSymbolicName(), (Object)symbolicName, (Object)bd.getParameter("bundle-version"), (Object)bundle.getVersion()));
            }
        }
    }

    private boolean isVersionInInterval(String version, String interval) {
        Bundle.BundleVersionRange versionRange = PluginParser.parseVersionRange(version);
        Bundle.BundleVersionRange intervalRange = PluginParser.parseVersionRange(interval);
        int compare_floor = versionRange.floor.compareTo(intervalRange.floor);
        boolean result = true;
        if (intervalRange.floor_inclusive) {
            result = compare_floor >= 0;
        } else {
            boolean bl = result = compare_floor > 0;
        }
        if (intervalRange.ceiling != null) {
            int compare_ceiling = versionRange.floor.compareTo(intervalRange.ceiling);
            result = intervalRange.ceiling_inclusive ? compare_ceiling <= 0 : compare_ceiling < 0;
        }
        return result;
    }

    @Override
    public Bundle[] getBundles() {
        return this.registeredPluginByPluginId.values().toArray(new Bundle[this.registeredPluginByPluginId.values().size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ExtensionSorter
    implements Comparator<Extension>,
    Serializable {
        protected ExtensionSorter() {
        }

        @Override
        public int compare(Extension o1, Extension o2) {
            String name1 = o1.getPlugin().getSymbolicName();
            String name2 = o2.getPlugin().getSymbolicName();
            if (name1.startsWith(NonManagedPluginRegistry.DATANUCLEUS_PKG) && !name2.startsWith(NonManagedPluginRegistry.DATANUCLEUS_PKG)) {
                return -1;
            }
            if (!name1.startsWith(NonManagedPluginRegistry.DATANUCLEUS_PKG) && name2.startsWith(NonManagedPluginRegistry.DATANUCLEUS_PKG)) {
                return 1;
            }
            return name1.compareTo(name2);
        }
    }
}

