/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.schema.naming;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.schema.naming.AbstractNamingFactory;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.schema.naming.SchemaComponent;

public class JPANamingFactory
extends AbstractNamingFactory {
    public JPANamingFactory(ClassLoaderResolver clr) {
        super(clr);
    }

    public String getTableName(AbstractMemberMetaData mmd) {
        String name = null;
        AbstractMemberMetaData[] relatedMmds = null;
        if (mmd.hasContainer()) {
            if (mmd.getTable() != null) {
                name = mmd.getTable();
            } else {
                relatedMmds = mmd.getRelatedMemberMetaData(this.clr);
                if (relatedMmds != null && relatedMmds[0].getTable() != null) {
                    name = relatedMmds[0].getTable();
                }
            }
        }
        if (name == null) {
            String ownerClass = mmd.getClassName(false);
            String otherClass = mmd.getTypeName();
            if (mmd.hasCollection()) {
                otherClass = mmd.getCollection().getElementType();
            } else if (mmd.hasArray()) {
                otherClass = mmd.getArray().getElementType();
            } else if (mmd.hasMap()) {
                otherClass = mmd.getMap().getValueType();
            }
            if (mmd.hasCollection() && relatedMmds != null && relatedMmds[0].hasCollection() && mmd.getMappedBy() != null) {
                ownerClass = relatedMmds[0].getClassName(false);
                otherClass = relatedMmds[0].getCollection().getElementType();
            }
            otherClass = otherClass.substring(otherClass.lastIndexOf(46) + 1);
            name = ownerClass + this.wordSeparator + otherClass;
        }
        int maxLength = this.getMaximumLengthForComponent(SchemaComponent.TABLE);
        if (name != null && maxLength > 0 && name.length() > maxLength) {
            name = JPANamingFactory.truncate(name, maxLength);
        }
        name = this.getNameInRequiredCase(name);
        return name;
    }

    public String getColumnName(AbstractClassMetaData cmd, ColumnType type) {
        String name = null;
        if (type == ColumnType.DISCRIMINATOR_COLUMN) {
            ColumnMetaData colmd;
            DiscriminatorMetaData discmd = cmd.getDiscriminatorMetaData();
            if (discmd != null && (colmd = discmd.getColumnMetaData()) != null && colmd.getName() != null) {
                name = colmd.getName();
            }
            if (name == null) {
                name = "DTYPE";
            }
        } else if (type == ColumnType.VERSION_COLUMN) {
            ColumnMetaData colmd;
            VersionMetaData vermd = cmd.getVersionMetaData();
            if (vermd != null && (colmd = vermd.getColumnMetaData()) != null && colmd.getName() != null) {
                name = colmd.getName();
            }
            if (name == null) {
                name = "VERSION";
            }
        } else if (type == ColumnType.DATASTOREID_COLUMN) {
            ColumnMetaData idcolmd;
            if (cmd.getIdentityMetaData() != null && (idcolmd = cmd.getIdentityMetaData().getColumnMetaData()) != null) {
                name = idcolmd.getName();
            }
            if (name == null) {
                name = cmd.getName() + this.wordSeparator + "ID";
            }
        } else {
            throw new NucleusException("This method does not support columns of type " + (Object)((Object)type));
        }
        int maxLength = this.getMaximumLengthForComponent(SchemaComponent.COLUMN);
        if (name != null && maxLength > 0 && name.length() > maxLength) {
            name = JPANamingFactory.truncate(name, maxLength);
        }
        name = this.getNameInRequiredCase(name);
        return name;
    }

    public String[] getColumnNames(AbstractMemberMetaData mmd, ColumnType type) {
        ColumnMetaData[] colmds;
        String name = null;
        if (type == ColumnType.COLUMN) {
            colmds = mmd.getColumnMetaData();
            if (colmds != null && colmds.length > 0) {
                name = colmds[0].getName();
            }
            if (name == null) {
                name = mmd.getName();
            }
        } else if (type == ColumnType.INDEX_COLUMN) {
            if (mmd.getOrderMetaData() != null && (colmds = mmd.getOrderMetaData().getColumnMetaData()) != null && colmds.length > 0) {
                name = colmds[0].getName();
            }
            if (name == null) {
                name = mmd.getName() + this.wordSeparator + "ORDER";
            }
        } else if (type == ColumnType.ADAPTER_COLUMN) {
            name = "IDX";
        } else {
            throw new NucleusException("This method does not support columns of type " + (Object)((Object)type));
        }
        int maxLength = this.getMaximumLengthForComponent(SchemaComponent.COLUMN);
        if (name != null && maxLength > 0 && name.length() > maxLength) {
            name = JPANamingFactory.truncate(name, maxLength);
        }
        name = this.getNameInRequiredCase(name);
        return new String[]{name};
    }
}

