/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types;

import java.awt.Point;
import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.ObjectStringConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointStringConverter
implements ObjectStringConverter<Point> {
    @Override
    public Point toObject(String str) {
        if (str == null) {
            return null;
        }
        Point p = new Point();
        StringTokenizer tokeniser = new StringTokenizer(str.substring(1, str.length() - 1), ",");
        double x = 0.0;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                x = new Double(token);
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Point.class.getName()), nfe);
            }
        } else {
            return null;
        }
        double y = 0.0;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                y = new Double(token);
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Point.class.getName()), nfe);
            }
        } else {
            return null;
        }
        p.setLocation(x, y);
        return p;
    }

    @Override
    public String toString(Point p) {
        return p != null ? "(" + p.getX() + "," + p.getY() + ")" : null;
    }
}

