/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types;

import java.awt.Rectangle;
import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.ObjectStringConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RectangleStringConverter
implements ObjectStringConverter<Rectangle> {
    @Override
    public Rectangle toObject(String str) {
        if (str == null) {
            return null;
        }
        Rectangle r = new Rectangle();
        StringTokenizer tokeniser = new StringTokenizer(str.substring(1, str.length() - 1), ",");
        double x = 0.0;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                x = new Double(token);
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Rectangle.class.getName()), nfe);
            }
        } else {
            return null;
        }
        double y = 0.0;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                y = new Double(token);
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Rectangle.class.getName()), nfe);
            }
        } else {
            return null;
        }
        double width = 0.0;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                width = new Double(token);
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Rectangle.class.getName()), nfe);
            }
        } else {
            return null;
        }
        double height = 0.0;
        if (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                height = new Double(token);
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Rectangle.class.getName()), nfe);
            }
        } else {
            return null;
        }
        r.setRect(x, y, width, height);
        return r;
    }

    @Override
    public String toString(Rectangle rect) {
        return rect != null ? "(" + rect.getX() + "," + rect.getY() + "," + rect.getWidth() + "," + rect.getHeight() + ")" : null;
    }
}

