/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlanForClass;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.Relation;
import org.datanucleus.state.DetachState;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFetchDepthFieldManager;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;
import org.datanucleus.store.types.sco.SCO;
import org.datanucleus.store.types.sco.SCOUtils;

public class DetachFieldManager
extends AbstractFetchDepthFieldManager {
    boolean copy = true;

    public DetachFieldManager(ObjectProvider sm, boolean[] secondClassMutableFields, FetchPlanForClass fpClass, FetchPlanState state, boolean copy) {
        super(sm, secondClassMutableFields, fpClass, state);
        this.copy = copy;
    }

    protected Object processPersistable(Object pc) {
        if (pc == null) {
            return null;
        }
        ApiAdapter api = this.sm.getExecutionContext().getApiAdapter();
        if (!api.isPersistable(pc)) {
            return pc;
        }
        if (!api.isDetached(pc) && api.isPersistent(pc)) {
            if (this.copy) {
                return this.sm.getExecutionContext().detachObjectCopy(pc, this.state);
            }
            this.sm.getExecutionContext().detachObject(pc, this.state);
        }
        return pc;
    }

    protected Object internalFetchObjectField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        Object value = sfv.fetchObjectField(fieldNumber);
        if (value == null) {
            return null;
        }
        ClassLoaderResolver clr = this.sm.getExecutionContext().getClassLoaderResolver();
        ApiAdapter api = this.sm.getExecutionContext().getApiAdapter();
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        int relationType = mmd.getRelationType(clr);
        if (Relation.isRelationSingleValued(relationType)) {
            if (api.isPersistable(value)) {
                return this.processPersistable(value);
            }
        } else if (Relation.isRelationMultiValued(relationType)) {
            if (mmd.hasCollection() || mmd.hasMap()) {
                SCO sco;
                if (this.copy) {
                    if (!(value instanceof SCO)) {
                        value = this.sm.wrapSCOField(fieldNumber, value, false, false, true);
                    }
                    if (!(value instanceof SCO) && mmd.isSerialized()) {
                        if (mmd.hasCollection()) {
                            if (mmd.getCollection().elementIsPersistent()) {
                                throw new NucleusUserException("Unable to detach " + mmd.getFullFieldName() + " since is of an unsupported Collection type with persistent elements");
                            }
                            return value;
                        }
                        if (mmd.hasMap()) {
                            if (mmd.getMap().keyIsPersistent() || mmd.getMap().valueIsPersistent()) {
                                throw new NucleusUserException("Unable to detach " + mmd.getFullFieldName() + " since is of an unsupported Map type with persistent keys/values");
                            }
                            return value;
                        }
                    }
                    return ((SCO)value).detachCopy(this.state);
                }
                if (!(value instanceof SCO)) {
                    value = this.sm.wrapSCOField(fieldNumber, value, false, false, true);
                }
                if ((sco = (SCO)value) instanceof Collection) {
                    SCOUtils.detachForCollection(this.sm, ((Collection)((Object)sco)).toArray(), this.state);
                    sco.unsetOwner();
                } else if (sco instanceof Map) {
                    SCOUtils.detachForMap(this.sm, ((Map)((Object)sco)).entrySet(), this.state);
                    sco.unsetOwner();
                }
                if (SCOUtils.detachAsWrapped(this.sm)) {
                    return sco;
                }
                return this.sm.unwrapSCOField(fieldNumber, value, true);
            }
            if (mmd.hasArray()) {
                if (!api.isPersistable(mmd.getType().getComponentType())) {
                    return value;
                }
                Object[] arrValue = (Object[])value;
                Object[] arrDetached = (Object[])Array.newInstance(mmd.getType().getComponentType(), arrValue.length);
                for (int j = 0; j < arrValue.length; ++j) {
                    arrDetached[j] = this.processPersistable(arrValue[j]);
                }
                return arrDetached;
            }
        } else if (this.secondClassMutableFields[fieldNumber]) {
            if (this.copy) {
                if (!(value instanceof SCO)) {
                    value = this.sm.wrapSCOField(fieldNumber, value, false, false, true);
                }
                return ((SCO)value).detachCopy(this.state);
            }
            if (!(value instanceof SCO)) {
                value = this.sm.wrapSCOField(fieldNumber, value, false, false, true);
            }
            SCO sco = (SCO)value;
            if (SCOUtils.detachAsWrapped(this.sm)) {
                return sco;
            }
            return this.sm.unwrapSCOField(fieldNumber, value, true);
        }
        return value;
    }

    protected Object endOfGraphOperation(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        Object value = sfv.fetchObjectField(fieldNumber);
        ApiAdapter api = this.sm.getExecutionContext().getApiAdapter();
        if (api.isPersistable(value)) {
            if (this.copy) {
                DetachState.Entry entry = ((DetachState)this.state).getDetachedCopyEntry(value);
                if (entry != null) {
                    return entry.getDetachedCopyObject();
                }
            } else if (this.sm.getExecutionContext().getApiAdapter().isDetached(value)) {
                return value;
            }
        }
        throw new AbstractFetchDepthFieldManager.EndOfFetchPlanGraphException();
    }
}

