/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.sco.backed;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.state.ObjectProviderFactory;
import org.datanucleus.state.RelationshipManager;
import org.datanucleus.store.BackedSCOStoreManager;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.scostore.CollectionStore;
import org.datanucleus.store.types.sco.SCOCollectionIterator;
import org.datanucleus.store.types.sco.SCOUtils;
import org.datanucleus.store.types.sco.backed.List;
import org.datanucleus.store.types.sco.queued.AddOperation;
import org.datanucleus.store.types.sco.queued.ClearCollectionOperation;
import org.datanucleus.store.types.sco.queued.OperationQueue;
import org.datanucleus.store.types.sco.queued.QueuedOperation;
import org.datanucleus.store.types.sco.queued.RemoveCollectionOperation;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collection
extends org.datanucleus.store.types.sco.simple.Collection {
    protected transient CollectionStore backingStore;
    protected transient boolean allowNulls = false;
    protected transient boolean useCache = true;
    protected transient boolean isCacheLoaded = false;
    protected transient boolean queued = false;
    protected transient OperationQueue<CollectionStore> operationQueue = null;

    public Collection(ObjectProvider ownerSM, String fieldName) {
        super(ownerSM, fieldName);
        ExecutionContext ec = ownerSM.getExecutionContext();
        AbstractMemberMetaData fmd = ownerSM.getClassMetaData().getMetaDataForMember(fieldName);
        this.fieldNumber = fmd.getAbsoluteFieldNumber();
        this.allowNulls = SCOUtils.allowNullsInContainer(this.allowNulls, fmd);
        this.queued = ec.isDelayDatastoreOperationsEnabled();
        this.useCache = SCOUtils.useContainerCache(ownerSM, fieldName);
        if (!SCOUtils.collectionHasSerialisedElements(fmd) && fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
            ClassLoaderResolver clr = ec.getClassLoaderResolver();
            this.backingStore = (CollectionStore)((BackedSCOStoreManager)((Object)ec.getStoreManager())).getBackingStoreForField(clr, fmd, java.util.Collection.class);
        }
        this.delegate = this.backingStore != null && this.backingStore.hasOrderMapping() ? new ArrayList() : new HashSet();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(SCOUtils.getContainerInfoMessage(ownerSM, fieldName, this, this.useCache, this.queued, this.allowNulls, SCOUtils.useCachedLazyLoading(ownerSM, fieldName)));
        }
    }

    @Override
    public void initialise(Object o, boolean forInsert, boolean forUpdate) {
        java.util.Collection c = (java.util.Collection)o;
        if (o instanceof java.util.List && !(this.delegate instanceof java.util.List)) {
            this.delegate = new ArrayList();
        }
        if (c != null) {
            RelationshipManager relMgr;
            Iterator iter;
            AbstractMemberMetaData fmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName);
            if (SCOUtils.collectionHasSerialisedElements(fmd) && fmd.getCollection().elementIsPersistent()) {
                ExecutionContext ec = this.ownerSM.getExecutionContext();
                for (Object pc : c) {
                    ObjectProvider objSM = ec.findObjectProvider(pc);
                    if (objSM != null) continue;
                    objSM = ObjectProviderFactory.newForEmbedded(ec, pc, false, this.ownerSM, this.fieldNumber);
                }
            }
            if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
                this.isCacheLoaded = true;
            }
            if (forInsert) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023007", (Object)this.ownerSM.toPrintableID(), (Object)this.fieldName, (Object)("" + c.size())));
                }
                if (this.useCache) {
                    this.loadFromStore();
                }
                if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations()) {
                    iter = c.iterator();
                    relMgr = this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM);
                    while (iter.hasNext()) {
                        relMgr.relationAdd(this.fieldNumber, iter.next());
                    }
                }
                if (this.backingStore != null) {
                    if (SCOUtils.useQueuedUpdate(this.queued, this.ownerSM)) {
                        for (Object element : c) {
                            this.addQueuedOperation(new AddOperation(element));
                        }
                    } else {
                        try {
                            this.backingStore.addAll(this.ownerSM, c, this.useCache ? this.delegate.size() : -1);
                        }
                        catch (NucleusDataStoreException dse) {
                            NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"addAll", (Object)this.fieldName, (Object)dse));
                        }
                    }
                }
                this.makeDirty();
                this.delegate.addAll(c);
            } else if (forUpdate) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023008", (Object)this.ownerSM.toPrintableID(), (Object)this.fieldName, (Object)("" + c.size())));
                }
                if (this.delegate instanceof Set) {
                    if (this.useCache) {
                        this.isCacheLoaded = false;
                        this.loadFromStore();
                        for (Object elem : c) {
                            if (this.delegate.contains(elem)) continue;
                            this.add(elem);
                        }
                        HashSet delegateCopy = new HashSet(this.delegate);
                        for (Object elem : delegateCopy) {
                            if (c.contains(elem)) continue;
                            this.remove(elem);
                        }
                    } else {
                        for (Object elem : c) {
                            if (this.contains(elem)) continue;
                            this.add(elem);
                        }
                        for (Object elem : this) {
                            if (c.contains(elem)) continue;
                            this.remove(elem);
                        }
                    }
                } else {
                    if (this.backingStore != null) {
                        if (SCOUtils.useQueuedUpdate(this.queued, this.ownerSM)) {
                            this.addQueuedOperation(new ClearCollectionOperation());
                        } else {
                            this.backingStore.clear(this.ownerSM);
                        }
                    }
                    if (this.useCache) {
                        this.loadFromStore();
                    }
                    if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations()) {
                        iter = c.iterator();
                        relMgr = this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM);
                        while (iter.hasNext()) {
                            relMgr.relationAdd(this.fieldNumber, iter.next());
                        }
                    }
                    if (this.backingStore != null) {
                        if (SCOUtils.useQueuedUpdate(this.queued, this.ownerSM)) {
                            for (Object element : c) {
                                this.addQueuedOperation(new AddOperation(element));
                            }
                        } else {
                            try {
                                this.backingStore.addAll(this.ownerSM, c, this.useCache ? this.delegate.size() : -1);
                            }
                            catch (NucleusDataStoreException dse) {
                                NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"addAll", (Object)this.fieldName, (Object)dse));
                            }
                        }
                    }
                    this.delegate.addAll(c);
                    this.makeDirty();
                }
            } else {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023007", (Object)this.ownerSM.toPrintableID(), (Object)this.fieldName, (Object)("" + c.size())));
                }
                this.delegate.clear();
                this.delegate.addAll(c);
            }
        }
    }

    @Override
    public void initialise() {
        if (this.useCache && !SCOUtils.useCachedLazyLoading(this.ownerSM, this.fieldName)) {
            this.loadFromStore();
        }
    }

    @Override
    public Object getValue() {
        this.loadFromStore();
        return super.getValue();
    }

    @Override
    public void load() {
        if (this.useCache) {
            this.loadFromStore();
        }
    }

    @Override
    public boolean isLoaded() {
        return this.useCache ? this.isCacheLoaded : false;
    }

    protected void loadFromStore() {
        if (this.backingStore != null && !this.isCacheLoaded) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023006", (Object)this.ownerSM.toPrintableID(), (Object)this.fieldName));
            }
            this.delegate.clear();
            Iterator iter = this.backingStore.iterator(this.ownerSM);
            while (iter.hasNext()) {
                this.delegate.add(iter.next());
            }
            this.isCacheLoaded = true;
        }
    }

    @Override
    public void flush() {
        if (this.queued && this.operationQueue != null) {
            this.operationQueue.performAll(this.backingStore, this.ownerSM, this.fieldName);
        }
    }

    protected void addQueuedOperation(QueuedOperation<? super CollectionStore> op) {
        if (this.operationQueue == null) {
            this.operationQueue = new OperationQueue();
        }
        this.operationQueue.enqueue(op);
    }

    @Override
    public void updateEmbeddedElement(Object element, int fieldNumber, Object value) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedElement(this.ownerSM, element, fieldNumber, value);
        }
    }

    @Override
    public synchronized void unsetOwner() {
        super.unsetOwner();
        if (this.backingStore != null) {
            this.backingStore = null;
        }
    }

    @Override
    public Object clone() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return ((HashSet)this.delegate).clone();
    }

    @Override
    public synchronized boolean contains(Object element) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.contains(element);
        }
        if (this.backingStore != null) {
            return this.backingStore.contains(this.ownerSM, element);
        }
        return this.delegate.contains(element);
    }

    @Override
    public synchronized boolean containsAll(java.util.Collection c) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            HashSet h = new HashSet(c);
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                h.remove(iter.next());
            }
            return h.isEmpty();
        }
        return this.delegate.containsAll(c);
    }

    @Override
    public synchronized boolean equals(Object o) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof java.util.Collection)) {
            return false;
        }
        java.util.Collection c = (java.util.Collection)o;
        return c.size() == this.size() && this.containsAll(c);
    }

    @Override
    public synchronized int hashCode() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return ((Object)this.delegate).hashCode();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public synchronized Iterator iterator() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return new SCOCollectionIterator(this, this.ownerSM, this.delegate, this.backingStore, this.useCache);
    }

    @Override
    public synchronized int size() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.size();
        }
        if (this.backingStore != null) {
            return this.backingStore.size(this.ownerSM);
        }
        return this.delegate.size();
    }

    @Override
    public synchronized Object[] toArray() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerSM);
        }
        return this.delegate.toArray();
    }

    @Override
    public synchronized Object[] toArray(Object[] a) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerSM, a);
        }
        return this.delegate.toArray(a);
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer("[");
        int i = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (i > 0) {
                s.append(',');
            }
            s.append(iter.next());
            ++i;
        }
        s.append("]");
        return s.toString();
    }

    @Override
    public synchronized boolean add(Object element) {
        if (!this.allowNulls && element == null) {
            throw new NullPointerException("Nulls not allowed for collection at field " + this.fieldName + " but element is null");
        }
        if (this.useCache) {
            this.loadFromStore();
        }
        if (!List.class.isAssignableFrom(this.delegate.getClass()) && this.contains(element)) {
            return false;
        }
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations()) {
            this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM).relationAdd(this.fieldNumber, element);
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerSM)) {
                this.addQueuedOperation(new AddOperation(element));
            } else {
                try {
                    backingSuccess = this.backingStore.add(this.ownerSM, element, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"add", (Object)this.fieldName, (Object)dse));
                    backingSuccess = false;
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.add(element);
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    @Override
    public synchronized boolean addAll(java.util.Collection c) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations()) {
            Iterator iter = c.iterator();
            RelationshipManager relMgr = this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM);
            while (iter.hasNext()) {
                relMgr.relationAdd(this.fieldNumber, iter.next());
            }
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerSM)) {
                for (Object element : c) {
                    this.addQueuedOperation(new AddOperation(element));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.addAll(this.ownerSM, c, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"addAll", (Object)this.fieldName, (Object)dse));
                    backingSuccess = false;
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.addAll(c);
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    @Override
    public synchronized void clear() {
        this.makeDirty();
        this.delegate.clear();
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerSM)) {
                this.addQueuedOperation(new ClearCollectionOperation());
            } else {
                this.backingStore.clear(this.ownerSM);
            }
        }
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public synchronized boolean remove(Object element) {
        return this.remove(element, true);
    }

    @Override
    public boolean remove(Object element, boolean allowCascadeDelete) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        int size = this.useCache ? this.delegate.size() : -1;
        boolean contained = this.delegate.contains(element);
        boolean delegateSuccess = this.delegate.remove(element);
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations()) {
            this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM).relationRemove(this.fieldNumber, element);
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerSM)) {
                backingSuccess = contained;
                if (backingSuccess) {
                    this.addQueuedOperation(new RemoveCollectionOperation(element, allowCascadeDelete));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.remove(this.ownerSM, element, size, allowCascadeDelete);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"remove", (Object)this.fieldName, (Object)dse));
                    backingSuccess = false;
                }
            }
        }
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    @Override
    public synchronized boolean removeAll(java.util.Collection elements) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        int size = this.useCache ? this.delegate.size() : -1;
        HashSet contained = null;
        if (this.backingStore != null && SCOUtils.useQueuedUpdate(this.queued, this.ownerSM)) {
            contained = new HashSet();
            for (Object elem : elements) {
                if (!this.contains(elem)) continue;
                contained.add(elem);
            }
        }
        boolean delegateSuccess = this.delegate.removeAll(elements);
        if (this.ownerSM != null && this.ownerSM.getExecutionContext().getManageRelations()) {
            Iterator iter = elements.iterator();
            RelationshipManager relMgr = this.ownerSM.getExecutionContext().getRelationshipManager(this.ownerSM);
            while (iter.hasNext()) {
                relMgr.relationRemove(this.fieldNumber, iter.next());
            }
        }
        if (this.backingStore != null) {
            boolean backingSuccess = true;
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerSM)) {
                backingSuccess = false;
                for (Object element : contained) {
                    backingSuccess = true;
                    this.addQueuedOperation(new RemoveCollectionOperation(element, true));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.removeAll(this.ownerSM, elements, size);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"removeAll", (Object)this.fieldName, (Object)dse));
                    backingSuccess = false;
                }
            }
            if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
                this.ownerSM.getExecutionContext().processNontransactionalUpdate();
            }
            return backingSuccess;
        }
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return delegateSuccess;
    }

    @Override
    public synchronized boolean retainAll(java.util.Collection c) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean modified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (c.contains(element)) continue;
            iter.remove();
            modified = true;
        }
        if (this.ownerSM != null && !this.ownerSM.getExecutionContext().getTransaction().isActive()) {
            this.ownerSM.getExecutionContext().processNontransactionalUpdate();
        }
        return modified;
    }

    @Override
    protected Object writeReplace() throws ObjectStreamException {
        if (this.useCache) {
            this.loadFromStore();
            return new HashSet(this.delegate);
        }
        return new HashSet(this.delegate);
    }
}

