/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.sql.Time;
import java.util.Calendar;
import javax.time.calendar.LocalTime;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.store.mapped.mapping.TemporalMapping;
import org.datanucleus.store.types.converters.TypeConverter;

public class LocalTimeMapping
extends TemporalMapping {
    public Class getJavaType() {
        return LocalTime.class;
    }

    public String getJavaTypeForDatastoreMapping(int index) {
        if (this.datastoreMappings == null || this.datastoreMappings.length == 0) {
            ColumnMetaData[] colmds = LocalTimeMapping.getColumnMetaDataForMember(this.mmd, this.roleForMember);
            boolean useString = false;
            if (colmds != null && colmds.length > 0 && colmds[0].getJdbcType() != null && MetaDataUtils.isJdbcTypeString(colmds[0].getJdbcType())) {
                useString = true;
            }
            return useString ? ClassNameConstants.JAVA_LANG_STRING : ClassNameConstants.JAVA_SQL_TIME;
        }
        if (this.datastoreMappings[0].isStringBased()) {
            return ClassNameConstants.JAVA_LANG_STRING;
        }
        return ClassNameConstants.JAVA_SQL_TIME;
    }

    protected int getDefaultLengthAsString() {
        return 12;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setObject(ExecutionContext ec, Object preparedStatement, int[] exprIndex, Object value) {
        if (value == null) {
            this.getDatastoreMapping(0).setObject(preparedStatement, exprIndex[0], null);
            return;
        } else if (this.datastoreMappings != null && this.datastoreMappings.length > 0 && this.datastoreMappings[0].isStringBased()) {
            TypeConverter conv = ec.getNucleusContext().getTypeManager().getTypeConverterForType(LocalTime.class, String.class);
            if (conv == null) throw new NucleusUserException("This type doesn't support persistence as a String");
            Object obj = conv.toDatastoreType(value);
            this.getDatastoreMapping(0).setObject(preparedStatement, exprIndex[0], obj);
            return;
        } else {
            LocalTime val = (LocalTime)value;
            Calendar cal = Calendar.getInstance();
            cal.set(0, 0, 0, val.getHourOfDay(), val.getMinuteOfHour(), val.getSecondOfMinute());
            this.getDatastoreMapping(0).setObject(preparedStatement, exprIndex[0], cal);
        }
    }

    public Object getObject(ExecutionContext ec, Object resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return null;
        }
        Object datastoreValue = this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]);
        if (datastoreValue == null) {
            return null;
        }
        if (datastoreValue instanceof String) {
            TypeConverter conv = ec.getNucleusContext().getTypeManager().getTypeConverterForType(LocalTime.class, String.class);
            if (conv != null) {
                return conv.toMemberType(datastoreValue);
            }
            throw new NucleusUserException("This type doesn't support persistence as a String");
        }
        if (datastoreValue instanceof Time) {
            Time time = (Time)datastoreValue;
            Calendar cal = Calendar.getInstance();
            cal.setTime(time);
            LocalTime localTime = LocalTime.of((int)cal.get(11), (int)cal.get(12), (int)cal.get(13), (int)(cal.get(14) * 1000000));
            return localTime;
        }
        return null;
    }
}

