/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.KeyMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.ValueMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.mapped.ColumnCreator;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.exceptions.NoTableManagedException;
import org.datanucleus.store.mapped.mapping.InterfaceMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.mapped.mapping.MappingManager;
import org.datanucleus.store.mapped.mapping.MultiPersistableMapping;
import org.datanucleus.store.mapped.mapping.PersistableMapping;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public abstract class ReferenceMapping
extends MultiPersistableMapping
implements MappingCallbacks {
    protected static final Localiser LOCALISER_MAPPED = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    public static final int PER_IMPLEMENTATION_MAPPING = 0;
    public static final int ID_MAPPING = 1;
    public static final int XCALIA_MAPPING = 2;
    protected int mappingStrategy = 0;

    public void initialize(AbstractMemberMetaData mmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        if (mmd.hasExtension("mapping-strategy")) {
            String strategy = mmd.getValueForExtension("mapping-strategy");
            if (strategy.equalsIgnoreCase("identity")) {
                this.mappingStrategy = 1;
            } else if (strategy.equalsIgnoreCase("xcalia")) {
                this.mappingStrategy = 2;
            }
        }
        this.numberOfDatastoreMappings = 0;
        super.initialize(mmd, container, clr);
        this.prepareDatastoreMapping(clr);
    }

    public int getMappingStrategy() {
        return this.mappingStrategy;
    }

    protected void prepareDatastoreMapping(ClassLoaderResolver clr) {
        if (this.mappingStrategy == 0) {
            if (this.roleForMember == 4) {
                ColumnMetaData[] colmds = null;
                ElementMetaData elemmd = this.mmd.getElementMetaData();
                if (elemmd != null && elemmd.getColumnMetaData() != null && elemmd.getColumnMetaData().length > 0) {
                    colmds = elemmd.getColumnMetaData();
                }
                this.createPerImplementationColumnsForReferenceField(false, false, false, false, this.roleForMember, colmds, clr);
            } else if (this.roleForMember == 3) {
                ColumnMetaData[] colmds = null;
                AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(clr);
                ElementMetaData elemmd = this.mmd.getElementMetaData();
                if (elemmd != null && elemmd.getColumnMetaData() != null && elemmd.getColumnMetaData().length > 0) {
                    colmds = elemmd.getColumnMetaData();
                } else if (relatedMmds != null && relatedMmds[0].getJoinMetaData() != null && relatedMmds[0].getJoinMetaData().getColumnMetaData() != null && relatedMmds[0].getJoinMetaData().getColumnMetaData().length > 0) {
                    colmds = relatedMmds[0].getJoinMetaData().getColumnMetaData();
                }
                this.createPerImplementationColumnsForReferenceField(false, false, false, false, this.roleForMember, colmds, clr);
            } else if (this.roleForMember == 5) {
                ColumnMetaData[] colmds = null;
                KeyMetaData keymd = this.mmd.getKeyMetaData();
                if (keymd != null && keymd.getColumnMetaData() != null && keymd.getColumnMetaData().length > 0) {
                    colmds = keymd.getColumnMetaData();
                }
                this.createPerImplementationColumnsForReferenceField(false, false, false, false, this.roleForMember, colmds, clr);
            } else if (this.roleForMember == 6) {
                ColumnMetaData[] colmds = null;
                ValueMetaData valuemd = this.mmd.getValueMetaData();
                if (valuemd != null && valuemd.getColumnMetaData() != null && valuemd.getColumnMetaData().length > 0) {
                    colmds = valuemd.getColumnMetaData();
                }
                this.createPerImplementationColumnsForReferenceField(false, false, false, false, this.roleForMember, colmds, clr);
            } else if (this.mmd.getMappedBy() == null) {
                this.createPerImplementationColumnsForReferenceField(false, true, false, this.mmd.isEmbedded() || this.mmd.getElementMetaData() != null, this.roleForMember, this.mmd.getColumnMetaData(), clr);
            } else {
                InterfaceMetaData refCmd = this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForInterface(this.mmd.getType(), clr);
                if (refCmd != null && refCmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
                    AbstractClassMetaData[] cmds = this.storeMgr.getClassesManagingTableForClass(refCmd, clr);
                    if (cmds != null && cmds.length > 0) {
                        if (cmds.length > 1) {
                            NucleusLogger.PERSISTENCE.warn("Field " + this.mmd.getFullFieldName() + " represents either a 1-1 relation, or a N-1 relation where the other end uses" + " \"subclass-table\" inheritance strategy and more than 1 subclasses with a table. " + "This is not fully supported currently");
                        }
                    } else {
                        return;
                    }
                    this.storeMgr.getDatastoreClass(cmds[0].getFullClassName(), clr).getIdMapping();
                } else {
                    String[] implTypes = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(this.mmd, 2, clr, this.storeMgr.getMetaDataManager());
                    for (int j = 0; j < implTypes.length; ++j) {
                        JavaTypeMapping refMapping = this.storeMgr.getDatastoreClass(implTypes[j], clr).getIdMapping();
                        JavaTypeMapping mapping = this.storeMgr.getMappingManager().getMapping(clr.classForName(implTypes[j]));
                        mapping.setReferenceMapping(refMapping);
                        this.addJavaTypeMapping(mapping);
                    }
                }
            }
        } else if (this.mappingStrategy == 1 || this.mappingStrategy == 2) {
            MappingManager mapMgr = this.storeMgr.getMappingManager();
            JavaTypeMapping mapping = mapMgr.getMapping(String.class);
            mapping.setMemberMetaData(this.mmd);
            mapping.setDatastoreContainer(this.datastoreContainer);
            mapping.setRoleForMember(this.roleForMember);
            DatastoreField col = mapMgr.createDatastoreField(mapping, String.class.getName(), 0);
            mapMgr.createDatastoreMapping(mapping, this.mmd, 0, col);
            this.addJavaTypeMapping(mapping);
        }
    }

    void createPerImplementationColumnsForReferenceField(boolean pk, boolean nullable, boolean serialised, boolean embedded, int fieldRole, ColumnMetaData[] columnMetaData, ClassLoaderResolver clr) {
        if (this instanceof InterfaceMapping && this.mmd != null && this.mmd.hasExtension("implementation-classes")) {
            ((InterfaceMapping)this).setImplementationClasses(this.mmd.getValueForExtension("implementation-classes"));
        }
        String[] implTypes = null;
        try {
            implTypes = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(this.mmd, fieldRole, clr, this.storeMgr.getMetaDataManager());
        }
        catch (NucleusUserException nue) {
            if (this.storeMgr.getBooleanProperty("datanucleus.store.allowReferencesWithNoImplementations", false)) {
                NucleusLogger.DATASTORE_SCHEMA.warn("Possible problem encountered while adding columns for field " + this.mmd.getFullFieldName() + " : " + nue.getMessage());
                return;
            }
            throw nue;
        }
        if (implTypes.length > 1) {
            pk = false;
        }
        if (implTypes.length > 1 && !pk) {
            nullable = true;
        }
        ArrayList<Class> implClasses = new ArrayList<Class>();
        for (int i = 0; i < implTypes.length; ++i) {
            Class type = clr.classForName(implTypes[i]);
            if (type == null) {
                throw new NucleusUserException(LOCALISER_MAPPED.msg("020189", (Object)this.mmd.getTypeName(), (Object)implTypes[i]));
            }
            if (type.isInterface()) {
                throw new NucleusUserException(LOCALISER_MAPPED.msg("020190", (Object)this.mmd.getFullFieldName(), (Object)this.mmd.getTypeName(), (Object)implTypes[i]));
            }
            Iterator iter = implClasses.iterator();
            boolean toBeAdded = true;
            Class clsToSwap = null;
            while (iter.hasNext()) {
                Class cls = (Class)iter.next();
                if (cls == type) {
                    toBeAdded = false;
                    break;
                }
                if (type.isAssignableFrom(cls)) {
                    clsToSwap = cls;
                    toBeAdded = false;
                    break;
                }
                if (!cls.isAssignableFrom(type)) continue;
                toBeAdded = false;
                break;
            }
            if (toBeAdded) {
                implClasses.add(type);
                continue;
            }
            if (clsToSwap == null) continue;
            implClasses.remove(clsToSwap);
            implClasses.add(type);
        }
        int colPos = 0;
        for (Class implClass : implClasses) {
            JavaTypeMapping m;
            boolean present = false;
            int numJavaTypeMappings = this.getJavaTypeMapping().length;
            for (int i = 0; i < numJavaTypeMappings; ++i) {
                JavaTypeMapping implMapping = this.getJavaTypeMapping()[i];
                if (!implClass.getName().equals(implMapping.getType())) continue;
                present = true;
            }
            if (present) continue;
            String fieldTypeName = this.mmd.getTypeName();
            if (this.mmd.getFieldTypes() != null && this.mmd.getFieldTypes().length == 1) {
                fieldTypeName = this.mmd.getFieldTypes()[0];
            }
            if (this.mmd.hasCollection()) {
                fieldTypeName = this.mmd.getCollection().getElementType();
            } else if (this.mmd.hasArray()) {
                fieldTypeName = this.mmd.getArray().getElementType();
            } else if (this.mmd.hasMap()) {
                if (fieldRole == 5) {
                    fieldTypeName = this.mmd.getMap().getKeyType();
                } else if (fieldRole == 6) {
                    fieldTypeName = this.mmd.getMap().getValueType();
                }
            }
            boolean isPersistentInterfaceField = this.storeMgr.getNucleusContext().getMetaDataManager().isPersistentInterface(fieldTypeName);
            boolean columnsNeeded = true;
            if (isPersistentInterfaceField && !this.storeMgr.getNucleusContext().getMetaDataManager().isPersistentInterfaceImplementation(fieldTypeName, implClass.getName())) {
                columnsNeeded = false;
            }
            if (!columnsNeeded) continue;
            if (this.storeMgr.getMappedTypeManager().isSupportedMappedType(implClass.getName())) {
                m = this.storeMgr.getMappingManager().getMapping(implClass, serialised, embedded, this.mmd.getFullFieldName());
            } else {
                try {
                    DatastoreClass dc = this.storeMgr.getDatastoreClass(implClass.getName(), clr);
                    m = dc.getIdMapping();
                }
                catch (NoTableManagedException ex) {
                    throw new NucleusUserException("Cannot define columns for " + this.mmd.getFullFieldName() + " due to " + ex.getMessage(), ex);
                }
            }
            ColumnMetaData[] columnMetaDataForType = null;
            if (columnMetaData != null && columnMetaData.length > 0) {
                if (columnMetaData.length < colPos + m.getNumberOfDatastoreMappings()) {
                    throw new NucleusUserException(LOCALISER_MAPPED.msg("020186", (Object)this.mmd.getFullFieldName(), (Object)("" + columnMetaData.length), (Object)("" + (colPos + m.getNumberOfDatastoreMappings()))));
                }
                columnMetaDataForType = new ColumnMetaData[m.getNumberOfDatastoreMappings()];
                System.arraycopy(columnMetaData, colPos, columnMetaDataForType, 0, columnMetaDataForType.length);
                colPos += columnMetaDataForType.length;
            }
            ColumnCreator.createColumnsForField(implClass, this, this.datastoreContainer, this.storeMgr, this.mmd, pk, nullable, serialised, embedded, fieldRole, columnMetaDataForType, clr, true);
            if (!NucleusLogger.DATASTORE.isInfoEnabled()) continue;
            NucleusLogger.DATASTORE.info(LOCALISER_MAPPED.msg("020188", implClass, (Object)this.mmd.getName()));
        }
    }

    public String getJavaTypeForDatastoreMapping(int index) {
        if ((this.mappingStrategy == 1 || this.mappingStrategy == 2) && index == 0) {
            return String.class.getName();
        }
        return super.getJavaTypeForDatastoreMapping(index);
    }

    public int getMappingNumberForValue(ExecutionContext ec, Object value) {
        if (this.mappingStrategy == 0) {
            return super.getMappingNumberForValue(ec, value);
        }
        if (this.mappingStrategy == 1 || this.mappingStrategy == 2) {
            return -2;
        }
        throw new NucleusException("Mapping strategy of interface/Object fields not yet supported");
    }

    public void setObject(ExecutionContext ec, Object ps, int[] pos, Object value, ObjectProvider ownerSM, int ownerFieldNumber) {
        if (this.mappingStrategy == 0) {
            super.setObject(ec, ps, pos, value, ownerSM, ownerFieldNumber);
        } else if (this.mappingStrategy == 1 || this.mappingStrategy == 2) {
            if (value == null) {
                this.getJavaTypeMapping()[0].setString(ec, ps, pos, null);
            } else {
                String refString = this.getReferenceStringForObject(ec, value);
                this.getJavaTypeMapping()[0].setString(ec, ps, pos, refString);
            }
        }
    }

    public Object getObject(ExecutionContext ec, Object rs, int[] pos) {
        if (this.mappingStrategy == 0) {
            return super.getObject(ec, rs, pos);
        }
        if (this.mappingStrategy == 1 || this.mappingStrategy == 2) {
            String refString = this.getJavaTypeMapping()[0].getString(ec, rs, pos);
            if (refString == null) {
                return null;
            }
            return this.getObjectForReferenceString(ec, refString);
        }
        throw new NucleusException("Mapping strategy of interface/Object fields not yet supported");
    }

    public Class getJavaType() {
        return null;
    }

    protected String getReferenceStringForObject(ExecutionContext ec, Object value) {
        if (ec.getApiAdapter().isPersistable(value)) {
            ObjectProvider sm = ec.findObjectProvider(value);
            if (sm == null) {
                ec.persistObjectInternal(value, null, -1, 0);
                sm = ec.findObjectProvider(value);
                sm.flush();
            }
            String refString = null;
            if (this.mappingStrategy == 1) {
                refString = value.getClass().getName() + ":" + sm.getInternalObjectId();
            } else if (this.mappingStrategy == 2) {
                AbstractClassMetaData cmd = sm.getClassMetaData();
                DiscriminatorMetaData dismd = cmd.getDiscriminatorMetaData();
                String definer = null;
                definer = dismd != null && dismd.getValue() != null ? dismd.getValue() : cmd.getFullClassName();
                refString = cmd.getIdentityType() == IdentityType.DATASTORE ? definer + ":" + ((OID)sm.getInternalObjectId()).getKeyValue() : definer + ":" + sm.getInternalObjectId().toString();
            }
            return refString;
        }
        throw new NucleusException("Identity mapping of non-persistable interface/Object fields not supported");
    }

    protected Object getObjectForReferenceString(ExecutionContext ec, String refString) {
        int sepPos = refString.indexOf(58);
        String refDefiner = refString.substring(0, sepPos);
        String refClassName = null;
        String refId = refString.substring(sepPos + 1);
        AbstractClassMetaData refCmd = null;
        if (this.mappingStrategy == 1) {
            refCmd = ec.getMetaDataManager().getMetaDataForClass(refDefiner, ec.getClassLoaderResolver());
        } else {
            refCmd = ec.getMetaDataManager().getMetaDataForClass(refDefiner, ec.getClassLoaderResolver());
            if (refCmd == null) {
                refCmd = ec.getMetaDataManager().getMetaDataForDiscriminator(refDefiner);
            }
        }
        if (refCmd == null) {
            throw new NucleusException("Reference field contains reference to class of type " + refDefiner + " but no metadata found for this class");
        }
        refClassName = refCmd.getFullClassName();
        Object id = null;
        if (refCmd.getIdentityType() == IdentityType.DATASTORE) {
            if (this.mappingStrategy == 1) {
                id = OIDFactory.getInstance(ec.getNucleusContext(), refId);
            } else if (this.mappingStrategy == 2) {
                id = OIDFactory.getInstance(ec.getNucleusContext(), refCmd.getFullClassName(), refId);
            }
        } else if (refCmd.getIdentityType() == IdentityType.APPLICATION) {
            id = ec.getApiAdapter().getNewApplicationIdentityObjectId(ec.getClassLoaderResolver(), refCmd, refId);
        }
        return ec.findObject(id, true, false, refClassName);
    }

    public void postFetch(ObjectProvider sm) {
    }

    public void insertPostProcessing(ObjectProvider sm) {
    }

    public void postInsert(ObjectProvider sm) {
    }

    public void postUpdate(ObjectProvider sm) {
    }

    public void preDelete(ObjectProvider sm) {
        boolean isDependentElement = this.mmd.isDependent();
        if (!isDependentElement) {
            return;
        }
        for (int i = 0; i < this.javaTypeMappings.length; ++i) {
            JavaTypeMapping mapping = this.javaTypeMappings[i];
            if (!(mapping instanceof PersistableMapping)) continue;
            int fieldNumber = this.getMemberMetaData().getAbsoluteFieldNumber();
            sm.getExecutionContext().getApiAdapter().isLoaded(sm, fieldNumber);
            Object pc = sm.provideField(fieldNumber);
            if (pc == null) continue;
            sm.replaceFieldMakeDirty(fieldNumber, null);
            this.storeMgr.getPersistenceHandler().updateObject(sm, new int[]{fieldNumber});
            sm.getExecutionContext().deleteObjectInternal(pc);
        }
    }
}

