/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.simple;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedSet;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassConstants;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.state.RelationshipManager;
import org.datanucleus.store.types.SCOCollection;
import org.datanucleus.store.types.SCOCollectionIterator;
import org.datanucleus.store.types.SCOMtoN;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class TreeSet
extends java.util.TreeSet
implements SCOCollection,
SCOMtoN,
Cloneable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected transient ObjectProvider ownerOP;
    protected transient String fieldName;
    protected transient int fieldNumber;
    protected java.util.TreeSet delegate;

    public TreeSet(ObjectProvider ownerSM, AbstractMemberMetaData mmd) {
        this.ownerOP = ownerSM;
        this.fieldName = mmd.getName();
        this.fieldNumber = mmd.getAbsoluteFieldNumber();
    }

    public void initialise(Object o, boolean forInsert, boolean forUpdate) {
        Collection c = (Collection)o;
        if (c != null) {
            this.initialiseDelegate();
            this.delegate.addAll(c);
        } else {
            this.initialiseDelegate();
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023003", (Object)this.ownerOP.getObjectAsPrintable(), (Object)this.fieldName, (Object)("" + this.size()), (Object)SCOUtils.getSCOWrapperOptionsMessage(true, false, true, false)));
        }
    }

    public void initialise() {
        this.initialiseDelegate();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023003", (Object)this.ownerOP.getObjectAsPrintable(), (Object)this.fieldName, (Object)("" + this.size()), (Object)SCOUtils.getSCOWrapperOptionsMessage(true, false, true, false)));
        }
    }

    protected void initialiseDelegate() {
        AbstractMemberMetaData fmd = this.ownerOP.getClassMetaData().getMetaDataForMember(this.fieldName);
        Comparator comparator = SCOUtils.getComparator(fmd, this.ownerOP.getExecutionContext().getClassLoaderResolver());
        this.delegate = comparator != null ? new java.util.TreeSet(comparator) : new java.util.TreeSet();
    }

    public Object getValue() {
        return this.delegate;
    }

    public void load() {
    }

    public boolean isLoaded() {
        return true;
    }

    public void flush() {
    }

    public void updateEmbeddedElement(Object element, int fieldNumber, Object value) {
        this.makeDirty();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getOwner() {
        return this.ownerOP != null ? this.ownerOP.getObject() : null;
    }

    public synchronized void unsetOwner() {
        if (this.ownerOP != null) {
            this.ownerOP = null;
        }
    }

    public void makeDirty() {
        if (this.ownerOP != null) {
            ((PersistenceCapable)this.ownerOP.getObject()).jdoMakeDirty(this.fieldName);
        }
    }

    public Object detachCopy(FetchPlanState state) {
        AbstractMemberMetaData fmd = this.ownerOP.getClassMetaData().getMetaDataForMember(this.fieldName);
        Comparator comparator = SCOUtils.getComparator(fmd, this.ownerOP.getExecutionContext().getClassLoaderResolver());
        java.util.TreeSet detached = null;
        detached = comparator != null ? new java.util.TreeSet(comparator) : new java.util.TreeSet();
        SCOUtils.detachCopyForCollection(this.ownerOP, this.toArray(), state, detached);
        return detached;
    }

    public void attachCopy(Object value) {
        Collection c = (Collection)value;
        AbstractMemberMetaData fmd = this.ownerOP.getClassMetaData().getMetaDataForMember(this.fieldName);
        boolean elementsWithoutIdentity = SCOUtils.collectionHasElementsWithoutIdentity(fmd);
        HashSet attachedElements = new HashSet(c.size());
        SCOUtils.attachRemoveDeletedElements(this.ownerOP.getExecutionContext().getApiAdapter(), this, c, elementsWithoutIdentity);
        SCOUtils.attachCopyForCollection(this.ownerOP, c.toArray(), attachedElements, elementsWithoutIdentity);
        SCOUtils.attachAddNewElements(this.ownerOP.getExecutionContext().getApiAdapter(), this, attachedElements, elementsWithoutIdentity);
    }

    public Object clone() {
        return this.delegate.clone();
    }

    public Comparator comparator() {
        return this.delegate.comparator();
    }

    public boolean contains(Object element) {
        return this.delegate.contains(element);
    }

    public synchronized boolean containsAll(Collection c) {
        return this.delegate.containsAll(c);
    }

    public synchronized boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public Object first() {
        return this.delegate.first();
    }

    public synchronized int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public Iterator iterator() {
        return new SCOCollectionIterator(this, this.ownerOP, this.delegate, null, true);
    }

    public SortedSet headSet(Object toElement) {
        return this.delegate.headSet(toElement);
    }

    public SortedSet subSet(Object fromElement, Object toElement) {
        return this.delegate.subSet(fromElement, toElement);
    }

    public SortedSet tailSet(Object fromElement) {
        return this.delegate.headSet(fromElement);
    }

    public Object last() {
        return this.delegate.last();
    }

    public int size() {
        return this.delegate.size();
    }

    public Object[] toArray() {
        return this.delegate.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.delegate.toArray(a);
    }

    public boolean add(Object element) {
        boolean success = this.delegate.add(element);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP).relationAdd(this.fieldNumber, element);
        }
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    public boolean addAll(Collection elements) {
        boolean success = this.delegate.addAll(elements);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP).relationAdd(this.fieldNumber, iter.next());
            }
        }
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    public void clear() {
        AbstractMemberMetaData mmd;
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            Iterator iter = this.delegate.iterator();
            RelationshipManager relMgr = this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP);
            while (iter.hasNext()) {
                relMgr.relationRemove(this.fieldNumber, iter.next());
            }
        }
        if (this.ownerOP != null && !this.delegate.isEmpty() && SCOUtils.hasDependentElement(mmd = this.ownerOP.getClassMetaData().getMetaDataForMember(this.fieldName))) {
            Iterator iter = this.delegate.iterator();
            while (iter.hasNext()) {
                this.ownerOP.getExecutionContext().deleteObjectInternal(iter.next());
            }
        }
        this.delegate.clear();
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    public synchronized boolean remove(Object element) {
        return this.remove(element, true);
    }

    public synchronized boolean remove(Object element, boolean allowCascadeDelete) {
        AbstractMemberMetaData mmd;
        boolean success = this.delegate.remove(element);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP).relationRemove(this.fieldNumber, element);
        }
        if (this.ownerOP != null && allowCascadeDelete && SCOUtils.hasDependentElement(mmd = this.ownerOP.getClassMetaData().getMetaDataForMember(this.fieldName))) {
            this.ownerOP.getExecutionContext().deleteObjectInternal(element);
        }
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    public boolean removeAll(Collection elements) {
        AbstractMemberMetaData mmd;
        boolean success = this.delegate.removeAll(elements);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            Iterator iter = elements.iterator();
            RelationshipManager relMgr = this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP);
            while (iter.hasNext()) {
                relMgr.relationRemove(this.fieldNumber, iter.next());
            }
        }
        if (this.ownerOP != null && elements != null && !elements.isEmpty() && SCOUtils.hasDependentElement(mmd = this.ownerOP.getClassMetaData().getMetaDataForMember(this.fieldName))) {
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                this.ownerOP.getExecutionContext().deleteObjectInternal(iter.next());
            }
        }
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    public synchronized boolean retainAll(Collection c) {
        boolean success = this.delegate.retainAll(c);
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new java.util.TreeSet(this.delegate);
    }
}

