/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.Enumeration;
import java.util.Hashtable;
import org.datanucleus.ExecutionContext;
import org.datanucleus.ExecutionContextImpl;
import org.datanucleus.ExecutionContextThreadedImpl;
import org.datanucleus.NucleusContext;
import org.datanucleus.util.NucleusLogger;

public class ExecutionContextPool {
    private NucleusContext nucCtx;
    private long maxIdle = 20L;
    private long expirationTime;
    private Hashtable<ExecutionContext, Long> recyclableECs;
    private CleanUpThread cleaner;

    public ExecutionContextPool(NucleusContext nucCtx) {
        this.maxIdle = nucCtx.getPersistenceConfiguration().getIntProperty("datanucleus.executionContext.maxIdle");
        this.nucCtx = nucCtx;
        this.expirationTime = 30000L;
        this.recyclableECs = new Hashtable();
        if (nucCtx.getPersistenceConfiguration().getBooleanProperty("datanucleus.executionContext.reaperThread")) {
            this.cleaner = new CleanUpThread(this, this.expirationTime * 2L);
            this.cleaner.start();
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug("Started pool of ExecutionContext (maxPool=" + this.maxIdle + ", reaperThread=" + (this.cleaner != null) + ")");
        }
    }

    protected ExecutionContext create(Object owner, String userName, String password) {
        if (this.nucCtx.getPersistenceConfiguration().getBooleanProperty("datanucleus.Multithreaded")) {
            return new ExecutionContextThreadedImpl(this.nucCtx, owner, userName, password);
        }
        return new ExecutionContextImpl(this.nucCtx, owner, userName, password);
    }

    public boolean validate(ExecutionContext ec) {
        return true;
    }

    public void expire(ExecutionContext ec) {
    }

    public synchronized ExecutionContext checkOut(Object owner, String username, String password) {
        ExecutionContext ec;
        long now = System.currentTimeMillis();
        if (this.recyclableECs.size() > 0) {
            Enumeration<ExecutionContext> e = this.recyclableECs.keys();
            while (e.hasMoreElements()) {
                ec = e.nextElement();
                if (now - this.recyclableECs.get(ec) > this.expirationTime) {
                    this.recyclableECs.remove(ec);
                    this.expire(ec);
                    ec = null;
                    continue;
                }
                if (this.validate(ec)) {
                    this.recyclableECs.remove(ec);
                    ec.initialise(owner, username, password);
                    return ec;
                }
                this.recyclableECs.remove(ec);
                this.expire(ec);
                ec = null;
            }
        }
        ec = this.create(owner, username, password);
        return ec;
    }

    public synchronized void cleanUp() {
        long now = System.currentTimeMillis();
        Enumeration<ExecutionContext> e = this.recyclableECs.keys();
        while (e.hasMoreElements()) {
            ExecutionContext ec = e.nextElement();
            if (now - this.recyclableECs.get(ec) <= this.expirationTime) continue;
            this.recyclableECs.remove(ec);
            this.expire(ec);
            ec = null;
        }
        System.gc();
    }

    public synchronized void checkIn(ExecutionContext ec) {
        if ((long)this.recyclableECs.size() < this.maxIdle) {
            this.recyclableECs.put(ec, System.currentTimeMillis());
        }
    }

    class CleanUpThread
    extends Thread {
        private ExecutionContextPool pool;
        private long sleepTime;

        CleanUpThread(ExecutionContextPool pool, long sleepTime) {
            this.pool = pool;
            this.sleepTime = sleepTime;
        }

        public void run() {
            while (true) {
                try {
                    CleanUpThread.sleep(this.sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.pool.cleanUp();
            }
        }
    }
}

