/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.FetchPlanForClass;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.cache.L2CachePopulateFieldManager;
import org.datanucleus.cache.L2CacheRetrieveFieldManager;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.AbstractStateManager;
import org.datanucleus.state.ActivityState;
import org.datanucleus.state.DetachState;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.exceptions.NotYetFlushedException;
import org.datanucleus.store.fieldmanager.AbstractFetchDepthFieldManager;
import org.datanucleus.store.fieldmanager.AttachFieldManager;
import org.datanucleus.store.fieldmanager.DeleteFieldManager;
import org.datanucleus.store.fieldmanager.DetachFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.fieldmanager.LoadFieldManager;
import org.datanucleus.store.fieldmanager.MakeTransientFieldManager;
import org.datanucleus.store.fieldmanager.NullifyRelationFieldManager;
import org.datanucleus.store.fieldmanager.PersistFieldManager;
import org.datanucleus.store.fieldmanager.ReachabilityFieldManager;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;
import org.datanucleus.store.fieldmanager.UnsetOwnerFieldManager;
import org.datanucleus.store.objectvaluegenerator.ObjectValueGenerator;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.SCOCollection;
import org.datanucleus.store.types.SCOContainer;
import org.datanucleus.store.types.SCOMap;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.datanucleus.util.TypeConversionHelper;

public class JDOStateManager
extends AbstractStateManager {
    private static final JDOImplHelper HELPER = (JDOImplHelper)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            try {
                return JDOImplHelper.getInstance();
            }
            catch (SecurityException e) {
                throw new JDOFatalUserException(AbstractStateManager.LOCALISER.msg("026000"), (Throwable)e);
            }
        }
    });
    private PersistenceCapable referencedPC = null;
    private List<EmbeddedOwnerRelation> embeddedOwners = null;
    protected short pcObjectType = 0;
    static HashMap<String, ObjectValueGenerator> objectValGenerators = new HashMap(1);
    boolean[] preDeleteLoadedFields = null;
    private List<JDOStateManager> insertionNotifyList = null;
    private Map<JDOStateManager, FieldContainer> fieldsToBeUpdatedAfterObjectInsertion = null;

    public JDOStateManager(ExecutionContext ec, AbstractClassMetaData cmd) {
        super(ec, cmd);
    }

    public void initialiseForHollow(Object id, FieldValues fv, Class pcClass) {
        this.myID = id;
        this.myLC = this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(4);
        this.jdoDfgFlags = 1;
        if (id instanceof OID || id == null) {
            this.myPC = HELPER.newInstance(pcClass, (StateManager)this);
        } else {
            this.myPC = HELPER.newInstance(pcClass, (StateManager)this, this.myID);
            this.markPKFieldsAsLoaded();
        }
        this.myEC.putObjectIntoLevel1Cache(this);
        if (fv != null) {
            this.loadFieldValues(fv);
        }
    }

    public void initialiseForHollowAppId(FieldValues fv, Class pcClass) {
        if (this.cmd.getIdentityType() != IdentityType.APPLICATION) {
            throw new NucleusUserException("This constructor is only for objects using application identity.").setFatal();
        }
        this.myLC = this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(4);
        this.jdoDfgFlags = 1;
        this.myPC = HELPER.newInstance(pcClass, (StateManager)this);
        if (this.myPC == null) {
            if (!HELPER.getRegisteredClasses().contains(pcClass)) {
                throw new NucleusUserException(LOCALISER.msg("026018", (Object)pcClass.getName())).setFatal();
            }
            throw new NucleusUserException(LOCALISER.msg("026019", (Object)pcClass.getName())).setFatal();
        }
        this.loadFieldValues(fv);
        this.myID = this.myPC.jdoNewObjectIdInstance();
        if (!this.cmd.usesSingleFieldIdentityClass()) {
            this.myPC.jdoCopyKeyFieldsToObjectId(this.myID);
        }
    }

    public void initialiseForHollowPreConstructed(Object id, Object pc) {
        this.myID = id;
        this.myLC = this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(4);
        this.jdoDfgFlags = 1;
        this.myPC = (PersistenceCapable)pc;
        this.replaceStateManager(this.myPC, this);
        this.myPC.jdoReplaceFlags();
    }

    public void initialiseForPersistentClean(Object id, Object pc) {
        this.myID = id;
        this.myLC = this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(2);
        this.jdoDfgFlags = 1;
        this.myPC = (PersistenceCapable)pc;
        this.replaceStateManager(this.myPC, this);
        this.myPC.jdoReplaceFlags();
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
        this.myEC.putObjectIntoLevel1Cache(this);
    }

    public void initialiseForEmbedded(Object pc, boolean copyPc) {
        this.pcObjectType = 1;
        this.myID = null;
        this.myLC = this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(2);
        this.jdoDfgFlags = 1;
        this.myPC = (PersistenceCapable)pc;
        this.replaceStateManager(this.myPC, this);
        if (copyPc) {
            PersistenceCapable pcCopy = this.myPC.jdoNewInstance((StateManager)this);
            pcCopy.jdoCopyFields((Object)this.myPC, this.cmd.getAllMemberPositions());
            this.replaceStateManager(pcCopy, this);
            this.myPC = pcCopy;
            this.disconnectClone((PersistenceCapable)pc);
        }
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialiseForPersistentNew(Object pc, FieldValues preInsertChanges) {
        ClassLoaderResolver clr;
        int[] relationPositions;
        this.myPC = (PersistenceCapable)pc;
        this.myLC = this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(1);
        this.jdoDfgFlags = (byte)-1;
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
        this.replaceStateManager(this.myPC, this);
        this.myPC.jdoReplaceFlags();
        this.saveFields();
        this.populateStrategyFields();
        if (preInsertChanges != null) {
            preInsertChanges.fetchFields(this);
        }
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            int totalNumFields = this.cmd.getAllMemberPositions().length;
            for (int fieldNumber = 0; fieldNumber < totalNumFields; ++fieldNumber) {
                Object var12_13;
                AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                if (!fmd.isPrimaryKey() || this.myEC.getMetaDataManager().getMetaDataForClass(fmd.getType(), this.getExecutionContext().getClassLoaderResolver()) == null) continue;
                try {
                    Object var10_12;
                    if (this.myEC.getMultithreaded()) {
                        this.myEC.getLock().lock();
                        this.lock.lock();
                    }
                    FieldManager prevFM = this.currFM;
                    try {
                        this.currFM = new SingleValueFieldManager();
                        this.myPC.jdoProvideField(fieldNumber);
                        PersistenceCapable pkFieldPC = (PersistenceCapable)((SingleValueFieldManager)this.currFM).fetchObjectField(fieldNumber);
                        if (pkFieldPC == null) {
                            throw new NucleusUserException(LOCALISER.msg("026016", (Object)fmd.getFullFieldName()));
                        }
                        if (!this.myEC.getApiAdapter().isPersistent(pkFieldPC)) {
                            Object persistedFieldPC = this.myEC.persistObjectInternal(pkFieldPC, null, null, -1, 0);
                            this.replaceField(this.myPC, fieldNumber, persistedFieldPC, false);
                        }
                        var10_12 = null;
                        this.currFM = prevFM;
                    }
                    catch (Throwable throwable) {
                        var10_12 = null;
                        this.currFM = prevFM;
                        throw throwable;
                    }
                    var12_13 = null;
                    if (!this.myEC.getMultithreaded()) continue;
                    this.lock.unlock();
                    this.myEC.getLock().unlock();
                    continue;
                }
                catch (Throwable throwable) {
                    var12_13 = null;
                    if (this.myEC.getMultithreaded()) {
                        this.lock.unlock();
                        this.myEC.getLock().unlock();
                    }
                    throw throwable;
                }
            }
        }
        this.setIdentity(false);
        if (this.myEC.getTransaction().isActive()) {
            this.myEC.enlistInTransaction(this);
        }
        this.getCallbackHandler().postCreate(this.myPC);
        if (this.myEC.getManageRelations() && (relationPositions = this.cmd.getRelationMemberPositions(clr = this.myEC.getClassLoaderResolver(), this.myEC.getMetaDataManager())) != null) {
            for (int i = 0; i < relationPositions.length; ++i) {
                Object value;
                AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(relationPositions[i]);
                if (!RelationType.isBidirectional(mmd.getRelationType(clr)) || (value = this.provideField(relationPositions[i])) == null) continue;
                this.myEC.getRelationshipManager(this).relationChange(relationPositions[i], null, value);
            }
        }
    }

    public void initialiseForTransactionalTransient(Object pc) {
        this.myPC = (PersistenceCapable)pc;
        this.myLC = null;
        this.jdoDfgFlags = (byte)-1;
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
        this.myPC.jdoReplaceFlags();
        this.populateStrategyFields();
        this.setIdentity(false);
        if (this.myEC.getTransaction().isActive()) {
            this.myEC.enlistInTransaction(this);
        }
    }

    public void initialiseForDetached(Object pc, Object id, Object version) {
        this.myID = id;
        this.myPC = (PersistenceCapable)pc;
        this.setVersion(version);
        this.myLC = this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(11);
        this.myPC.jdoReplaceFlags();
        this.replaceStateManager(this.myPC, this);
    }

    public void initialiseForPNewToBeDeleted(Object pc) {
        this.myID = null;
        this.myPC = (PersistenceCapable)pc;
        this.myLC = this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(1);
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
        this.replaceStateManager(this.myPC, this);
    }

    public void initialiseForCachedPC(CachedPC cachedPC, Object id) {
        this.initialiseForHollow(id, null, cachedPC.getObjectClass());
        this.myLC = this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(2);
        this.jdoDfgFlags = (byte)-1;
        int[] fieldsToLoad = ClassUtils.getFlagsSetTo(cachedPC.getLoadedFields(), this.myFP.getMemberNumbers(), true);
        if (fieldsToLoad != null) {
            this.myEC.putObjectIntoLevel1Cache(this);
            this.replaceFields(fieldsToLoad, new L2CacheRetrieveFieldManager(this, cachedPC));
            for (int i = 0; i < fieldsToLoad.length; ++i) {
                this.loadedFields[fieldsToLoad[i]] = true;
            }
        }
        if (cachedPC.getVersion() != null) {
            this.setVersion(cachedPC.getVersion());
        }
        this.replaceAllLoadedSCOFieldsWithWrappers();
        if (this.myEC.getTransaction().isActive()) {
            this.myEC.enlistInTransaction(this);
        }
        if (this.areFieldsLoaded(this.myFP.getMemberNumbers())) {
            this.postLoad();
        }
    }

    public void checkInheritance(FieldValues fv) {
        ClassLoaderResolver clr = this.myEC.getClassLoaderResolver();
        String className = this.myEC.getStoreManager().getClassNameForObjectID(this.myID, clr, this.myEC);
        if (className == null) {
            throw new NucleusObjectNotFoundException(LOCALISER.msg("026013", (Object)IdentityUtils.getIdentityAsString(this.myEC.getApiAdapter(), this.myID)), this.myID);
        }
        if (!this.cmd.getFullClassName().equals(className)) {
            Class pcClass;
            try {
                pcClass = clr.classForName(className, this.myID.getClass().getClassLoader(), true);
                this.cmd = this.myEC.getMetaDataManager().getMetaDataForClass(pcClass, clr);
            }
            catch (ClassNotResolvedException e) {
                NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("026014", (Object)IdentityUtils.getIdentityAsString(this.myEC.getApiAdapter(), this.myID)));
                throw new NucleusUserException(LOCALISER.msg("026014", (Object)IdentityUtils.getIdentityAsString(this.myEC.getApiAdapter(), this.myID)), e);
            }
            if (this.cmd == null) {
                throw new NucleusUserException(LOCALISER.msg("026012", pcClass)).setFatal();
            }
            if (this.cmd.getIdentityType() != IdentityType.APPLICATION) {
                throw new NucleusUserException("This method should only be used for objects using application identity.").setFatal();
            }
            this.myFP = this.myEC.getFetchPlan().manageFetchPlanForClass(this.cmd);
            int fieldCount = this.cmd.getMemberCount();
            this.dirtyFields = new boolean[fieldCount];
            this.loadedFields = new boolean[fieldCount];
            this.myPC = HELPER.newInstance(pcClass, (StateManager)this);
            if (this.myPC == null) {
                throw new NucleusUserException(LOCALISER.msg("026018", (Object)this.cmd.getFullClassName())).setFatal();
            }
            this.loadFieldValues(fv);
            this.myID = this.myPC.jdoNewObjectIdInstance();
            if (!this.cmd.usesSingleFieldIdentityClass()) {
                this.myPC.jdoCopyKeyFieldsToObjectId(this.myID);
            }
        }
    }

    private void populateStrategyFields() {
        int totalFieldCount = this.cmd.getNoOfInheritedManagedMembers() + this.cmd.getNoOfManagedMembers();
        for (int fieldNumber = 0; fieldNumber < totalFieldCount; ++fieldNumber) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            IdentityStrategy strategy = mmd.getValueStrategy();
            if (strategy != null && !this.myEC.getStoreManager().isStrategyDatastoreAttributed(this.cmd, fieldNumber)) {
                boolean applyStrategy = true;
                if (!mmd.getType().isPrimitive() && strategy != null && mmd.hasExtension("strategy-when-notnull") && mmd.getValueForExtension("strategy-when-notnull").equalsIgnoreCase("false") && this.provideField(fieldNumber) != null) {
                    applyStrategy = false;
                }
                if (!applyStrategy) continue;
                Object obj = this.myEC.getStoreManager().getStrategyValue(this.myEC, this.cmd, fieldNumber);
                this.replaceField(fieldNumber, obj);
                continue;
            }
            if (!mmd.hasExtension("object-value-generator")) continue;
            String valGenName = mmd.getValueForExtension("object-value-generator");
            ObjectValueGenerator valGen = JDOStateManager.getObjectValueGenerator(this.myEC, valGenName);
            Object value = valGen.generate(this.myEC, this.myPC, mmd.getExtensions());
            this.replaceField(this.myPC, fieldNumber, value, true);
        }
    }

    protected static ObjectValueGenerator getObjectValueGenerator(ExecutionContext ec, String genName) {
        ObjectValueGenerator valGen;
        if (!objectValGenerators.isEmpty() && (valGen = objectValGenerators.get(genName)) != null) {
            return valGen;
        }
        try {
            valGen = (ObjectValueGenerator)ec.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store_objectvaluegenerator", new String[]{"name"}, new String[]{genName}, "class-name", null, null);
            objectValGenerators.put(genName, valGen);
            return valGen;
        }
        catch (Exception e) {
            NucleusLogger.VALUEGENERATION.info("Exception thrown generating value using objectvaluegenerator " + genName, e);
            throw new NucleusException("Exception thrown generating value for object", e);
        }
    }

    public void loadFieldValues(FieldValues fv) {
        FetchPlanForClass origFetchPlan = this.myFP;
        FetchPlan loadFetchPlan = fv.getFetchPlanForLoading();
        if (loadFetchPlan != null) {
            this.myFP = loadFetchPlan.manageFetchPlanForClass(this.cmd);
        }
        boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
        if (this.loadedFields.length == 0) {
            callPostLoad = true;
        }
        fv.fetchFields(this);
        if (callPostLoad && this.areFieldsLoaded(this.myFP.getMemberNumbers())) {
            this.postLoad();
        }
        this.myFP = origFetchPlan;
    }

    private void setIdentity(boolean afterPreStore) {
        if (this.cmd.isEmbeddedOnly()) {
            return;
        }
        if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
            if (this.cmd.getIdentityMetaData() == null || !this.myEC.getStoreManager().isStrategyDatastoreAttributed(this.cmd, -1)) {
                this.myID = this.myEC.newObjectId(this.cmd.getFullClassName(), (Object)this.myPC);
            }
        } else if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            boolean idSetInDatastore = false;
            int totalFieldCount = this.cmd.getNoOfInheritedManagedMembers() + this.cmd.getNoOfManagedMembers();
            for (int fieldNumber = 0; fieldNumber < totalFieldCount; ++fieldNumber) {
                AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                if (!fmd.isPrimaryKey()) continue;
                if (this.myEC.getStoreManager().isStrategyDatastoreAttributed(this.cmd, fieldNumber)) {
                    idSetInDatastore = true;
                    break;
                }
                if (!this.cmd.usesSingleFieldIdentityClass() || this.provideField(fieldNumber) != null) continue;
                if (afterPreStore) {
                    throw new NucleusUserException(LOCALISER.msg("026017", (Object)this.cmd.getFullClassName(), (Object)fmd.getName())).setFatal();
                }
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026017", (Object)this.cmd.getFullClassName(), (Object)fmd.getName()));
                return;
            }
            if (!idSetInDatastore) {
                this.myID = this.myEC.newObjectId(this.cmd.getFullClassName(), (Object)this.myPC);
            }
        }
        if (this.myInternalID != this.myID && this.myID != null && this.myEC.getApiAdapter().getIdForObject(this.myPC) != null) {
            this.myEC.replaceObjectId(this.myPC, this.myInternalID, this.myID);
            this.myInternalID = this.myID;
        }
    }

    public void copyFieldsFromObject(Object obj, int[] fieldNumbers) {
        if (obj == null) {
            return;
        }
        if (!obj.getClass().getName().equals(this.myPC.getClass().getName())) {
            return;
        }
        if (!(obj instanceof PersistenceCapable)) {
            throw new NucleusUserException("Must be PersistenceCapable");
        }
        PersistenceCapable pc = (PersistenceCapable)obj;
        this.replaceStateManager(pc, this);
        this.myPC.jdoCopyFields((Object)pc, fieldNumbers);
        this.replaceStateManager(pc, null);
        for (int i = 0; i < fieldNumbers.length; ++i) {
            this.loadedFields[fieldNumbers[i]] = true;
        }
    }

    public void makeDirty(int fieldNumber) {
        if (this.activity != ActivityState.DELETING) {
            boolean wasDirty = this.preWriteField(fieldNumber);
            this.postWriteField(wasDirty);
            if (this.embeddedOwners != null) {
                for (EmbeddedOwnerRelation owner : this.embeddedOwners) {
                    JDOStateManager ownerSM = owner.sm;
                    if (ownerSM == null || ownerSM.cmd == null || (ownerSM.flags & 0x100) != 0) continue;
                    ownerSM.makeDirty(owner.fieldNumber);
                }
            }
        }
    }

    public void makeDirty(PersistenceCapable pc, String fieldName) {
        if (!this.disconnectClone(pc)) {
            int fieldNumber = this.cmd.getAbsolutePositionOfMember(fieldName);
            if (fieldNumber == -1) {
                throw new JDOUserException(LOCALISER.msg("026002", (Object)fieldName, (Object)this.cmd.getFullClassName()));
            }
            this.makeDirty(fieldNumber);
        }
    }

    public Object getObjectId(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return null;
        }
        return this.getExternalObjectId(pc);
    }

    public Object getTransactionalObjectId(PersistenceCapable pc) {
        return this.getObjectId(pc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPostStoreNewObjectId(Object id) {
        if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
            this.myID = id instanceof OID ? id : OIDFactory.getInstance(this.myEC.getNucleusContext(), this.cmd.getFullClassName(), id);
        } else if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            try {
                try {
                    this.myID = null;
                    int fieldCount = this.cmd.getMemberCount();
                    for (int fieldNumber = 0; fieldNumber < fieldCount; ++fieldNumber) {
                        AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                        if (!fmd.isPrimaryKey() || !this.myEC.getStoreManager().isStrategyDatastoreAttributed(this.cmd, fieldNumber)) continue;
                        this.replaceField(this.myPC, fieldNumber, TypeConversionHelper.convertTo(id, fmd.getType()), false);
                    }
                    Object var6_6 = null;
                    this.myID = this.myEC.getApiAdapter().getNewApplicationIdentityObjectId(this.getObject(), this.cmd);
                }
                catch (Exception e) {
                    NucleusLogger.PERSISTENCE.error(e);
                    Object var6_7 = null;
                    this.myID = this.myEC.getApiAdapter().getNewApplicationIdentityObjectId(this.getObject(), this.cmd);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.myID = this.myEC.getApiAdapter().getNewApplicationIdentityObjectId(this.getObject(), this.cmd);
                throw throwable;
            }
        }
        if (this.myInternalID != this.myID && this.myID != null) {
            this.myEC.replaceObjectId(this.myPC, this.myInternalID, this.myID);
            this.myInternalID = this.myID;
        }
    }

    protected Object getExternalObjectId(Object obj) {
        if (this.embeddedOwners != null) {
            return this.myID;
        }
        if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
            if (!this.isFlushing() && !this.isFlushedNew() && this.activity != ActivityState.INSERTING && this.activity != ActivityState.INSERTING_CALLBACKS && this.myLC.stateType() == 1 && this.myEC.getStoreManager().isStrategyDatastoreAttributed(this.cmd, -1)) {
                this.flush();
            }
        } else if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            if (!this.isFlushing() && !this.isFlushedNew() && this.activity != ActivityState.INSERTING && this.activity != ActivityState.INSERTING_CALLBACKS && this.myLC.stateType() == 1) {
                int[] pkFieldNumbers = this.cmd.getPKMemberPositions();
                for (int i = 0; i < pkFieldNumbers.length; ++i) {
                    if (!this.myEC.getStoreManager().isStrategyDatastoreAttributed(this.cmd, pkFieldNumbers[i])) continue;
                    this.flush();
                    break;
                }
            }
            if (this.cmd.usesSingleFieldIdentityClass()) {
                return this.myID;
            }
            return this.myEC.getApiAdapter().getNewApplicationIdentityObjectId(this.myPC, this.cmd);
        }
        return this.myID;
    }

    public Object getExternalObjectId() {
        return this.getExternalObjectId(this.myPC);
    }

    private int[] loadFieldsFromLevel2Cache(int[] fieldNumbers) {
        int[] cacheFieldsToLoad;
        CachedPC cachedPC;
        if (fieldNumbers == null || fieldNumbers.length == 0 || this.myEC.isFlushing() || this.myLC.isDeleted() || this.isDeleting() || this.getExecutionContext().getTransaction().isCommitting()) {
            return fieldNumbers;
        }
        if (!this.myEC.getNucleusContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.cache.level2.loadFields", true)) {
            return fieldNumbers;
        }
        Level2Cache l2cache = this.myEC.getNucleusContext().getLevel2Cache();
        if (l2cache != null && this.myEC.getNucleusContext().isClassCacheable(this.cmd) && (cachedPC = l2cache.get(this.myID)) != null && (cacheFieldsToLoad = ClassUtils.getFlagsSetTo(cachedPC.getLoadedFields(), fieldNumbers, true)) != null && cacheFieldsToLoad.length > 0) {
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("026034", (Object)StringUtils.toJVMIDString(this.myPC), this.myID, (Object)StringUtils.intArrayToString(cacheFieldsToLoad)));
            }
            this.replaceFields(cacheFieldsToLoad, new L2CacheRetrieveFieldManager(this, cachedPC));
        }
        return ClassUtils.getFlagsSetTo(this.loadedFields, fieldNumbers, false);
    }

    private void updateLevel2CacheForFields(int[] fieldNumbers) {
        int[] cacheFieldsToLoad;
        CachedPC cachedPC;
        if (fieldNumbers == null || fieldNumbers.length == 0) {
            return;
        }
        Level2Cache l2cache = this.myEC.getNucleusContext().getLevel2Cache();
        if (l2cache != null && this.myEC.getNucleusContext().isClassCacheable(this.cmd) && !this.myEC.isObjectModifiedInTransaction(this.myID) && (cachedPC = l2cache.get(this.myID)) != null && (cacheFieldsToLoad = ClassUtils.getFlagsSetTo(cachedPC.getLoadedFields(), fieldNumbers, false)) != null && cacheFieldsToLoad.length > 0) {
            CachedPC copyCachedPC = cachedPC.getCopy();
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("026033", (Object)StringUtils.toJVMIDString(this.myPC), this.myID, (Object)StringUtils.intArrayToString(cacheFieldsToLoad)));
            }
            this.provideFields(cacheFieldsToLoad, new L2CachePopulateFieldManager(this, copyCachedPC));
            this.myEC.getNucleusContext().getLevel2Cache().put(this.getInternalObjectId(), copyCachedPC);
        }
    }

    protected void loadSpecifiedFields(int[] fieldNumbers) {
        if (this.myEC.getApiAdapter().isDetached(this.myPC)) {
            return;
        }
        int[] unloadedFieldNumbers = this.loadFieldsFromLevel2Cache(fieldNumbers);
        if (unloadedFieldNumbers != null && !this.isEmbedded()) {
            this.loadFieldsFromDatastore(unloadedFieldNumbers);
            this.updateLevel2CacheForFields(unloadedFieldNumbers);
        }
    }

    public void loadField(int fieldNumber) {
        if (this.loadedFields[fieldNumber]) {
            return;
        }
        this.loadSpecifiedFields(new int[]{fieldNumber});
    }

    public void loadUnloadedFields() {
        int[] fieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, this.cmd.getAllMemberPositions(), false);
        if (fieldNumbers == null || fieldNumbers.length == 0) {
            return;
        }
        if (this.preDeleteLoadedFields != null && (this.myLC.isDeleted() && this.myEC.isFlushing() || this.activity == ActivityState.DELETING)) {
            fieldNumbers = ClassUtils.getFlagsSetTo(this.preDeleteLoadedFields, fieldNumbers, false);
        }
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            int[] unloadedFieldNumbers = this.loadFieldsFromLevel2Cache(fieldNumbers);
            if (unloadedFieldNumbers != null) {
                this.loadFieldsFromDatastore(unloadedFieldNumbers);
            }
            int[] secondClassMutableFieldNumbers = this.cmd.getSCOMutableMemberPositions();
            for (int i = 0; i < secondClassMutableFieldNumbers.length; ++i) {
                SingleValueFieldManager sfv = new SingleValueFieldManager();
                this.provideFields(new int[]{secondClassMutableFieldNumbers[i]}, sfv);
                Object value = sfv.fetchObjectField(i);
                if (!(value instanceof SCOContainer)) continue;
                ((SCOContainer)value).load();
            }
            if (fieldNumbers != null) {
                this.updateLevel2CacheForFields(fieldNumbers);
            }
            if (callPostLoad) {
                this.postLoad();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFieldsInFetchPlan(FetchPlanState state) {
        if ((this.flags & 0x2000) != 0) {
            return;
        }
        this.flags |= 0x2000;
        try {
            this.loadUnloadedFieldsInFetchPlan();
            int[] fieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, this.cmd.getAllMemberPositions(), true);
            if (fieldNumbers != null && fieldNumbers.length > 0) {
                this.replaceFields(fieldNumbers, new LoadFieldManager(this, this.cmd.getSCOMutableMemberFlags(), this.myFP, state));
                this.updateLevel2CacheForFields(fieldNumbers);
            }
            Object var4_3 = null;
            this.flags &= 0xFFFFDFFF;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.flags &= 0xFFFFDFFF;
            throw throwable;
        }
    }

    public void loadUnloadedFieldsInFetchPlan() {
        int[] fieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, this.myFP.getMemberNumbers(), false);
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            int[] unloadedFieldNumbers = this.loadFieldsFromLevel2Cache(fieldNumbers);
            if (unloadedFieldNumbers != null) {
                this.loadFieldsFromDatastore(unloadedFieldNumbers);
                this.updateLevel2CacheForFields(unloadedFieldNumbers);
            }
            if (callPostLoad) {
                this.postLoad();
            }
        }
    }

    protected void loadUnloadedFieldsInFetchPlanAndVersion() {
        if (!this.cmd.isVersioned()) {
            this.loadUnloadedFieldsInFetchPlan();
        } else {
            int[] fieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, this.myFP.getMemberNumbers(), false);
            if (fieldNumbers == null) {
                fieldNumbers = new int[]{};
            }
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            int[] unloadedFieldNumbers = this.loadFieldsFromLevel2Cache(fieldNumbers);
            if (unloadedFieldNumbers != null) {
                this.loadFieldsFromDatastore(unloadedFieldNumbers);
                this.updateLevel2CacheForFields(unloadedFieldNumbers);
            }
            if (callPostLoad && fieldNumbers.length > 0) {
                this.postLoad();
            }
        }
    }

    public void loadUnloadedFieldsOfClassInFetchPlan(FetchPlan fetchPlan) {
        FetchPlanForClass fpc = fetchPlan.manageFetchPlanForClass(this.cmd);
        int[] fieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, fpc.getMemberNumbers(), false);
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            boolean callPostLoad = fpc.isToCallPostLoadFetchPlan(this.loadedFields);
            int[] unloadedFieldNumbers = this.loadFieldsFromLevel2Cache(fieldNumbers);
            if (unloadedFieldNumbers != null) {
                this.loadFieldsFromDatastore(unloadedFieldNumbers);
                this.updateLevel2CacheForFields(unloadedFieldNumbers);
            }
            if (callPostLoad) {
                this.postLoad();
            }
        }
    }

    public void unloadField(String fieldName) {
        if (this.pcObjectType != 0) {
            throw new NucleusUserException("Cannot unload field/property of embedded object");
        }
        AbstractMemberMetaData mmd = this.getClassMetaData().getMetaDataForMember(fieldName);
        this.loadedFields[mmd.getAbsoluteFieldNumber()] = false;
    }

    protected void markPKFieldsAsLoaded() {
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkPositions = this.cmd.getPKMemberPositions();
            for (int i = 0; i < pkPositions.length; ++i) {
                this.loadedFields[pkPositions[i]] = true;
            }
        }
    }

    public void refreshFieldsInFetchPlan() {
        int[] fieldNumbers = this.myFP.getMemberNumbers();
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            this.clearDirtyFlags(fieldNumbers);
            ClassUtils.clearFlags(this.loadedFields, fieldNumbers);
            this.markPKFieldsAsLoaded();
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            this.setTransactionalVersion(null);
            this.loadFieldsFromDatastore(fieldNumbers);
            if (this.cmd.hasRelations(this.myEC.getClassLoaderResolver(), this.myEC.getMetaDataManager())) {
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    Object value;
                    AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
                    RelationType relationType = fmd.getRelationType(this.myEC.getClassLoaderResolver());
                    if (relationType == RelationType.NONE || !fmd.isCascadeRefresh() || (value = this.provideField(fieldNumbers[i])) == null) continue;
                    if (value instanceof Collection) {
                        SCOUtils.refreshFetchPlanFieldsForCollection(this, ((Collection)value).toArray());
                        continue;
                    }
                    if (value instanceof Map) {
                        SCOUtils.refreshFetchPlanFieldsForMap(this, ((Map)value).entrySet());
                        continue;
                    }
                    if (!(value instanceof PersistenceCapable)) continue;
                    this.myEC.refreshObject(value);
                }
            }
            if (callPostLoad) {
                this.postLoad();
            }
            this.getCallbackHandler().postRefresh(this.myPC);
        }
    }

    public void refreshLoadedFields() {
        int[] fieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, this.myFP.getMemberNumbers(), true);
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            this.clearDirtyFlags();
            ClassUtils.clearFlags(this.loadedFields);
            this.markPKFieldsAsLoaded();
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            this.loadFieldsFromDatastore(fieldNumbers);
            if (callPostLoad) {
                this.postLoad();
            }
        }
    }

    public void unloadNonFetchPlanFields() {
        int[] fpFieldNumbers = this.myFP.getMemberNumbers();
        int[] nonfpFieldNumbers = null;
        if (fpFieldNumbers == null || fpFieldNumbers.length == 0) {
            nonfpFieldNumbers = this.cmd.getAllMemberPositions();
        } else {
            int fieldCount = this.cmd.getMemberCount();
            if (fieldCount == fpFieldNumbers.length) {
                return;
            }
            nonfpFieldNumbers = new int[fieldCount - fpFieldNumbers.length];
            int currentFPFieldIndex = 0;
            int j = 0;
            for (int i = 0; i < fieldCount; ++i) {
                if (currentFPFieldIndex >= fpFieldNumbers.length) {
                    nonfpFieldNumbers[j++] = i;
                    continue;
                }
                if (fpFieldNumbers[currentFPFieldIndex] == i) {
                    ++currentFPFieldIndex;
                    continue;
                }
                nonfpFieldNumbers[j++] = i;
            }
        }
        for (int i = 0; i < nonfpFieldNumbers.length; ++i) {
            this.loadedFields[nonfpFieldNumbers[i]] = false;
        }
    }

    public void loadFieldFromDatastore(int fieldNumber) {
        this.loadFieldsFromDatastore(new int[]{fieldNumber});
    }

    private void loadFieldsFromDatastore(int[] fieldNumbers) {
        if (this.myLC.isNew() && this.myLC.isPersistent() && !this.isFlushedNew()) {
            return;
        }
        if ((this.flags & 0x8000) != 0) {
            String className = this.myEC.getStoreManager().getClassNameForObjectID(this.myID, this.myEC.getClassLoaderResolver(), this.myEC);
            if (!this.myPC.getClass().getName().equals(className)) {
                this.myEC.removeObjectFromLevel1Cache(this.myID);
                this.myEC.removeObjectFromLevel2Cache(this.myID);
                throw new NucleusObjectNotFoundException("Object with id " + this.myID + " was created without validating of type " + this.myPC.getClass().getName() + " but is actually of type " + className);
            }
            this.flags &= 0xFFFF7FFF;
        }
        this.myEC.getStoreManager().getPersistenceHandler().fetchObject(this, fieldNumbers);
    }

    public boolean isLoaded(int fieldNumber) {
        return this.isLoaded(this.myPC, fieldNumber);
    }

    public boolean isLoaded(PersistenceCapable pc, int fieldNumber) {
        try {
            if (this.disconnectClone(pc)) {
                return true;
            }
            boolean checkRead = true;
            boolean beingDeleted = false;
            if (this.myLC.isDeleted() && this.myEC.isFlushing() || this.activity == ActivityState.DELETING) {
                checkRead = false;
                beingDeleted = true;
            }
            if (checkRead) {
                this.transitionReadField(this.loadedFields[fieldNumber]);
            }
            if (!this.loadedFields[fieldNumber]) {
                if (this.pcObjectType != 0) {
                    return true;
                }
                if (beingDeleted && this.preDeleteLoadedFields != null && this.preDeleteLoadedFields[fieldNumber]) {
                    return true;
                }
                if (!beingDeleted && this.myFP.hasMember(fieldNumber)) {
                    this.loadUnloadedFieldsInFetchPlan();
                } else {
                    this.loadSpecifiedFields(new int[]{fieldNumber});
                }
            }
            return true;
        }
        catch (NucleusException ne) {
            NucleusLogger.PERSISTENCE.warn("Exception thrown by StateManager.isLoaded", ne);
            throw this.myEC.getApiAdapter().getApiExceptionForNucleusException(ne);
        }
    }

    public void replaceFieldValue(int fieldNumber, Object newValue) {
        if (this.myLC.isDeleted()) {
            return;
        }
        boolean currentWasDirty = this.preWriteField(fieldNumber);
        this.replaceField(this.myPC, fieldNumber, newValue, true);
        this.postWriteField(currentWasDirty);
    }

    public void replaceField(int fieldNumber, Object value) {
        this.replaceField(this.myPC, fieldNumber, value, false);
    }

    public void replaceFieldMakeDirty(int fieldNumber, Object value) {
        this.replaceField(this.myPC, fieldNumber, value, true);
    }

    protected void replaceField(PersistenceCapable pc, int fieldNumber, Object value, boolean makeDirty) {
        if (this.embeddedOwners != null) {
            for (EmbeddedOwnerRelation owner : this.embeddedOwners) {
                Object ownerField;
                JDOStateManager ownerSM = owner.sm;
                if (ownerSM == null || ownerSM.cmd == null) continue;
                AbstractMemberMetaData ownerMmd = ownerSM.cmd.getMetaDataForManagedMemberAtAbsolutePosition(owner.fieldNumber);
                if (ownerMmd.getCollection() != null) {
                    ownerField = ownerSM.provideField(owner.fieldNumber);
                    if (!(ownerField instanceof SCOCollection)) continue;
                    ((SCOCollection)ownerField).updateEmbeddedElement(this.myPC, fieldNumber, value);
                    continue;
                }
                if (ownerMmd.getMap() != null) {
                    ownerField = ownerSM.provideField(owner.fieldNumber);
                    if (!(ownerField instanceof SCOMap)) continue;
                    if (this.pcObjectType == 3) {
                        ((SCOMap)ownerField).updateEmbeddedKey(this.myPC, fieldNumber, value);
                    }
                    if (this.pcObjectType != 4) continue;
                    ((SCOMap)ownerField).updateEmbeddedValue(this.myPC, fieldNumber, value);
                    continue;
                }
                if ((ownerSM.flags & 0x100) != 0) continue;
                if (makeDirty) {
                    ownerSM.replaceFieldMakeDirty(owner.fieldNumber, pc);
                    continue;
                }
                ownerSM.replaceField(owner.fieldNumber, pc);
            }
        }
        if (this.embeddedOwners == null && makeDirty && !this.myLC.isDeleted() && this.myEC.getTransaction().isActive()) {
            boolean wasDirty = this.preWriteField(fieldNumber);
            super.replaceField(pc, fieldNumber, value);
            this.postWriteField(wasDirty);
        } else {
            super.replaceField(pc, fieldNumber, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceFields(int[] fieldNumbers, FieldManager fm, boolean replaceWhenDirty) {
        try {
            if (this.myEC.getMultithreaded()) {
                this.myEC.getLock().lock();
                this.lock.lock();
            }
            FieldManager prevFM = this.currFM;
            this.currFM = fm;
            try {
                int[] fieldsToReplace = fieldNumbers;
                if (!replaceWhenDirty) {
                    int numberToReplace = fieldNumbers.length;
                    for (int i = 0; i < fieldNumbers.length; ++i) {
                        if (!this.dirtyFields[fieldNumbers[i]]) continue;
                        --numberToReplace;
                    }
                    if (numberToReplace > 0 && numberToReplace != fieldNumbers.length) {
                        fieldsToReplace = new int[numberToReplace];
                        int n = 0;
                        for (int i = 0; i < fieldNumbers.length; ++i) {
                            if (this.dirtyFields[fieldNumbers[i]]) continue;
                            fieldsToReplace[n++] = fieldNumbers[i];
                        }
                    } else if (numberToReplace == 0) {
                        fieldsToReplace = null;
                    }
                }
                if (fieldsToReplace != null) {
                    this.myPC.jdoReplaceFields(fieldsToReplace);
                }
                Object var10_9 = null;
                this.currFM = prevFM;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                this.currFM = prevFM;
                throw throwable;
            }
            Object var12_12 = null;
            if (this.myEC.getMultithreaded()) {
                this.lock.unlock();
                this.myEC.getLock().unlock();
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (this.myEC.getMultithreaded()) {
                this.lock.unlock();
                this.myEC.getLock().unlock();
            }
            throw throwable;
        }
    }

    public void replaceFields(int[] fieldNumbers, FieldManager fm) {
        this.replaceFields(fieldNumbers, fm, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceNonLoadedFields(int[] fieldNumbers, FieldManager fm) {
        try {
            if (this.myEC.getMultithreaded()) {
                this.myEC.getLock().lock();
                this.lock.lock();
            }
            FieldManager prevFM = this.currFM;
            this.currFM = fm;
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            try {
                int[] fieldsToReplace = ClassUtils.getFlagsSetTo(this.loadedFields, fieldNumbers, false);
                if (fieldsToReplace != null && fieldsToReplace.length > 0) {
                    this.myPC.jdoReplaceFields(fieldsToReplace);
                }
                Object var7_6 = null;
                this.currFM = prevFM;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.currFM = prevFM;
                throw throwable;
            }
            if (callPostLoad && this.areFieldsLoaded(this.myFP.getMemberNumbers())) {
                this.postLoad();
            }
            Object var9_9 = null;
            if (this.myEC.getMultithreaded()) {
                this.lock.unlock();
                this.myEC.getLock().unlock();
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (this.myEC.getMultithreaded()) {
                this.lock.unlock();
                this.myEC.getLock().unlock();
            }
            throw throwable;
        }
    }

    public void addEmbeddedOwner(ObjectProvider ownerSM, int ownerFieldNumber) {
        if (ownerSM == null) {
            return;
        }
        if (this.embeddedOwners == null) {
            this.embeddedOwners = new ArrayList<EmbeddedOwnerRelation>(1);
        }
        this.embeddedOwners.add(new EmbeddedOwnerRelation((JDOStateManager)ownerSM, ownerFieldNumber));
    }

    public void removeEmbeddedOwner(JDOStateManager ownerSM, int ownerFieldNumber) {
        if (this.embeddedOwners != null) {
            Iterator<EmbeddedOwnerRelation> iter = this.embeddedOwners.iterator();
            while (iter.hasNext()) {
                EmbeddedOwnerRelation relation = iter.next();
                if (relation.sm != ownerSM || relation.fieldNumber != ownerFieldNumber) continue;
                iter.remove();
                break;
            }
            if (this.embeddedOwners.isEmpty()) {
                this.embeddedOwners = null;
            }
        }
    }

    public ObjectProvider[] getEmbeddedOwners() {
        if (this.embeddedOwners == null) {
            return null;
        }
        ObjectProvider[] owners = new JDOStateManager[this.embeddedOwners.size()];
        for (int i = 0; i < owners.length; ++i) {
            EmbeddedOwnerRelation relation = this.embeddedOwners.get(i);
            owners[i] = relation.sm;
        }
        return owners;
    }

    public boolean isEmbedded() {
        return this.pcObjectType > 0;
    }

    public void setPcObjectType(short embeddedType) {
        this.pcObjectType = embeddedType;
    }

    public void replaceAllLoadedSCOFieldsWithWrappers() {
        boolean[] scoMutableFieldFlags = this.cmd.getSCOMutableMemberFlags();
        for (int i = 0; i < scoMutableFieldFlags.length; ++i) {
            Object value;
            if (!scoMutableFieldFlags[i] || !this.loadedFields[i] || (value = this.provideField(i)) instanceof SCO) continue;
            this.wrapSCOField(i, value, false, false, true);
        }
    }

    public void replaceAllLoadedSCOFieldsWithValues() {
        boolean[] scoMutableFieldFlags = this.cmd.getSCOMutableMemberFlags();
        for (int i = 0; i < scoMutableFieldFlags.length; ++i) {
            Object value;
            if (!scoMutableFieldFlags[i] || !this.loadedFields[i] || !((value = this.provideField(i)) instanceof SCO)) continue;
            this.unwrapSCOField(i, value, true);
        }
    }

    public Object unwrapSCOField(int fieldNumber, Object value, boolean replaceFieldIfChanged) {
        if (value == null) {
            return value;
        }
        if (this.cmd.getSCOMutableMemberFlags()[fieldNumber] && value instanceof SCO) {
            SCO sco = (SCO)value;
            Object unwrappedValue = sco.getValue();
            if (replaceFieldIfChanged) {
                AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026030", (Object)StringUtils.toJVMIDString(this.myPC), (Object)IdentityUtils.getIdentityAsString(this.myEC.getApiAdapter(), this.myID), (Object)fmd.getName()));
                }
                this.replaceField(this.myPC, fieldNumber, unwrappedValue, false);
            }
            return unwrappedValue;
        }
        return value;
    }

    public Object wrapSCOField(int fieldNumber, Object value, boolean forInsert, boolean forUpdate, boolean replaceFieldIfChanged) {
        AbstractMemberMetaData fmd;
        if (value == null) {
            return value;
        }
        if (value instanceof PersistenceCapable && (fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber)).getEmbeddedMetaData() != null && fmd.getEmbeddedMetaData().getOwnerMember() != null) {
            JDOStateManager subSM = (JDOStateManager)this.myEC.findObjectProvider(value);
            int ownerAbsFieldNum = subSM.cmd.getAbsolutePositionOfMember(fmd.getEmbeddedMetaData().getOwnerMember());
            if (ownerAbsFieldNum >= 0) {
                this.flags |= 0x100;
                subSM.replaceFieldMakeDirty(ownerAbsFieldNum, this.myPC);
                this.flags &= 0xFFFFFEFF;
            }
        }
        if (this.cmd.getSCOMutableMemberFlags()[fieldNumber] && (!(value instanceof SCO) || this.myPC != ((SCO)value).getOwner())) {
            fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            if (replaceFieldIfChanged && NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026029", (Object)StringUtils.toJVMIDString(this.myPC), this.myEC != null ? IdentityUtils.getIdentityAsString(this.myEC.getApiAdapter(), this.myID) : this.myID, (Object)fmd.getName()));
            }
            return SCOUtils.newSCOInstance(this, fmd, fmd.getType(), value.getClass(), value, forInsert, forUpdate, replaceFieldIfChanged);
        }
        return value;
    }

    public void runReachability(Set reachables) {
        if (reachables == null) {
            return;
        }
        if (!reachables.contains(this.getInternalObjectId())) {
            this.flush();
            if (this.isDeleted(this.myPC)) {
                return;
            }
            if (this.myEC.isEnlistedInTransaction(this.getInternalObjectId())) {
                this.loadUnloadedFields();
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("007000", (Object)StringUtils.toJVMIDString(this.myPC), this.getObjectId(this.myPC), (Object)this.myLC));
            }
            reachables.add(this.getInternalObjectId());
            int[] loadedFieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, this.cmd.getAllMemberPositions(), true);
            if (loadedFieldNumbers != null && loadedFieldNumbers.length > 0) {
                this.provideFields(loadedFieldNumbers, new ReachabilityFieldManager(this, reachables));
            }
        }
    }

    public void makePersistent() {
        if (this.myLC.isDeleted() && !this.myEC.getNucleusContext().getApiAdapter().allowPersistOfDeletedObject()) {
            return;
        }
        if (this.activity != ActivityState.NONE) {
            return;
        }
        if (this.dirty && !this.myLC.isDeleted() && this.myLC.isTransactional() && this.myEC.isDelayDatastoreOperationsEnabled()) {
            if (this.cmd.hasRelations(this.myEC.getClassLoaderResolver(), this.myEC.getMetaDataManager())) {
                this.provideFields(this.cmd.getAllMemberPositions(), new PersistFieldManager(this, false));
            }
            return;
        }
        this.getCallbackHandler().prePersist(this.myPC);
        if (this.isFlushedNew()) {
            this.registerTransactional();
            return;
        }
        if (this.cmd.isEmbeddedOnly()) {
            return;
        }
        if (this.myID == null) {
            this.setIdentity(false);
        }
        this.dirty = true;
        if (this.myEC.isDelayDatastoreOperationsEnabled()) {
            this.myEC.markDirty(this, false);
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026028", (Object)StringUtils.toJVMIDString(this.myPC)));
            }
            this.registerTransactional();
            if (this.myLC.isTransactional() && this.myLC.isDeleted()) {
                this.myLC = this.myLC.transitionMakePersistent(this);
            }
            if (this.cmd.hasRelations(this.myEC.getClassLoaderResolver(), this.myEC.getMetaDataManager())) {
                this.provideFields(this.cmd.getAllMemberPositions(), new PersistFieldManager(this, false));
            }
        } else {
            this.internalMakePersistent();
            this.registerTransactional();
        }
    }

    private void internalMakePersistent() {
        this.activity = ActivityState.INSERTING;
        boolean[] tmpDirtyFields = (boolean[])this.dirtyFields.clone();
        try {
            block5: {
                try {
                    this.getCallbackHandler().preStore(this.myPC);
                    if (this.myID == null) {
                        this.setIdentity(true);
                    }
                    this.clearDirtyFlags();
                    this.myEC.getStoreManager().getPersistenceHandler().insertObject(this);
                    this.setFlushedNew(true);
                    this.getCallbackHandler().postStore(this.myPC);
                    if (this.isEmbedded()) break block5;
                    this.myEC.putObjectIntoLevel1Cache(this);
                }
                catch (NotYetFlushedException ex) {
                    this.dirtyFields = tmpDirtyFields;
                    this.myEC.markDirty(this, false);
                    this.dirty = true;
                    throw ex;
                }
            }
            Object var4_2 = null;
            this.activity = ActivityState.NONE;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.activity = ActivityState.NONE;
            throw throwable;
        }
    }

    public boolean isInserting() {
        return this.activity == ActivityState.INSERTING;
    }

    public boolean isDeleting() {
        return this.activity == ActivityState.DELETING;
    }

    public boolean isWaitingToBeFlushedToDatastore() {
        return this.myLC.stateType() == 1 && !this.isFlushedNew();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeTransactional() {
        this.preStateChange();
        try {
            if (this.myLC == null) {
                JDOStateManager thisSM = this;
                this.myLC = this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(5);
                try {
                    if (this.myLC.isPersistent()) {
                        this.myEC.addObjectProvider(this);
                    }
                    this.replaceStateManager(this.myPC, thisSM);
                }
                catch (SecurityException e) {
                    throw new NucleusUserException(e.getMessage());
                }
                catch (NucleusException ne) {
                    if (this.myEC.findObjectProvider(this.myEC.getObjectFromCache(this.myID)) == this) {
                        this.myEC.removeObjectProvider(this);
                    }
                    throw ne;
                }
                this.setRestoreValues(true);
            } else {
                this.myLC = this.myLC.transitionMakeTransactional(this, true);
            }
            Object var4_4 = null;
            this.postStateChange();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.postStateChange();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeTransient(FetchPlanState state) {
        if ((this.flags & 8) != 0) {
            return;
        }
        try {
            this.flags |= 8;
            if (state == null) {
                int[] fieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, this.cmd.getSCOMutableMemberPositions(), true);
                if (fieldNumbers != null && fieldNumbers.length > 0) {
                    this.provideFields(fieldNumbers, new UnsetOwnerFieldManager());
                }
            } else {
                this.loadUnloadedFieldsInFetchPlan();
                int[] fieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, this.cmd.getAllMemberPositions(), true);
                if (fieldNumbers != null && fieldNumbers.length > 0) {
                    this.replaceFields(fieldNumbers, new MakeTransientFieldManager(this, this.cmd.getSCOMutableMemberFlags(), this.myFP, state));
                }
            }
            this.preStateChange();
            try {
                this.myLC = this.myLC.transitionMakeTransient(this, state != null, this.myEC.isRunningDetachAllOnCommit());
                Object var4_4 = null;
                this.postStateChange();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.postStateChange();
                throw throwable;
            }
            Object var6_7 = null;
            this.flags &= 0xFFFFFFF7;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.flags &= 0xFFFFFFF7;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(FetchPlanState state) {
        if (this.myEC == null) {
            return;
        }
        ApiAdapter api = this.myEC.getApiAdapter();
        if (this.myLC.isDeleted() || api.isDetached(this.myPC) || (this.flags & 0x10) != 0) {
            return;
        }
        boolean detachable = api.isDetachable(this.myPC);
        if (detachable) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010009", (Object)StringUtils.toJVMIDString(this.myPC), (Object)("" + state.getCurrentFetchDepth())));
            }
            this.getCallbackHandler().preDetach(this.myPC);
        }
        try {
            this.flags |= 0x10;
            String detachedState = this.myEC.getNucleusContext().getPersistenceConfiguration().getStringProperty("datanucleus.detachedState");
            if (detachedState.equalsIgnoreCase("all")) {
                this.loadUnloadedFields();
            } else if (!detachedState.equalsIgnoreCase("loaded")) {
                if ((this.myEC.getFetchPlan().getDetachmentOptions() & 1) != 0) {
                    this.loadUnloadedFieldsInFetchPlan();
                }
                if ((this.myEC.getFetchPlan().getDetachmentOptions() & 2) != 0) {
                    this.unloadNonFetchPlanFields();
                    int[] unloadedFields = ClassUtils.getFlagsSetTo(this.loadedFields, this.cmd.getAllMemberPositions(), false);
                    if (unloadedFields != null && unloadedFields.length > 0) {
                        PersistenceCapable dummyPC = this.myPC.jdoNewInstance((StateManager)this);
                        this.myPC.jdoCopyFields((Object)dummyPC, unloadedFields);
                        this.replaceStateManager(dummyPC, null);
                    }
                }
            }
            DetachFieldManager detachFieldManager = new DetachFieldManager(this, this.cmd.getSCOMutableMemberFlags(), this.myFP, state, false);
            for (int i = 0; i < this.loadedFields.length; ++i) {
                if (!this.loadedFields[i]) continue;
                try {
                    detachFieldManager.fetchObjectField(i);
                    continue;
                }
                catch (AbstractFetchDepthFieldManager.EndOfFetchPlanGraphException eofpge) {
                    Object value = this.provideField(i);
                    if (!api.isPersistable(value)) continue;
                    JDOStateManager valueSM = (JDOStateManager)this.myEC.findObjectProvider(value);
                    if (api.isDetached(value) || valueSM != null && valueSM.isDetaching()) continue;
                    String fieldName = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(i).getName();
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026032", (Object)StringUtils.toJVMIDString(this.myPC), (Object)IdentityUtils.getIdentityAsString(this.myEC.getApiAdapter(), this.myID), (Object)fieldName));
                    }
                    this.unloadField(fieldName);
                }
            }
            if (detachable) {
                this.myLC = this.myLC.transitionDetach(this);
                this.myPC.jdoReplaceFlags();
                ((Detachable)this.myPC).jdoReplaceDetachedState();
                this.getCallbackHandler().postDetach(this.myPC, this.myPC);
                PersistenceCapable toCheckPC = this.myPC;
                Object toCheckID = this.myID;
                this.disconnect();
                if (!toCheckPC.jdoIsDetached()) {
                    throw new NucleusUserException(LOCALISER.msg("026025", (Object)toCheckPC.getClass().getName(), toCheckID));
                }
            } else {
                NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("026031", (Object)this.myPC.getClass().getName(), (Object)IdentityUtils.getIdentityAsString(this.myEC.getApiAdapter(), this.myID)));
                this.makeTransient(null);
            }
            Object var12_14 = null;
            this.flags &= 0xFFFFFFEF;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            this.flags &= 0xFFFFFFEF;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object detachCopy(FetchPlanState state) {
        PersistenceCapable detachedPC;
        if (this.myLC.isDeleted()) {
            throw new NucleusUserException(LOCALISER.msg("026023", (Object)this.myPC.getClass().getName(), this.myID));
        }
        if (this.myEC.getApiAdapter().isDetached(this.myPC)) {
            throw new NucleusUserException(LOCALISER.msg("026024", (Object)this.myPC.getClass().getName(), this.myID));
        }
        if (this.dirty) {
            this.myEC.flushInternal(false);
        }
        if ((this.flags & 0x10) != 0) {
            return this.referencedPC;
        }
        DetachState detachState = (DetachState)state;
        DetachState.Entry existingDetached = detachState.getDetachedCopyEntry(this.myPC);
        if (existingDetached == null) {
            detachedPC = this.myPC.jdoNewInstance((StateManager)this);
            detachState.setDetachedCopyEntry(this.myPC, detachedPC);
        } else {
            detachedPC = (PersistenceCapable)existingDetached.getDetachedCopyObject();
            if (existingDetached.checkCurrentState()) {
                return detachedPC;
            }
        }
        this.referencedPC = detachedPC;
        boolean detachable = this.myEC.getApiAdapter().isDetachable(this.myPC);
        PersistenceCapable persistenceCapable = this.referencedPC;
        synchronized (persistenceCapable) {
            int[] detachFieldNums = this.getFieldsNumbersToDetach();
            if (detachable) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    int[] fieldsToLoad = null;
                    if ((this.myEC.getFetchPlan().getDetachmentOptions() & 1) != 0) {
                        fieldsToLoad = ClassUtils.getFlagsSetTo(this.loadedFields, this.myFP.getMemberNumbers(), false);
                    }
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010010", (Object)StringUtils.toJVMIDString(this.myPC), (Object)("" + state.getCurrentFetchDepth()), (Object)StringUtils.toJVMIDString(detachedPC), (Object)StringUtils.intArrayToString(detachFieldNums), (Object)StringUtils.intArrayToString(fieldsToLoad)));
                }
                this.getCallbackHandler().preDetach(this.myPC);
            }
            try {
                try {
                    this.flags |= 0x10;
                    if ((this.myEC.getFetchPlan().getDetachmentOptions() & 1) != 0) {
                        this.loadUnloadedFieldsInFetchPlan();
                    }
                    if (this.myLC == this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(4) || this.myLC == this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(9)) {
                        this.myLC = this.myLC.transitionReadField(this, true);
                    }
                    JDOStateManager smDetachedPC = new JDOStateManager(this.myEC, this.cmd);
                    smDetachedPC.initialiseForDetached(detachedPC, this.getExternalObjectId(this.myPC), this.getVersion(this.myPC));
                    smDetachedPC.referencedPC = this.myPC;
                    if (existingDetached != null) {
                        smDetachedPC.retrieveDetachState(smDetachedPC);
                    }
                    smDetachedPC.replaceFields(detachFieldNums, new DetachFieldManager(this, this.cmd.getSCOMutableMemberFlags(), this.myFP, state, true));
                    smDetachedPC.referencedPC = null;
                    if (detachable) {
                        detachedPC.jdoReplaceFlags();
                        ((Detachable)detachedPC).jdoReplaceDetachedState();
                    } else {
                        smDetachedPC.makeTransient(null);
                    }
                    this.replaceStateManager(detachedPC, null);
                }
                catch (Exception e) {
                    NucleusLogger.PERSISTENCE.warn("DETACH ERROR : Error thrown while detaching " + StringUtils.toJVMIDString(this.myPC) + " (id=" + this.myID + "). Provide a testcase that demonstrates this", e);
                    Object var10_11 = null;
                    this.flags &= 0xFFFFFFEF;
                    this.referencedPC = null;
                }
                Object var10_10 = null;
                this.flags &= 0xFFFFFFEF;
                this.referencedPC = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                this.flags &= 0xFFFFFFEF;
                this.referencedPC = null;
                throw throwable;
            }
            if (detachable && !this.myEC.getApiAdapter().isDetached(detachedPC)) {
                throw new NucleusUserException(LOCALISER.msg("026025", (Object)detachedPC.getClass().getName(), this.myID));
            }
            if (detachable) {
                this.getCallbackHandler().postDetach(this.myPC, detachedPC);
            }
        }
        return detachedPC;
    }

    private int[] getFieldsNumbersToDetach() {
        String detachedState = this.myEC.getNucleusContext().getPersistenceConfiguration().getStringProperty("datanucleus.detachedState");
        if (detachedState.equalsIgnoreCase("all")) {
            return this.cmd.getAllMemberPositions();
        }
        if (detachedState.equalsIgnoreCase("loaded")) {
            return this.getLoadedFieldNumbers();
        }
        if ((this.myEC.getFetchPlan().getDetachmentOptions() & 2) == 0) {
            if ((this.myEC.getFetchPlan().getDetachmentOptions() & 1) == 0) {
                return this.getLoadedFieldNumbers();
            }
            int[] fieldsToDetach = this.myFP.getMemberNumbers();
            int[] allFieldNumbers = this.cmd.getAllMemberPositions();
            int[] loadedFieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, allFieldNumbers, true);
            if (loadedFieldNumbers != null && loadedFieldNumbers.length > 0) {
                int i;
                boolean[] flds = new boolean[allFieldNumbers.length];
                for (i = 0; i < fieldsToDetach.length; ++i) {
                    flds[fieldsToDetach[i]] = true;
                }
                for (i = 0; i < loadedFieldNumbers.length; ++i) {
                    flds[loadedFieldNumbers[i]] = true;
                }
                fieldsToDetach = ClassUtils.getFlagsSetTo(flds, true);
            }
            return fieldsToDetach;
        }
        if ((this.myEC.getFetchPlan().getDetachmentOptions() & 1) == 0) {
            return ClassUtils.getFlagsSetTo(this.loadedFields, this.myFP.getMemberNumbers(), true);
        }
        return this.myFP.getMemberNumbers();
    }

    public Object getReferencedPC() {
        return this.referencedPC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(Object trans) {
        if ((this.flags & 0x20) != 0) {
            return;
        }
        this.flags |= 0x20;
        try {
            this.getCallbackHandler().preAttach(this.myPC);
            JDOStateManager detachedSM = new JDOStateManager(this.myEC, this.cmd);
            detachedSM.initialiseForDetached(trans, this.myID, null);
            this.myEC.putObjectIntoLevel1Cache(this);
            int[] nonPKFieldNumbers = this.cmd.getNonPKMemberPositions();
            if (nonPKFieldNumbers != null && nonPKFieldNumbers.length > 0) {
                NucleusLogger.GENERAL.debug("Attaching id=" + this.getInternalObjectId() + " fields=" + StringUtils.intArrayToString(nonPKFieldNumbers));
                detachedSM.provideFields(nonPKFieldNumbers, new AttachFieldManager(this, this.cmd.getSCOMutableMemberFlags(), this.cmd.getNonPKMemberFlags(), true, true, false));
            }
            this.replaceStateManager((PersistenceCapable)trans, null);
            this.getCallbackHandler().postAttach(this.myPC, this.myPC);
            Object var5_4 = null;
            this.flags &= 0xFFFFFFDF;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.flags &= 0xFFFFFFDF;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(boolean embedded) {
        if ((this.flags & 0x20) != 0) {
            return;
        }
        this.flags |= 0x20;
        try {
            boolean persistent = false;
            if (embedded) {
                persistent = true;
            } else if (!this.myEC.getNucleusContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.attachSameDatastore")) {
                try {
                    this.locate();
                    persistent = true;
                }
                catch (NucleusObjectNotFoundException onfe) {}
            } else {
                persistent = true;
            }
            this.getCallbackHandler().preAttach(this.myPC);
            this.replaceStateManager(this.myPC, this);
            this.retrieveDetachState(this);
            if (!persistent) {
                this.makePersistent();
            }
            this.myLC = this.myLC.transitionAttach(this);
            this.myEC.putObjectIntoLevel1Cache(this);
            int[] attachFieldNumbers = this.getFieldNumbersOfLoadedOrDirtyFields(this.loadedFields, this.dirtyFields);
            if (attachFieldNumbers != null) {
                NucleusLogger.GENERAL.debug("Attaching id=" + this.getInternalObjectId() + " fields=" + StringUtils.intArrayToString(attachFieldNumbers));
                this.provideFields(attachFieldNumbers, new AttachFieldManager(this, this.cmd.getSCOMutableMemberFlags(), this.dirtyFields, persistent, true, false));
            }
            this.getCallbackHandler().postAttach(this.myPC, this.myPC);
            Object var5_5 = null;
            this.flags &= 0xFFFFFFDF;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.flags &= 0xFFFFFFDF;
            throw throwable;
        }
    }

    public Object attachCopy(Object obj, boolean embedded) {
        if ((this.flags & 0x20) != 0) {
            return this.myPC;
        }
        this.flags |= 0x20;
        PersistenceCapable detachedPC = (PersistenceCapable)obj;
        try {
            try {
                int[] unloadedFieldNumbers;
                int[] noncontainerFieldNumbers;
                int[] fieldNumbers;
                boolean persistent = false;
                if (embedded) {
                    persistent = true;
                } else if (!this.myEC.getNucleusContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.attachSameDatastore")) {
                    try {
                        this.locate();
                        persistent = true;
                    }
                    catch (NucleusObjectNotFoundException onfe) {}
                } else {
                    persistent = true;
                }
                this.getCallbackHandler().preAttach(detachedPC);
                if (this.myEC.getApiAdapter().isDeleted(detachedPC)) {
                    this.myLC = this.myLC.transitionDeletePersistent(this);
                }
                if (!(this.myEC.getTransaction().getOptimistic() || this.myLC != this.myEC.getApiAdapter().getLifeCycleState(4) && this.myLC != this.myEC.getApiAdapter().getLifeCycleState(9))) {
                    this.myLC = this.myLC.transitionMakeTransactional(this, persistent);
                }
                if (persistent && (fieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, noncontainerFieldNumbers = this.cmd.getSCONonContainerMemberPositions(), false)) != null && fieldNumbers.length > 0 && (unloadedFieldNumbers = this.loadFieldsFromLevel2Cache(fieldNumbers)) != null) {
                    this.loadFieldsFromDatastore(unloadedFieldNumbers);
                    this.updateLevel2CacheForFields(unloadedFieldNumbers);
                }
                JDOStateManager smDetachedPC = new JDOStateManager(this.myEC, this.cmd);
                smDetachedPC.initialiseForDetached(detachedPC, this.getExternalObjectId(detachedPC), null);
                smDetachedPC.referencedPC = this.myPC;
                this.referencedPC = detachedPC;
                this.retrieveDetachState(smDetachedPC);
                if (!persistent) {
                    this.internalAttachCopy(smDetachedPC, smDetachedPC.loadedFields, smDetachedPC.dirtyFields, persistent, smDetachedPC.myVersion, false);
                    this.makePersistent();
                }
                this.internalAttachCopy(smDetachedPC, smDetachedPC.loadedFields, smDetachedPC.dirtyFields, persistent, smDetachedPC.myVersion, true);
                this.replaceStateManager(detachedPC, null);
                smDetachedPC.referencedPC = null;
                this.referencedPC = null;
                this.getCallbackHandler().postAttach(this.myPC, detachedPC);
            }
            catch (NucleusException ne) {
                NucleusLogger.PERSISTENCE.debug("Unexpected exception thrown in attach", ne);
                throw ne;
            }
            Object var9_10 = null;
            this.flags &= 0xFFFFFFDF;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.flags &= 0xFFFFFFDF;
            throw throwable;
        }
        return this.myPC;
    }

    private void internalAttachCopy(ObjectProvider detachedOP, boolean[] loadedFields, boolean[] dirtyFields, boolean persistent, Object version, boolean cascade) {
        int[] attachFieldNumbers = this.getFieldNumbersOfLoadedOrDirtyFields(loadedFields, dirtyFields);
        this.setVersion(version);
        if (attachFieldNumbers != null) {
            NucleusLogger.GENERAL.debug("Attaching id=" + this.getInternalObjectId() + " fields=" + StringUtils.intArrayToString(attachFieldNumbers));
            detachedOP.provideFields(attachFieldNumbers, new AttachFieldManager(this, this.cmd.getSCOMutableMemberFlags(), dirtyFields, persistent, cascade, true));
        }
    }

    private int[] getFieldNumbersOfLoadedOrDirtyFields(boolean[] loadedFields, boolean[] dirtyFields) {
        int numFields = 0;
        for (int i = 0; i < loadedFields.length; ++i) {
            if (!loadedFields[i] && !dirtyFields[i]) continue;
            ++numFields;
        }
        int[] fieldNumbers = new int[numFields];
        int n = 0;
        int[] allFieldNumbers = this.cmd.getAllMemberPositions();
        for (int i = 0; i < loadedFields.length; ++i) {
            if (!loadedFields[i] && !dirtyFields[i]) continue;
            fieldNumbers[n++] = allFieldNumbers[i];
        }
        return fieldNumbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePersistent() {
        if (!this.myLC.isDeleted()) {
            if (this.myEC.isDelayDatastoreOperationsEnabled()) {
                this.getCallbackHandler().preDelete(this.myPC);
                this.myEC.markDirty(this, false);
                if (this.myLC.stateType() == 2 || this.myLC.stateType() == 3 || this.myLC.stateType() == 4 || this.myLC.stateType() == 9 || this.myLC.stateType() == 10) {
                    this.loadUnloadedFields();
                }
                this.flags |= 0x200;
                if (this.cmd.hasRelations(this.myEC.getClassLoaderResolver(), this.myEC.getMetaDataManager())) {
                    this.provideFields(this.cmd.getAllMemberPositions(), new DeleteFieldManager(this));
                }
                this.dirty = true;
                this.preStateChange();
                try {
                    this.preDeleteLoadedFields = new boolean[this.loadedFields.length];
                    for (int i = 0; i < this.preDeleteLoadedFields.length; ++i) {
                        this.preDeleteLoadedFields[i] = this.loadedFields[i];
                    }
                    this.myLC = this.myLC.transitionDeletePersistent(this);
                    Object var3_3 = null;
                    this.flags &= 0xFFFFFDFF;
                    this.postStateChange();
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    this.flags &= 0xFFFFFDFF;
                    this.postStateChange();
                    throw throwable;
                }
            }
            this.getCallbackHandler().preDelete(this.myPC);
            this.dirty = true;
            this.preStateChange();
            try {
                this.preDeleteLoadedFields = new boolean[this.loadedFields.length];
                for (int i = 0; i < this.preDeleteLoadedFields.length; ++i) {
                    this.preDeleteLoadedFields[i] = this.loadedFields[i];
                }
                this.myLC = this.myLC.transitionDeletePersistent(this);
                Object var5_6 = null;
                this.postStateChange();
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.postStateChange();
                throw throwable;
            }
            this.internalDeletePersistent();
            this.getCallbackHandler().postDelete(this.myPC);
        }
    }

    public boolean becomingDeleted() {
        return (this.flags & 0x200) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalDeletePersistent() {
        if (this.isDeleting()) {
            throw new NucleusUserException(LOCALISER.msg("026008"));
        }
        this.activity = ActivityState.DELETING;
        try {
            if (this.dirty) {
                this.clearDirtyFlags();
                this.myEC.flushInternal(false);
            }
            this.myEC.getStoreManager().getPersistenceHandler().deleteObject(this);
            this.preDeleteLoadedFields = null;
            Object var2_1 = null;
            this.activity = ActivityState.NONE;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.activity = ActivityState.NONE;
            throw throwable;
        }
    }

    public void locate() {
        this.myEC.getStoreManager().getPersistenceHandler().locateObject(this);
    }

    public void nullifyFields() {
        if (!this.myLC.isDeleted() && !this.myEC.getApiAdapter().isDetached(this.myPC)) {
            this.replaceFields(this.cmd.getNonPKMemberPositions(), new NullifyRelationFieldManager(this));
            this.flush();
        }
    }

    public void markForInheritanceValidation() {
        this.flags |= 0x8000;
    }

    public void validate() {
        if (!this.myLC.isTransactional()) {
            int[] fieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, this.myFP.getMemberNumbers(), false);
            if (fieldNumbers != null && fieldNumbers.length > 0) {
                fieldNumbers = ClassUtils.getFlagsSetTo(this.cmd.getNonPKMemberFlags(), fieldNumbers, true);
            }
            if (fieldNumbers != null && fieldNumbers.length > 0) {
                fieldNumbers = ClassUtils.getFlagsSetTo(this.cmd.getSCOMutableMemberFlags(), fieldNumbers, false);
            }
            boolean versionNeedsLoading = false;
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                versionNeedsLoading = true;
            }
            if (fieldNumbers != null && fieldNumbers.length > 0 || versionNeedsLoading) {
                this.transitionReadField(false);
                fieldNumbers = this.myFP.getMemberNumbers();
                if (fieldNumbers != null || versionNeedsLoading) {
                    boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
                    this.setTransactionalVersion(null);
                    this.loadFieldsFromDatastore(fieldNumbers);
                    if (callPostLoad) {
                        this.postLoad();
                    }
                }
            } else {
                this.locate();
                this.transitionReadField(false);
            }
        }
    }

    protected boolean preWriteField(int fieldNumber) {
        boolean wasDirty = this.dirty;
        if (this.activity != ActivityState.INSERTING && this.activity != ActivityState.INSERTING_CALLBACKS) {
            if (!wasDirty) {
                this.getCallbackHandler().preDirty(this.myPC);
            }
            this.transitionWriteField();
            this.dirty = true;
            this.dirtyFields[fieldNumber] = true;
            this.loadedFields[fieldNumber] = true;
        }
        return wasDirty;
    }

    protected void postWriteField(boolean wasDirty) {
        if (this.dirty && !wasDirty) {
            this.getCallbackHandler().postDirty(this.myPC);
        }
        if (this.activity == ActivityState.NONE && (this.flags & 4) == 0 && (!this.myLC.isTransactional() || this.myLC.isPersistent())) {
            if ((this.flags & 0x10) != 0 && this.referencedPC == null) {
                return;
            }
            this.myEC.markDirty(this, true);
        }
    }

    protected void preStateChange() {
        this.flags |= 0x800;
    }

    protected void postStateChange() {
        this.flags &= 0xFFFFF7FF;
        if ((this.flags & 0x1000) > 0 && this.areFieldsLoaded(this.myFP.getMemberNumbers())) {
            this.flags &= 0xFFFFEFFF;
            this.postLoad();
        }
    }

    private void postLoad() {
        if ((this.flags & 0x800) > 0) {
            this.flags |= 0x1000;
        } else {
            if (this.jdoDfgFlags == 1 && this.myLC.isTransactional()) {
                this.jdoDfgFlags = (byte)-1;
                this.myPC.jdoReplaceFlags();
            }
            this.getCallbackHandler().postLoad(this.myPC);
        }
    }

    public void setStoringPC() {
        this.flags |= 0x10000;
    }

    public void unsetStoringPC() {
        this.flags &= 0xFFFEFFFF;
    }

    public void preSerialize(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return;
        }
        this.retrieve(false);
        this.myLC = this.myLC.transitionSerialize(this);
        if ((this.flags & 0x10000) == 0 && pc instanceof Detachable && !this.myLC.isDeleted() && this.myLC.isPersistent()) {
            if (this.myLC.isDirty()) {
                this.flush();
            }
            ((Detachable)pc).jdoReplaceDetachedState();
        }
    }

    public void setFlushing(boolean flushing) {
        this.flags = flushing ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    protected boolean isFlushing() {
        return (this.flags & 4) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.dirty) {
            if (this.isFlushing()) {
                return;
            }
            if (this.activity == ActivityState.INSERTING || this.activity == ActivityState.INSERTING_CALLBACKS) {
                return;
            }
            this.setFlushing(true);
            try {
                if (this.myLC.stateType() == 1 && !this.isFlushedNew()) {
                    if (!this.isEmbedded()) {
                        this.internalMakePersistent();
                    } else {
                        this.getCallbackHandler().preStore(this.myPC);
                        if (this.myID == null) {
                            this.setIdentity(true);
                        }
                        this.getCallbackHandler().postStore(this.myPC);
                    }
                    this.dirty = false;
                } else if (this.myLC.stateType() == 8) {
                    this.getCallbackHandler().preDelete(this.myPC);
                    if (!this.isEmbedded()) {
                        this.internalDeletePersistent();
                    }
                    this.getCallbackHandler().postDelete(this.myPC);
                } else if (this.myLC.stateType() == 7) {
                    if (this.isFlushedNew()) {
                        this.getCallbackHandler().preDelete(this.myPC);
                        if (!this.isEmbedded()) {
                            this.internalDeletePersistent();
                        }
                        this.setFlushedNew(false);
                        this.getCallbackHandler().postDelete(this.myPC);
                    } else {
                        this.dirty = false;
                    }
                } else {
                    int[] dirtyFieldNumbers;
                    if (!this.isDeleting()) {
                        this.getCallbackHandler().preStore(this.myPC);
                        if (this.myID == null) {
                            this.setIdentity(true);
                        }
                    }
                    if ((dirtyFieldNumbers = ClassUtils.getFlagsSetTo(this.dirtyFields, true)) == null) {
                        throw new NucleusException(LOCALISER.msg("026010")).setFatal();
                    }
                    if (!this.isEmbedded()) {
                        this.myEC.getStoreManager().getPersistenceHandler().updateObject(this, dirtyFieldNumbers);
                        this.myEC.putObjectIntoLevel1Cache(this);
                    }
                    this.clearDirtyFlags();
                    this.getCallbackHandler().postStore(this.myPC);
                }
                Object var3_2 = null;
                this.setFlushing(false);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.setFlushing(false);
                throw throwable;
            }
        }
    }

    public boolean isFlushedNew() {
        return (this.flags & 0x400) != 0;
    }

    public void setFlushedNew(boolean flag) {
        this.flags = flag ? (this.flags |= 0x400) : (this.flags &= 0xFFFFFBFF);
    }

    public void markAsFlushed() {
        this.clearDirtyFlags();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        int[] fieldNumbers;
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026011", (Object)StringUtils.toJVMIDString(this.myPC), (Object)this));
        }
        if ((this.flags & 0x1000) > 0) {
            this.flags &= 0xFFFFF7FF;
            this.flags &= 0xFFFFEFFF;
            this.postLoad();
        }
        if ((fieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, this.cmd.getSCOMutableMemberPositions(), true)) != null && fieldNumbers.length > 0) {
            this.provideFields(fieldNumbers, new UnsetOwnerFieldManager());
        }
        this.myEC.removeObjectProvider(this);
        this.jdoDfgFlags = 0;
        this.myPC.jdoReplaceFlags();
        this.flags |= 2;
        try {
            this.replaceStateManager(this.myPC, null);
            Object var3_2 = null;
            this.flags &= 0xFFFFFFFD;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.flags &= 0xFFFFFFFD;
            throw throwable;
        }
        this.embeddedOwners = null;
        this.preDeleteLoadedFields = null;
        this.referencedPC = null;
        this.fieldsToBeUpdatedAfterObjectInsertion = null;
        this.insertionNotifyList = null;
        this.pcObjectType = 0;
        super.disconnect();
    }

    public void registerTransactional() {
        this.myEC.addObjectProvider(this);
    }

    private static void dumpPC(PersistenceCapable pc, PrintWriter out) {
        out.println(StringUtils.toJVMIDString(pc));
        if (pc == null) {
            return;
        }
        out.print("jdoStateManager = " + JDOStateManager.peekField(pc, "jdoStateManager"));
        out.print("jdoFlags = ");
        Object flagsObj = JDOStateManager.peekField(pc, "jdoFlags");
        if (flagsObj instanceof Byte) {
            out.println(JDOStateManager.jdoFlagsToString((Byte)flagsObj));
        } else {
            out.println(flagsObj);
        }
        Class<?> c = pc.getClass();
        do {
            String[] fieldNames = HELPER.getFieldNames(c);
            for (int i = 0; i < fieldNames.length; ++i) {
                out.print(fieldNames[i]);
                out.print(" = ");
                out.println(JDOStateManager.peekField(pc, fieldNames[i]));
            }
        } while ((c = c.getSuperclass()) != null && PersistenceCapable.class.isAssignableFrom(c));
    }

    public void dump(PrintWriter out) {
        out.println("myPM = " + this.myEC);
        out.println("myID = " + this.myID);
        out.println("myLC = " + this.myLC);
        out.println("cmd = " + this.cmd);
        out.println("srm = " + this.myEC.getStoreManager());
        out.println("fieldCount = " + this.cmd.getMemberCount());
        out.println("dirty = " + this.dirty);
        out.println("flushing = " + this.isFlushing());
        out.println("changingState = " + ((this.flags & 0x800) != 0));
        out.println("postLoadPending = " + ((this.flags & 0x1000) != 0));
        out.println("disconnecting = " + ((this.flags & 2) != 0));
        out.println("dirtyFields = " + StringUtils.booleanArrayToString(this.dirtyFields));
        out.println("getSecondClassMutableFields() = " + StringUtils.booleanArrayToString(this.cmd.getSCOMutableMemberFlags()));
        out.println("getAllFieldNumbers() = " + StringUtils.intArrayToString(this.cmd.getAllMemberPositions()));
        out.println("secondClassMutableFieldNumbers = " + StringUtils.intArrayToString(this.cmd.getSCOMutableMemberPositions()));
        out.println();
        out.println("jdoFlags = " + JDOStateManager.jdoFlagsToString(this.jdoDfgFlags));
        out.println("loadedFields = " + StringUtils.booleanArrayToString(this.loadedFields));
        out.print("myPC = ");
        JDOStateManager.dumpPC(this.myPC, out);
        out.println();
        out.println("savedFlags = " + JDOStateManager.jdoFlagsToString(this.savedFlags));
        out.println("savedLoadedFields = " + StringUtils.booleanArrayToString(this.savedLoadedFields));
        out.print("savedImage = ");
        JDOStateManager.dumpPC(this.savedImage, out);
    }

    protected static Object peekField(Object obj, String fieldName) {
        try {
            Object value = obj.getClass().getDeclaredField(fieldName).get(obj);
            if (value instanceof PersistenceCapable) {
                return StringUtils.toJVMIDString(value);
            }
            return value;
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    private static String jdoFlagsToString(byte flags) {
        switch (flags) {
            case 1: {
                return "LOAD_REQUIRED";
            }
            case -1: {
                return "READ_OK";
            }
            case 0: {
                return "READ_WRITE_OK";
            }
        }
        return "???";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeActivityState(ActivityState activityState) {
        this.activity = activityState;
        if (activityState == ActivityState.INSERTING_CALLBACKS && this.insertionNotifyList != null) {
            List<JDOStateManager> list = this.insertionNotifyList;
            synchronized (list) {
                for (JDOStateManager notifySM : this.insertionNotifyList) {
                    notifySM.insertionCompleted(this);
                }
            }
            this.insertionNotifyList.clear();
            this.insertionNotifyList = null;
        }
    }

    public void updateFieldAfterInsert(Object pc, int fieldNumber) {
        FieldContainer cont;
        JDOStateManager otherSM = (JDOStateManager)this.myEC.findObjectProvider(pc);
        if (otherSM.insertionNotifyList == null) {
            otherSM.insertionNotifyList = Collections.synchronizedList(new ArrayList(1));
        }
        otherSM.insertionNotifyList.add(this);
        if (this.fieldsToBeUpdatedAfterObjectInsertion == null) {
            this.fieldsToBeUpdatedAfterObjectInsertion = new HashMap<JDOStateManager, FieldContainer>(1);
        }
        if ((cont = this.fieldsToBeUpdatedAfterObjectInsertion.get(otherSM)) == null) {
            cont = new FieldContainer(fieldNumber);
        } else {
            cont.set(fieldNumber);
        }
        this.fieldsToBeUpdatedAfterObjectInsertion.put(otherSM, cont);
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026021", (Object)this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getFullFieldName(), (Object)StringUtils.toJVMIDString(this.myPC), (Object)StringUtils.toJVMIDString(pc)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertionCompleted(JDOStateManager op) {
        if (this.fieldsToBeUpdatedAfterObjectInsertion == null) {
            return;
        }
        FieldContainer fldCont = this.fieldsToBeUpdatedAfterObjectInsertion.get(op);
        if (fldCont != null) {
            this.dirty = true;
            int[] fieldsToUpdate = fldCont.getFields();
            for (int i = 0; i < fieldsToUpdate.length; ++i) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026022", (Object)this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldsToUpdate[i]).getFullFieldName(), (Object)IdentityUtils.getIdentityAsString(this.myEC.getApiAdapter(), this.myID), (Object)StringUtils.toJVMIDString(op.getObject())));
                }
                this.dirtyFields[fieldsToUpdate[i]] = true;
            }
            this.fieldsToBeUpdatedAfterObjectInsertion.remove(op);
            if (this.fieldsToBeUpdatedAfterObjectInsertion.isEmpty()) {
                this.fieldsToBeUpdatedAfterObjectInsertion = null;
            }
            try {
                this.flags |= 0x4000;
                this.flush();
                Object var6_5 = null;
                this.flags &= 0xFFFFBFFF;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.flags &= 0xFFFFBFFF;
                throw throwable;
            }
        }
    }

    private class FieldContainer {
        boolean[] fieldsToUpdate;

        public FieldContainer(int fieldNumber) {
            this.fieldsToUpdate = new boolean[JDOStateManager.this.cmd.getAllMemberPositions().length];
            this.fieldsToUpdate[fieldNumber] = true;
        }

        public void set(int fieldNumber) {
            this.fieldsToUpdate[fieldNumber] = true;
        }

        public int[] getFields() {
            return ClassUtils.getFlagsSetTo(this.fieldsToUpdate, true);
        }
    }

    private static class EmbeddedOwnerRelation {
        private JDOStateManager sm;
        private int fieldNumber;

        public EmbeddedOwnerRelation(JDOStateManager ownerSM, int ownerFieldNumber) {
            this.sm = ownerSM;
            this.fieldNumber = ownerFieldNumber;
        }
    }
}

