/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.state.RelationshipManager;
import org.datanucleus.store.types.SCOCollection;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipManagerImpl
implements RelationshipManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    final ObjectProvider ownerOP;
    final ExecutionContext ec;
    final Object pc;
    final Map<Integer, Object> fieldChanges;

    public RelationshipManagerImpl(ObjectProvider op) {
        this.ownerOP = op;
        this.ec = op.getExecutionContext();
        this.pc = op.getObject();
        this.fieldChanges = new HashMap<Integer, Object>();
    }

    @Override
    public void clearFields() {
        this.fieldChanges.clear();
    }

    @Override
    public void relationChange(int fieldNumber, Object oldValue, Object newValue) {
        block17: {
            ArrayList<RelationChange> changes;
            RelationType relationType;
            AbstractMemberMetaData mmd;
            block18: {
                if (this.ownerOP.getExecutionContext().isManagingRelations()) {
                    return;
                }
                Integer fieldKey = fieldNumber;
                AbstractClassMetaData cmd = this.ownerOP.getClassMetaData();
                mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                relationType = mmd.getRelationType(this.ownerOP.getExecutionContext().getClassLoaderResolver());
                if (relationType == RelationType.ONE_TO_ONE_BI || relationType == RelationType.MANY_TO_ONE_BI) {
                    if (!this.fieldChanges.containsKey(fieldKey)) {
                        this.fieldChanges.put(fieldKey, oldValue);
                    }
                    return;
                }
                changes = (ArrayList<RelationChange>)this.fieldChanges.get(fieldKey);
                if (changes == null) {
                    changes = new ArrayList<RelationChange>();
                    this.fieldChanges.put(fieldKey, changes);
                }
                if (relationType != RelationType.ONE_TO_MANY_BI && relationType != RelationType.MANY_TO_MANY_BI || !mmd.hasCollection()) break block17;
                if (oldValue != null) break block18;
                if (newValue == null) break block17;
                Iterator iter = ((Collection)newValue).iterator();
                while (iter.hasNext()) {
                    changes.add(new RelationChange(ChangeType.ADD_OBJECT, iter.next()));
                }
                break block17;
            }
            if (newValue == null) {
                AbstractMemberMetaData relatedMmd = mmd.getRelatedMemberMetaData(this.ownerOP.getExecutionContext().getClassLoaderResolver())[0];
                for (Object element : (Collection)oldValue) {
                    if (this.ownerOP.getLifecycleState().isDeleted) {
                        this.ownerOP.getExecutionContext().removeObjectFromLevel2Cache(this.ownerOP.getExecutionContext().getApiAdapter().getIdForObject(element));
                        ObjectProvider elementOP = this.ownerOP.getExecutionContext().findObjectProvider(element);
                        if (relationType == RelationType.ONE_TO_MANY_BI) {
                            this.ec.getRelationshipManager(elementOP).relationChange(relatedMmd.getAbsoluteFieldNumber(), this.ownerOP.getObject(), null);
                            continue;
                        }
                        if (relationType != RelationType.MANY_TO_MANY_BI) continue;
                        this.ec.getRelationshipManager(elementOP).relationRemove(relatedMmd.getAbsoluteFieldNumber(), this.ownerOP.getObject());
                        continue;
                    }
                    changes.add(new RelationChange(ChangeType.REMOVE_OBJECT, element));
                }
            } else {
                for (Object newElem : (Collection)newValue) {
                    Iterator oldIter = ((Collection)oldValue).iterator();
                    boolean alreadyExists = false;
                    while (oldIter.hasNext()) {
                        Object oldElem = oldIter.next();
                        if (newElem != oldElem) continue;
                        alreadyExists = true;
                        break;
                    }
                    if (alreadyExists) continue;
                    ObjectProvider elemOP = this.ownerOP.getExecutionContext().findObjectProvider(newElem);
                    if (elemOP != null) {
                        ObjectProvider oldOwnerOP;
                        AbstractMemberMetaData elemMmd = mmd.getRelatedMemberMetaData(this.ownerOP.getExecutionContext().getClassLoaderResolver())[0];
                        Object oldOwner = elemOP.provideField(elemMmd.getAbsoluteFieldNumber());
                        if (!elemOP.isFieldLoaded(elemMmd.getAbsoluteFieldNumber())) {
                            elemOP.loadField(elemMmd.getAbsoluteFieldNumber());
                        }
                        if (oldOwner != null && (oldOwnerOP = this.ownerOP.getExecutionContext().findObjectProvider(oldOwner)) != null) {
                            this.ec.getRelationshipManager(oldOwnerOP).relationRemove(fieldNumber, newElem);
                        }
                    }
                    this.relationAdd(fieldNumber, newElem);
                }
                for (Object oldElem : (Collection)oldValue) {
                    Iterator newIter = ((Collection)newValue).iterator();
                    boolean stillExists = false;
                    while (newIter.hasNext()) {
                        Object newElem = newIter.next();
                        if (oldElem != newElem) continue;
                        stillExists = true;
                        break;
                    }
                    if (stillExists) continue;
                    this.relationRemove(fieldNumber, oldElem);
                }
            }
        }
    }

    @Override
    public void relationAdd(int fieldNumber, Object val) {
        AbstractMemberMetaData relatedMmd;
        if (this.ownerOP.getExecutionContext().isManagingRelations()) {
            return;
        }
        AbstractClassMetaData cmd = this.ownerOP.getClassMetaData();
        AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        RelationType relationType = mmd.getRelationType(this.ownerOP.getExecutionContext().getClassLoaderResolver());
        if (relationType != RelationType.ONE_TO_MANY_BI && relationType != RelationType.MANY_TO_MANY_BI) {
            return;
        }
        ObjectProvider elemOP = this.ownerOP.getExecutionContext().findObjectProvider(val);
        if (elemOP != null && elemOP.isFieldLoaded((relatedMmd = mmd.getRelatedMemberMetaData(this.ownerOP.getExecutionContext().getClassLoaderResolver())[0]).getAbsoluteFieldNumber())) {
            Object currentOwnerId = this.ownerOP.getExecutionContext().getApiAdapter().getIdForObject(elemOP.provideField(relatedMmd.getAbsoluteFieldNumber()));
            this.ownerOP.getExecutionContext().removeObjectFromLevel2Cache(currentOwnerId);
        }
        Integer fieldKey = fieldNumber;
        Object changes = this.fieldChanges.get(fieldKey);
        ArrayList<RelationChange> changeList = null;
        changeList = changes == null ? new ArrayList<RelationChange>() : (ArrayList<RelationChange>)changes;
        RelationChange change = new RelationChange(ChangeType.ADD_OBJECT, val);
        this.ownerOP.getExecutionContext().removeObjectFromLevel2Cache(this.ownerOP.getExecutionContext().getApiAdapter().getIdForObject(val));
        changeList.add(change);
        this.fieldChanges.put(fieldKey, changeList);
    }

    @Override
    public void relationRemove(int fieldNumber, Object val) {
        if (this.ownerOP.getExecutionContext().isManagingRelations()) {
            return;
        }
        AbstractClassMetaData cmd = this.ownerOP.getClassMetaData();
        AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        RelationType relationType = mmd.getRelationType(this.ownerOP.getExecutionContext().getClassLoaderResolver());
        if (relationType != RelationType.ONE_TO_MANY_BI && relationType != RelationType.MANY_TO_MANY_BI) {
            return;
        }
        Integer fieldKey = fieldNumber;
        Object changes = this.fieldChanges.get(fieldKey);
        ArrayList<RelationChange> changeList = null;
        if (changes == null) {
            changeList = new ArrayList<RelationChange>();
            this.fieldChanges.put(fieldKey, changeList);
        } else {
            changeList = (ArrayList<RelationChange>)changes;
        }
        RelationChange change = new RelationChange(ChangeType.REMOVE_OBJECT, val);
        this.ownerOP.getExecutionContext().removeObjectFromLevel2Cache(this.ownerOP.getExecutionContext().getApiAdapter().getIdForObject(val));
        changeList.add(change);
    }

    @Override
    public boolean managesField(int fieldNumber) {
        return this.fieldChanges.containsKey(fieldNumber);
    }

    @Override
    public void checkConsistency() {
        Set<Map.Entry<Integer, Object>> entries = this.fieldChanges.entrySet();
        Iterator<Map.Entry<Integer, Object>> iter = entries.iterator();
        AbstractClassMetaData cmd = this.ownerOP.getClassMetaData();
        ExecutionContext ec = this.ownerOP.getExecutionContext();
        while (iter.hasNext()) {
            List changes;
            Object newValue;
            Map.Entry<Integer, Object> entry = iter.next();
            int fieldNumber = entry.getKey();
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            ClassLoaderResolver clr = ec.getClassLoaderResolver();
            Object oldValue = entry.getValue();
            RelationType relationType = mmd.getRelationType(clr);
            if (relationType == RelationType.ONE_TO_ONE_BI) {
                newValue = this.ownerOP.provideField(fieldNumber);
                this.checkOneToOneBidirectionalRelation(mmd, clr, ec, oldValue, newValue);
                continue;
            }
            if (relationType == RelationType.MANY_TO_ONE_BI) {
                newValue = this.ownerOP.provideField(fieldNumber);
                this.checkManyToOneBidirectionalRelation(mmd, clr, ec, oldValue, newValue);
                continue;
            }
            if (relationType == RelationType.ONE_TO_MANY_BI) {
                changes = (List)oldValue;
                this.checkOneToManyBidirectionalRelation(mmd, clr, ec, changes);
                continue;
            }
            if (relationType != RelationType.MANY_TO_MANY_BI) continue;
            changes = (List)oldValue;
            this.checkManyToManyBidirectionalRelation(mmd, clr, ec, changes);
        }
    }

    @Override
    public void process() {
        Set<Map.Entry<Integer, Object>> entries = this.fieldChanges.entrySet();
        Iterator<Map.Entry<Integer, Object>> iter = entries.iterator();
        AbstractClassMetaData cmd = this.ownerOP.getClassMetaData();
        ExecutionContext ec = this.ownerOP.getExecutionContext();
        while (iter.hasNext()) {
            List changes;
            Object newValue;
            Map.Entry<Integer, Object> entry = iter.next();
            int fieldNumber = entry.getKey();
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            ClassLoaderResolver clr = ec.getClassLoaderResolver();
            Object oldValue = entry.getValue();
            RelationType relationType = mmd.getRelationType(clr);
            if (relationType == RelationType.ONE_TO_ONE_BI) {
                newValue = this.ownerOP.provideField(fieldNumber);
                this.processOneToOneBidirectionalRelation(mmd, clr, ec, oldValue, newValue);
                continue;
            }
            if (relationType == RelationType.MANY_TO_ONE_BI) {
                newValue = this.ownerOP.provideField(fieldNumber);
                this.processManyToOneBidirectionalRelation(mmd, clr, ec, oldValue, newValue);
                continue;
            }
            if (relationType == RelationType.ONE_TO_MANY_BI) {
                changes = (List)oldValue;
                this.processOneToManyBidirectionalRelation(mmd, clr, ec, changes);
                continue;
            }
            if (relationType != RelationType.MANY_TO_MANY_BI) continue;
            changes = (List)oldValue;
            this.processManyToManyBidirectionalRelation(mmd, clr, ec, changes);
        }
    }

    protected void checkOneToOneBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ExecutionContext ec, Object oldValue, Object newValue) {
        if (newValue != null) {
            AbstractMemberMetaData relatedMmd = mmd.getRelatedMemberMetaDataForObject(clr, this.pc, newValue);
            ObjectProvider newOP = ec.findObjectProvider(newValue);
            if (newOP != null && relatedMmd != null) {
                RelationshipManager newRelMgr;
                Object newValueFieldValue;
                if (!newOP.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber())) {
                    newOP.loadField(relatedMmd.getAbsoluteFieldNumber());
                }
                if ((newValueFieldValue = newOP.provideField(relatedMmd.getAbsoluteFieldNumber())) != this.pc && (newRelMgr = ec.getRelationshipManager(newOP)) != null && newRelMgr.managesField(relatedMmd.getAbsoluteFieldNumber())) {
                    if (newValueFieldValue == null) {
                        String msg = LOCALISER.msg("013003", (Object)StringUtils.toJVMIDString(this.pc), (Object)mmd.getName(), (Object)StringUtils.toJVMIDString(newValue), (Object)relatedMmd.getName());
                        NucleusLogger.PERSISTENCE.error(msg);
                        throw new NucleusUserException(msg);
                    }
                    String msg = LOCALISER.msg("013002", (Object)StringUtils.toJVMIDString(this.pc), (Object)mmd.getName(), (Object)StringUtils.toJVMIDString(newValue), (Object)relatedMmd.getName(), (Object)StringUtils.toJVMIDString(newValueFieldValue));
                    NucleusLogger.PERSISTENCE.error(msg);
                    throw new NucleusUserException(msg);
                }
            }
        }
    }

    protected void checkOneToManyBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ExecutionContext ec, List<RelationChange> changes) {
        for (RelationChange change : changes) {
            Object newValueFieldValue;
            RelationshipManager newElementRelMgr;
            ObjectProvider newElementOP;
            AbstractMemberMetaData relatedMmd;
            if (change.type == ChangeType.ADD_OBJECT) {
                if (this.ownerOP.getExecutionContext().getApiAdapter().isDeleted(change.value)) {
                    throw new NucleusUserException(LOCALISER.msg("013008", (Object)StringUtils.toJVMIDString(this.pc), (Object)mmd.getName(), (Object)StringUtils.toJVMIDString(change.value)));
                }
                relatedMmd = mmd.getRelatedMemberMetaData(clr)[0];
                newElementOP = ec.findObjectProvider(change.value);
                if (newElementOP == null || !newElementOP.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber()) || (newElementRelMgr = ec.getRelationshipManager(newElementOP)) == null || !newElementRelMgr.managesField(relatedMmd.getAbsoluteFieldNumber()) || (newValueFieldValue = newElementOP.provideField(relatedMmd.getAbsoluteFieldNumber())) == this.pc || newValueFieldValue == null) continue;
                throw new NucleusUserException(LOCALISER.msg("013009", (Object)StringUtils.toJVMIDString(this.pc), (Object)mmd.getName(), (Object)StringUtils.toJVMIDString(change.value), (Object)StringUtils.toJVMIDString(newValueFieldValue)));
            }
            if (change.type != ChangeType.REMOVE_OBJECT || this.ownerOP.getExecutionContext().getApiAdapter().isDeleted(change.value)) continue;
            relatedMmd = mmd.getRelatedMemberMetaData(clr)[0];
            newElementOP = ec.findObjectProvider(change.value);
            if (newElementOP == null || !newElementOP.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber()) || (newElementRelMgr = ec.getRelationshipManager(newElementOP)) == null || !newElementRelMgr.managesField(relatedMmd.getAbsoluteFieldNumber()) || (newValueFieldValue = newElementOP.provideField(relatedMmd.getAbsoluteFieldNumber())) != this.pc) continue;
            throw new NucleusUserException(LOCALISER.msg("013010", (Object)StringUtils.toJVMIDString(this.pc), (Object)mmd.getName(), (Object)StringUtils.toJVMIDString(change.value)));
        }
    }

    protected void checkManyToOneBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ExecutionContext ec, Object oldValue, Object newValue) {
    }

    protected void checkManyToManyBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ExecutionContext ec, List<RelationChange> changes) {
    }

    protected void processOneToOneBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ExecutionContext ec, Object oldValue, Object newValue) {
        AbstractMemberMetaData relatedMmd;
        if (oldValue != null) {
            boolean oldIsDeleted;
            relatedMmd = mmd.getRelatedMemberMetaDataForObject(clr, this.pc, oldValue);
            ObjectProvider oldOP = ec.findObjectProvider(oldValue);
            if (oldOP != null && !(oldIsDeleted = ec.getApiAdapter().isDeleted(oldOP.getObject()))) {
                Object oldValueFieldValue;
                if (!oldOP.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber())) {
                    oldOP.loadField(relatedMmd.getAbsoluteFieldNumber());
                }
                if ((oldValueFieldValue = oldOP.provideField(relatedMmd.getAbsoluteFieldNumber())) != null && oldValueFieldValue == this.pc) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013004", (Object)StringUtils.toJVMIDString(oldValue), (Object)relatedMmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(this.pc), (Object)StringUtils.toJVMIDString(newValue)));
                    }
                    oldOP.replaceFieldValue(relatedMmd.getAbsoluteFieldNumber(), null);
                }
            }
        }
        if (newValue != null) {
            relatedMmd = mmd.getRelatedMemberMetaDataForObject(clr, this.pc, newValue);
            ObjectProvider newOP = ec.findObjectProvider(newValue);
            if (newOP != null && relatedMmd != null) {
                Object newValueFieldValue;
                if (!newOP.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber())) {
                    newOP.loadField(relatedMmd.getAbsoluteFieldNumber());
                }
                if ((newValueFieldValue = newOP.provideField(relatedMmd.getAbsoluteFieldNumber())) == null) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013005", (Object)StringUtils.toJVMIDString(newValue), (Object)relatedMmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(this.pc)));
                    }
                    newOP.replaceFieldValue(relatedMmd.getAbsoluteFieldNumber(), this.pc);
                } else if (newValueFieldValue != this.pc) {
                    ObjectProvider newValueFieldOP = ec.findObjectProvider(newValueFieldValue);
                    if (newValueFieldOP != null) {
                        if (!newValueFieldOP.isFieldLoaded(mmd.getAbsoluteFieldNumber())) {
                            newValueFieldOP.loadField(mmd.getAbsoluteFieldNumber());
                        }
                        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013004", (Object)StringUtils.toJVMIDString(newValueFieldValue), (Object)mmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(newValue), (Object)StringUtils.toJVMIDString(this.pc)));
                        }
                        newValueFieldOP.replaceFieldValue(mmd.getAbsoluteFieldNumber(), null);
                    }
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013005", (Object)StringUtils.toJVMIDString(newValue), (Object)relatedMmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(this.pc)));
                    }
                    newOP.replaceFieldValue(relatedMmd.getAbsoluteFieldNumber(), this.pc);
                }
            }
        }
    }

    protected void processOneToManyBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ExecutionContext ec, List<RelationChange> changes) {
        for (RelationChange change : changes) {
            Object currentVal;
            AbstractMemberMetaData relatedMmd;
            Object attached;
            if (change.type != ChangeType.ADD_OBJECT && change.type != ChangeType.REMOVE_OBJECT) continue;
            ObjectProvider op = ec.findObjectProvider(change.value);
            if (op == null && ec.getApiAdapter().isDetached(change.value) && (attached = ec.getAttachedObjectForId(ec.getApiAdapter().getIdForObject(change.value))) != null) {
                op = ec.findObjectProvider(attached);
            }
            if (op == null) continue;
            if (change.type == ChangeType.ADD_OBJECT) {
                relatedMmd = mmd.getRelatedMemberMetaData(clr)[0];
                if (op.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber())) {
                    currentVal = op.provideField(relatedMmd.getAbsoluteFieldNumber());
                    if (currentVal == this.ownerOP.getObject()) continue;
                    op.replaceFieldValue(relatedMmd.getAbsoluteFieldNumber(), this.ownerOP.getObject());
                    continue;
                }
                this.ownerOP.getExecutionContext().removeObjectFromLevel2Cache(op.getInternalObjectId());
                continue;
            }
            if (change.type != ChangeType.REMOVE_OBJECT) continue;
            relatedMmd = mmd.getRelatedMemberMetaData(clr)[0];
            if (op.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber())) {
                currentVal = op.provideField(relatedMmd.getAbsoluteFieldNumber());
                if (currentVal != this.ownerOP.getObject()) continue;
                op.replaceFieldValue(relatedMmd.getAbsoluteFieldNumber(), null);
                continue;
            }
            this.ownerOP.getExecutionContext().removeObjectFromLevel2Cache(op.getInternalObjectId());
        }
    }

    protected void processManyToOneBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ExecutionContext ec, Object oldValue, Object newValue) {
        AbstractMemberMetaData relatedMmd;
        if (oldValue != null) {
            relatedMmd = mmd.getRelatedMemberMetaDataForObject(clr, this.pc, oldValue);
            ObjectProvider oldOP = ec.findObjectProvider(oldValue);
            if (oldOP != null && relatedMmd != null && oldOP.getLoadedFields()[relatedMmd.getAbsoluteFieldNumber()]) {
                Collection oldColl;
                Object oldContainerValue;
                if (oldOP.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber()) && (oldContainerValue = oldOP.provideField(relatedMmd.getAbsoluteFieldNumber())) instanceof Collection && (oldColl = (Collection)oldContainerValue).contains(this.pc)) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013006", (Object)StringUtils.toJVMIDString(this.pc), (Object)mmd.getFullFieldName(), (Object)relatedMmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(oldValue)));
                    }
                    if (oldColl instanceof SCOCollection) {
                        ((SCOCollection)((Object)oldColl)).remove(this.pc, false);
                    } else {
                        oldColl.remove(this.pc);
                    }
                }
            } else if (oldOP != null) {
                this.ownerOP.getExecutionContext().removeObjectFromLevel2Cache(oldOP.getInternalObjectId());
            }
        }
        if (newValue != null) {
            relatedMmd = mmd.getRelatedMemberMetaDataForObject(clr, this.pc, newValue);
            ObjectProvider newOP = ec.findObjectProvider(newValue);
            if (newOP != null && relatedMmd != null && newOP.getLoadedFields()[relatedMmd.getAbsoluteFieldNumber()]) {
                Collection newColl;
                Object newContainerValue = newOP.provideField(relatedMmd.getAbsoluteFieldNumber());
                if (newContainerValue instanceof Collection && !(newColl = (Collection)newContainerValue).contains(this.pc)) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013007", (Object)StringUtils.toJVMIDString(this.pc), (Object)mmd.getFullFieldName(), (Object)relatedMmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(newValue)));
                    }
                    newColl.add(this.pc);
                }
            } else {
                this.ownerOP.getExecutionContext().removeObjectFromLevel2Cache(this.ownerOP.getExecutionContext().getApiAdapter().getIdForObject(newValue));
            }
        }
    }

    protected void processManyToManyBidirectionalRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, ExecutionContext ec, List<RelationChange> changes) {
        for (RelationChange change : changes) {
            Collection currentVal;
            AbstractMemberMetaData relatedMmd;
            Object attached;
            if (change.type != ChangeType.ADD_OBJECT && change.type != ChangeType.REMOVE_OBJECT) continue;
            ObjectProvider op = ec.findObjectProvider(change.value);
            if (op == null && ec.getApiAdapter().isDetached(change.value) && (attached = ec.getAttachedObjectForId(ec.getApiAdapter().getIdForObject(change.value))) != null) {
                op = ec.findObjectProvider(attached);
            }
            if (op == null) continue;
            if (change.type == ChangeType.ADD_OBJECT) {
                relatedMmd = mmd.getRelatedMemberMetaData(clr)[0];
                this.ownerOP.getExecutionContext().removeObjectFromLevel2Cache(op.getInternalObjectId());
                this.ownerOP.getExecutionContext().removeObjectFromLevel2Cache(this.ownerOP.getInternalObjectId());
                if (this.ownerOP.isFieldLoaded(mmd.getAbsoluteFieldNumber()) && !this.ownerOP.getLifecycleState().isDeleted && (currentVal = (Collection)this.ownerOP.provideField(mmd.getAbsoluteFieldNumber())) != null && !currentVal.contains(op.getObject())) {
                    currentVal.add(op.getObject());
                }
                if (!op.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber()) || (currentVal = (Collection)op.provideField(relatedMmd.getAbsoluteFieldNumber())) == null || currentVal.contains(this.ownerOP.getObject())) continue;
                currentVal.add(this.ownerOP.getObject());
                continue;
            }
            if (change.type != ChangeType.REMOVE_OBJECT) continue;
            relatedMmd = mmd.getRelatedMemberMetaData(clr)[0];
            this.ownerOP.getExecutionContext().removeObjectFromLevel2Cache(op.getInternalObjectId());
            this.ownerOP.getExecutionContext().removeObjectFromLevel2Cache(this.ownerOP.getInternalObjectId());
            if (this.ownerOP.isFieldLoaded(mmd.getAbsoluteFieldNumber()) && !this.ownerOP.getLifecycleState().isDeleted) {
                currentVal = (Collection)this.ownerOP.provideField(mmd.getAbsoluteFieldNumber());
                if (!op.getLifecycleState().isDeleted && currentVal != null && currentVal.contains(op.getObject())) {
                    currentVal.remove(op.getObject());
                } else {
                    this.ownerOP.unloadField(mmd.getName());
                }
            }
            if (!op.isFieldLoaded(relatedMmd.getAbsoluteFieldNumber()) || op.getLifecycleState().isDeleted || (currentVal = (Collection)op.provideField(relatedMmd.getAbsoluteFieldNumber())) == null || !currentVal.contains(this.ownerOP.getObject())) continue;
            currentVal.remove(this.ownerOP.getObject());
        }
    }

    private static class RelationChange {
        ChangeType type;
        Object value;
        Object oldValue;

        public RelationChange(ChangeType type, Object val) {
            this.type = type;
            this.value = val;
        }

        public RelationChange(ChangeType type, Object val, Object oldVal) {
            this.type = type;
            this.value = val;
            this.oldValue = oldVal;
        }

        public String toString() {
            if (this.oldValue != null) {
                return "RelationChange type=" + (Object)((Object)this.type) + " value=" + StringUtils.toJVMIDString(this.oldValue) + " -> " + StringUtils.toJVMIDString(this.value);
            }
            return "RelationChange type=" + (Object)((Object)this.type) + " value=" + StringUtils.toJVMIDString(this.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ChangeType {
        ADD_OBJECT,
        REMOVE_OBJECT,
        CHANGE_OBJECT;

    }
}

